/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.base;

import com.google.gxp.com.google.common.base.Objects;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.compiler.base.Expression;
import com.google.gxp.compiler.base.ExpressionVisitor;
import com.google.gxp.compiler.base.SpaceOperatorSet;

public class CollapseExpression
extends Expression {
    private final Expression subexpression;
    private final SpaceOperatorSet spaceOperators;

    private CollapseExpression(Expression subexpression, SpaceOperatorSet spaceOperators) {
        super(subexpression);
        this.subexpression = Preconditions.checkNotNull(subexpression);
        this.spaceOperators = Preconditions.checkNotNull(spaceOperators);
        if (subexpression instanceof CollapseExpression) {
            throw new IllegalArgumentException("CollapseExpressions can't be directly nested");
        }
    }

    public static CollapseExpression create(Expression subexpression, SpaceOperatorSet spaceOperators) {
        if (subexpression instanceof CollapseExpression) {
            CollapseExpression subCollapse = (CollapseExpression)subexpression;
            spaceOperators = subCollapse.getSpaceOperators().inheritFrom(spaceOperators);
            if (spaceOperators.equals(subCollapse.getSpaceOperators())) {
                return subCollapse;
            }
            subexpression = subCollapse.getSubexpression();
        }
        return new CollapseExpression(subexpression, spaceOperators);
    }

    public Expression getSubexpression() {
        return this.subexpression;
    }

    public Expression withSubexpression(Expression newSubexpression) {
        return newSubexpression.equals(this.subexpression) ? this : new CollapseExpression(newSubexpression, this.spaceOperators);
    }

    public SpaceOperatorSet getSpaceOperators() {
        return this.spaceOperators;
    }

    @Override
    public boolean alwaysOnlyWhitespace() {
        return this.subexpression.alwaysOnlyWhitespace();
    }

    @Override
    public <T> T acceptVisitor(ExpressionVisitor<T> visitor) {
        return visitor.visitCollapseExpression(this);
    }

    @Override
    public boolean hasStaticString() {
        return this.getSubexpression().hasStaticString();
    }

    @Override
    public boolean equals(Object that) {
        return this == that || that instanceof CollapseExpression && this.equals((CollapseExpression)that);
    }

    public boolean equals(CollapseExpression that) {
        return this.equalsExpression(that) && Objects.equal(this.getSubexpression(), that.getSubexpression()) && Objects.equal(this.spaceOperators, that.getSpaceOperators());
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.expressionHashCode(), this.getSubexpression(), this.getSpaceOperators());
    }
}

