/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.parser;

import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.compiler.alerts.AlertSetBuilder;
import com.google.gxp.compiler.alerts.SourcePosition;
import com.google.gxp.compiler.fs.FileRef;
import com.google.gxp.compiler.parser.DefaultXmlEventHandler;
import com.google.gxp.compiler.parser.NamespaceSet;
import com.google.gxp.compiler.parser.ParseTree;
import com.google.gxp.compiler.parser.SourceEntityResolver;
import com.google.gxp.compiler.parser.UnsupportedExternalEntityError;
import com.google.gxp.compiler.parser.UnsupportedExternalEntityException;
import com.google.gxp.compiler.parser.XmlParser;
import com.google.gxp.compiler.schema.SchemaFactory;
import java.io.IOException;

public class Parser {
    private final SchemaFactory schemaFactory;
    private final XmlParser xmlParser;
    private final NamespaceSet namespaces;
    private final SourceEntityResolver entityResolver;

    public Parser(SchemaFactory schemaFactory, XmlParser xmlParser, SourceEntityResolver entityResolver) {
        this.schemaFactory = Preconditions.checkNotNull(schemaFactory);
        this.xmlParser = Preconditions.checkNotNull(xmlParser);
        this.namespaces = new NamespaceSet(schemaFactory);
        this.entityResolver = Preconditions.checkNotNull(entityResolver);
    }

    public SchemaFactory getSchemaFactory() {
        return this.schemaFactory;
    }

    public ParseTree parse(FileRef input) throws IOException {
        AlertSetBuilder alertSetBuilder = new AlertSetBuilder();
        DefaultXmlEventHandler eventHandler = new DefaultXmlEventHandler(this.namespaces, alertSetBuilder, this.entityResolver);
        try {
            this.xmlParser.parse(input, eventHandler);
        }
        catch (UnsupportedExternalEntityException e) {
            alertSetBuilder.add(new UnsupportedExternalEntityError(e.getSourcePosition(), e.getEntity()));
        }
        return new ParseTree(new SourcePosition(input), alertSetBuilder.buildAndClear(), eventHandler.getParsedRoots());
    }
}

