/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.parser;

import com.google.gxp.com.google.common.collect.ImmutableList;
import com.google.gxp.com.google.common.collect.Iterables;
import com.google.gxp.compiler.alerts.SourcePosition;
import com.google.gxp.compiler.base.AbstractNode;
import com.google.gxp.compiler.parser.ParsedAttribute;
import com.google.gxp.compiler.parser.ParsedElementVisitor;
import java.util.List;

public abstract class ParsedElement
extends AbstractNode {
    private final ImmutableList<ParsedAttribute> attrs;
    private final ImmutableList<ParsedElement> children;

    protected ParsedElement(SourcePosition sourcePosition, String displayName, List<ParsedAttribute> attrs, List<? extends ParsedElement> children) {
        super(sourcePosition, displayName);
        this.attrs = ImmutableList.copyOf(attrs);
        this.children = ImmutableList.copyOf(children);
    }

    public List<ParsedAttribute> getAttributes() {
        return this.attrs;
    }

    public List<ParsedElement> getChildren() {
        return this.children;
    }

    public boolean canBeRoot() {
        return false;
    }

    public abstract <T> T acceptVisitor(ParsedElementVisitor<T> var1);

    public final ParsedElement withChildren(List<ParsedElement> newChildren) {
        return this.children == newChildren || Iterables.elementsEqual(this.children, newChildren) ? this : this.withChildrenImpl(newChildren);
    }

    protected abstract ParsedElement withChildrenImpl(List<ParsedElement> var1);
}

