/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.request.render;

import java.io.IOException;
import org.apache.tiles.request.DispatchRequest;
import org.apache.tiles.request.Request;
import org.apache.tiles.request.RequestWrapper;
import org.apache.tiles.request.render.CannotRenderException;
import org.apache.tiles.request.render.Renderer;

public class DispatchRenderer
implements Renderer {
    @Override
    public void render(String path, Request request) throws IOException {
        if (path == null) {
            throw new CannotRenderException("Cannot dispatch a null path");
        }
        DispatchRequest dispatchRequest = this.getDispatchRequest(request);
        if (dispatchRequest == null) {
            throw new CannotRenderException("Cannot dispatch outside of a web environment");
        }
        dispatchRequest.dispatch(path);
    }

    @Override
    public boolean isRenderable(String path, Request request) {
        return path != null && this.getDispatchRequest(request) != null && path.startsWith("/");
    }

    private DispatchRequest getDispatchRequest(Request request) {
        Request result = request;
        while (!(result instanceof DispatchRequest) && result instanceof RequestWrapper) {
            result = ((RequestWrapper)result).getWrappedRequest();
        }
        if (!(result instanceof DispatchRequest)) {
            result = null;
        }
        return (DispatchRequest)result;
    }
}

