/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.integration.spring;

import net.sf.oval.internal.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class SpringInjector {
    private static final Log LOG = Log.getLog(SpringInjector.class);
    private static SpringInjector instance;
    @Autowired
    private AutowireCapableBeanFactory beanFactory;

    public static SpringInjector get() {
        Assert.notNull((Object)instance, (String)("No SpringInjector instance created yet. Add  <bean class=\"" + SpringInjector.class.getName() + "\" /> to your spring configuration!"));
        return instance;
    }

    protected SpringInjector() {
        LOG.info("Instantiated.");
        instance = this;
    }

    public void initialize(Object unmanagedBean) {
        this.beanFactory.initializeBean(unmanagedBean, "bean");
    }

    public void inject(Object unmanagedBean) {
        this.beanFactory.autowireBean(unmanagedBean);
    }
}

