/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.spark.internal;

/**
 * Various keys used for mapped diagnostic contexts(MDC) in logging. All structured logging keys
 * should be defined here for standardization.
 */
public enum LogKeys implements LogKey {
  ACCUMULATOR_ID,
  ACL_ENABLED,
  ACTUAL_NUM_FILES,
  ACTUAL_PARTITION_COLUMN,
  ADDED_JARS,
  ADMIN_ACLS,
  ADMIN_ACL_GROUPS,
  ADVISORY_TARGET_SIZE,
  AGGREGATE_FUNCTIONS,
  ALIGNED_FROM_TIME,
  ALIGNED_TO_TIME,
  ALPHA,
  ANALYSIS_ERROR,
  ANTLR_DFA_CACHE_DELTA,
  ANTLR_DFA_CACHE_SIZE,
  APP_ATTEMPT_ID,
  APP_ATTEMPT_SHUFFLE_MERGE_ID,
  APP_DESC,
  APP_EXECUTOR_ID,
  APP_ID,
  APP_NAME,
  APP_STATE,
  ARCHIVE_NAME,
  ARGS,
  ARTIFACTS,
  ARTIFACT_ID,
  ATTRIBUTE_MAP,
  AUTH_ENABLED,
  AVG_BATCH_PROC_TIME,
  BACKUP_FILE,
  BARRIER_EPOCH,
  BARRIER_ID,
  BATCH_ID,
  BATCH_NAME,
  BATCH_TIMES,
  BATCH_TIMESTAMP,
  BATCH_WRITE,
  BIND_ADDRESS,
  BLOCK_GENERATOR_STATUS,
  BLOCK_ID,
  BLOCK_IDS,
  BLOCK_MANAGER_ID,
  BLOCK_MANAGER_IDS,
  BLOCK_TYPE,
  BOOT,
  BOOTSTRAP_TIME,
  BOOT_TIME,
  BROADCAST,
  BROADCAST_ID,
  BROADCAST_OUTPUT_STATUS_SIZE,
  BUCKET,
  BYTECODE_SIZE,
  BYTE_BUFFER,
  BYTE_SIZE,
  CACHED_TABLE_PARTITION_METADATA_SIZE,
  CACHE_AUTO_REMOVED_SIZE,
  CACHE_SIZE,
  CACHE_UNTIL_HIGHEST_CONSUMED_SIZE,
  CACHE_UNTIL_LAST_PRODUCED_SIZE,
  CALL_SITE_LONG_FORM,
  CALL_SITE_SHORT_FORM,
  CANCEL_FUTURE_JOBS,
  CATALOG_NAME,
  CATEGORICAL_FEATURES,
  CHECKPOINT_FILE,
  CHECKPOINT_INTERVAL,
  CHECKPOINT_LOCATION,
  CHECKPOINT_PATH,
  CHECKPOINT_ROOT,
  CHECKPOINT_TIME,
  CHOSEN_WATERMARK,
  CLASSIFIER,
  CLASS_LOADER,
  CLASS_NAME,
  CLASS_PATH,
  CLASS_PATHS,
  CLAUSES,
  CLEANUP_LOCAL_DIRS,
  CLUSTER_CENTROIDS,
  CLUSTER_ID,
  CLUSTER_LABEL,
  CLUSTER_LEVEL,
  CLUSTER_WEIGHT,
  CODE,
  CODEC_LEVEL,
  CODEC_NAME,
  CODEGEN_STAGE_ID,
  COLUMN_DATA_TYPE_SOURCE,
  COLUMN_DATA_TYPE_TARGET,
  COLUMN_DEFAULT_VALUE,
  COLUMN_NAME,
  COLUMN_NAMES,
  COMMAND,
  COMMAND_OUTPUT,
  COMMITTED_VERSION,
  COMPACT_INTERVAL,
  COMPONENT,
  COMPUTE,
  CONFIG,
  CONFIG2,
  CONFIG3,
  CONFIG4,
  CONFIG5,
  CONFIG_DEPRECATION_MESSAGE,
  CONFIG_KEY_UPDATED,
  CONFIG_VERSION,
  CONSUMER,
  CONTAINER,
  CONTAINER_ID,
  CONTAINER_STATE,
  CONTEXT,
  COST,
  COUNT,
  CREATED_POOL_NAME,
  CREATION_SITE,
  CREDENTIALS_RENEWAL_INTERVAL_RATIO,
  CROSS_VALIDATION_METRIC,
  CROSS_VALIDATION_METRICS,
  CSV_HEADER_COLUMN_NAME,
  CSV_HEADER_COLUMN_NAMES,
  CSV_HEADER_LENGTH,
  CSV_SCHEMA_FIELD_NAME,
  CSV_SCHEMA_FIELD_NAMES,
  CSV_SOURCE,
  CURRENT_BATCH_ID,
  CURRENT_DISK_SIZE,
  CURRENT_FILE,
  CURRENT_MEMORY_SIZE,
  CURRENT_PATH,
  CURRENT_TIME,
  DATA,
  DATABASE_NAME,
  DATAFRAME_CACHE_ENTRY,
  DATAFRAME_ID,
  DATA_FILE,
  DATA_SOURCE,
  DATA_SOURCES,
  DEFAULT_COMPACT_INTERVAL,
  DEFAULT_ISOLATION_LEVEL,
  DEFAULT_NAME,
  DEFAULT_VALUE,
  DELAY,
  DELEGATE,
  DELTA,
  DEPRECATED_KEY,
  DERIVATIVE,
  DESCRIPTION,
  DESIRED_NUM_PARTITIONS,
  DESIRED_TREE_DEPTH,
  DESTINATION_PATH,
  DFS_FILE,
  DIFF_DELTA,
  DIVISIBLE_CLUSTER_INDICES_SIZE,
  DRIVER_ID,
  DRIVER_JVM_MEMORY,
  DRIVER_MEMORY_SIZE,
  DRIVER_STATE,
  DROPPED_PARTITIONS,
  DSTREAM,
  DURATION,
  EARLIEST_LOADED_VERSION,
  EFFECTIVE_STORAGE_LEVEL,
  ELAPSED_TIME,
  ENCODING,
  ENDPOINT_NAME,
  END_INDEX,
  END_POINT,
  END_VERSION,
  ENGINE,
  EPOCH,
  ERROR,
  ESTIMATOR_PARAM_MAP,
  EVALUATED_FILTERS,
  EVENT,
  EVENT_LOG_DESTINATION,
  EVENT_LOOP,
  EVENT_NAME,
  EVENT_QUEUE,
  EXCEPTION,
  EXECUTE_INFO,
  EXECUTE_KEY,
  EXECUTION_MEMORY_SIZE,
  EXECUTION_PLAN_LEAVES,
  EXECUTOR_BACKEND,
  EXECUTOR_ENVS,
  EXECUTOR_ENV_REGEX,
  EXECUTOR_ID,
  EXECUTOR_IDS,
  EXECUTOR_LAUNCH_COMMANDS,
  EXECUTOR_MEMORY_OFFHEAP,
  EXECUTOR_MEMORY_OVERHEAD_SIZE,
  EXECUTOR_MEMORY_SIZE,
  EXECUTOR_RESOURCES,
  EXECUTOR_SHUFFLE_INFO,
  EXECUTOR_STATE,
  EXECUTOR_TIMEOUT,
  EXECUTOR_USER_CLASS_PATH_FIRST,
  EXEC_AMOUNT,
  EXISTING_FILE,
  EXISTING_PATH,
  EXIT_CODE,
  EXPECTED_NUM_FILES,
  EXPECTED_PARTITION_COLUMN,
  EXPIRY_TIMESTAMP,
  EXPR,
  EXPR_TERMS,
  EXTENDED_EXPLAIN_GENERATOR,
  FAILED_STAGE,
  FAILED_STAGE_NAME,
  FAILURES,
  FALLBACK_VERSION,
  FEATURE_COLUMN,
  FEATURE_DIMENSION,
  FEATURE_NAME,
  FETCH_SIZE,
  FIELD_NAME,
  FIELD_TYPE,
  FILES,
  FILE_ABSOLUTE_PATH,
  FILE_END_OFFSET,
  FILE_FORMAT,
  FILE_FORMAT2,
  FILE_LENGTH_XATTR,
  FILE_MODIFICATION_TIME,
  FILE_NAME,
  FILE_NAME2,
  FILE_NAME3,
  FILE_NAMES,
  FILE_START_OFFSET,
  FILE_SYSTEM,
  FILE_VERSION,
  FILTER,
  FINAL_CONTEXT,
  FINAL_OUTPUT_PATH,
  FINAL_PATH,
  FINISH_TIME,
  FINISH_TRIGGER_DURATION,
  FLOW_NAME,
  FREE_MEMORY_SIZE,
  FROM_OFFSET,
  FROM_TIME,
  FS_DATA_OUTPUT_STREAM,
  FUNCTION_NAME,
  FUNCTION_PARAM,
  GLOBAL_INIT_FILE,
  GLOBAL_WATERMARK,
  GROUP_BY_EXPRS,
  GROUP_ID,
  HADOOP_VERSION,
  HASH_JOIN_KEYS,
  HASH_MAP_SIZE,
  HEARTBEAT,
  HEARTBEAT_INTERVAL,
  HISTORY_DIR,
  HIVE_CLIENT_VERSION,
  HIVE_METASTORE_VERSION,
  HIVE_OPERATION_STATE,
  HIVE_OPERATION_TYPE,
  HOST,
  HOSTS,
  HOST_LOCAL_BLOCKS_SIZE,
  HOST_PORT,
  HOST_PORT2,
  HUGE_METHOD_LIMIT,
  HYBRID_STORE_DISK_BACKEND,
  IDENTIFIER,
  INCOMPATIBLE_TYPES,
  INDEX,
  INDEX_FILE,
  INDEX_NAME,
  INFERENCE_MODE,
  INIT,
  INITIAL_CAPACITY,
  INITIAL_HEARTBEAT_INTERVAL,
  INIT_MODE,
  INIT_TIME,
  INPUT,
  INPUT_SPLIT,
  INTEGRAL,
  INTERRUPT_THREAD,
  INTERVAL,
  INVALID_PARAMS,
  ISOLATION_LEVEL,
  ISSUE_DATE,
  IS_NETWORK_REQUEST_DONE,
  JAR_ENTRY,
  JAR_MESSAGE,
  JAR_URL,
  JAVA_VERSION,
  JAVA_VM_NAME,
  JOB_ID,
  JOIN_CONDITION,
  JOIN_CONDITION_SUB_EXPR,
  JOIN_TYPE,
  K8S_CONTEXT,
  KEY,
  KEY2,
  KEYTAB,
  KEYTAB_FILE,
  KILL_EXECUTORS,
  KINESIS_REASON,
  LABEL_COLUMN,
  LARGEST_CLUSTER_INDEX,
  LAST_ACCESS_TIME,
  LAST_COMMITTED_CHECKPOINT_ID,
  LAST_COMMIT_BASED_CHECKPOINT_ID,
  LAST_SCAN_TIME,
  LAST_VALID_TIME,
  LATEST_BATCH_ID,
  LATEST_COMMITTED_BATCH_ID,
  LATEST_SHUFFLE_MERGE_ID,
  LEARNING_RATE,
  LEFT_EXPR,
  LEFT_LOGICAL_PLAN_STATS_SIZE_IN_BYTES,
  LINE,
  LINEAGE,
  LINE_NUM,
  LISTENER,
  LOADED_CHECKPOINT_ID,
  LOADED_VERSION,
  LOAD_FACTOR,
  LOAD_TIME,
  LOCALE,
  LOCAL_BLOCKS_SIZE,
  LOCAL_SCRATCH_DIR,
  LOCATION,
  LOGICAL_PLAN,
  LOGICAL_PLAN_COLUMNS,
  LOGICAL_PLAN_LEAVES,
  LOG_ID,
  LOG_LEVEL,
  LOG_OFFSET,
  LOG_TYPE,
  LOSSES,
  LOWER_BOUND,
  MALFORMATTED_STRING,
  MAP_ID,
  MASTER_URL,
  MAX_ATTEMPTS,
  MAX_CACHE_UNTIL_HIGHEST_CONSUMED_SIZE,
  MAX_CACHE_UNTIL_LAST_PRODUCED_SIZE,
  MAX_CAPACITY,
  MAX_CATEGORIES,
  MAX_EXECUTOR_FAILURES,
  MAX_FILE_VERSION,
  MAX_JVM_METHOD_PARAMS_LENGTH,
  MAX_MEMORY_SIZE,
  MAX_METHOD_CODE_SIZE,
  MAX_NUM_BINS,
  MAX_NUM_CHUNKS,
  MAX_NUM_FILES,
  MAX_NUM_LOG_POLICY,
  MAX_NUM_PARTITIONS,
  MAX_NUM_POSSIBLE_BINS,
  MAX_NUM_ROWS_IN_MEMORY_BUFFER,
  MAX_SEEN_VERSION,
  MAX_SERVICE_NAME_LENGTH,
  MAX_SIZE,
  MAX_SLOTS,
  MAX_SPLIT_BYTES,
  MAX_TABLE_PARTITION_METADATA_SIZE,
  MEMORY_CONSUMER,
  MEMORY_POOL_NAME,
  MEMORY_SIZE,
  MEMORY_THRESHOLD_SIZE,
  MERGE_DIR_NAME,
  MESSAGE,
  METADATA,
  METADATA_DIRECTORY,
  METADATA_JSON,
  META_FILE,
  METHOD_NAME,
  METHOD_PARAM_TYPES,
  METRICS_JSON,
  METRIC_NAME,
  MINI_BATCH_FRACTION,
  MIN_COMPACTION_BATCH_ID,
  MIN_NUM_FREQUENT_PATTERN,
  MIN_POINT_PER_CLUSTER,
  MIN_RATE,
  MIN_SEEN_VERSION,
  MIN_SHARE,
  MIN_SIZE,
  MIN_TIME,
  MIN_VERSIONS_TO_DELETE,
  MIN_VERSION_NUM,
  MISSING_PARENT_STAGES,
  MODEL_WEIGHTS,
  MODIFY_ACLS,
  MODIFY_ACLS_GROUPS,
  MODULE_NAME,
  NAME,
  NAMESPACE,
  NETWORK_IF,
  NEW_FEATURE_COLUMN_NAME,
  NEW_LABEL_COLUMN_NAME,
  NEW_PATH,
  NEW_RDD_ID,
  NEW_STATE,
  NEW_VALUE,
  NEXT_RENEWAL_TIME,
  NODES,
  NODE_LOCATION,
  NON_BUILT_IN_CONNECTORS,
  NORM,
  NUM_ADDED_PARTITIONS,
  NUM_APPS,
  NUM_ATTEMPT,
  NUM_BATCHES,
  NUM_BIN,
  NUM_BLOCKS,
  NUM_BLOCK_IDS,
  NUM_BROADCAST_BLOCK,
  NUM_BYTES,
  NUM_BYTES_CURRENT,
  NUM_BYTES_EVICTED,
  NUM_BYTES_MAX,
  NUM_BYTES_TO_FREE,
  NUM_BYTES_TO_WARN,
  NUM_BYTES_USED,
  NUM_CATEGORIES,
  NUM_CHECKSUM_FILE,
  NUM_CHUNKS,
  NUM_CLASSES,
  NUM_COEFFICIENTS,
  NUM_COLUMNS,
  NUM_CONCURRENT_WRITER,
  NUM_CORES,
  NUM_DATA_FILE,
  NUM_DATA_FILES,
  NUM_DECOMMISSIONED,
  NUM_DRIVERS,
  NUM_DROPPED_PARTITIONS,
  NUM_EFFECTIVE_RULE_OF_RUNS,
  NUM_ELEMENTS_SPILL_RECORDS,
  NUM_ELEMENTS_SPILL_THRESHOLD,
  NUM_EVENTS,
  NUM_EXAMPLES,
  NUM_EXECUTORS,
  NUM_EXECUTORS_EXITED,
  NUM_EXECUTORS_KILLED,
  NUM_EXECUTOR_CORES,
  NUM_EXECUTOR_CORES_REMAINING,
  NUM_EXECUTOR_CORES_TOTAL,
  NUM_EXECUTOR_DESIRED,
  NUM_EXECUTOR_LAUNCH,
  NUM_EXECUTOR_TARGET,
  NUM_FAILURES,
  NUM_FEATURES,
  NUM_FILES,
  NUM_FILES_COPIED,
  NUM_FILES_FAILED_TO_DELETE,
  NUM_FILES_REUSED,
  NUM_FREQUENT_ITEMS,
  NUM_HOST_LOCAL_BLOCKS,
  NUM_INDEX_FILE,
  NUM_INDEX_FILES,
  NUM_ITERATIONS,
  NUM_KAFKA_PULLS,
  NUM_KAFKA_RECORDS_PULLED,
  NUM_LAGGING_STORES,
  NUM_LEADING_SINGULAR_VALUES,
  NUM_LEFT_PARTITION_VALUES,
  NUM_LOADED_ENTRIES,
  NUM_LOCAL_BLOCKS,
  NUM_LOCAL_DIRS,
  NUM_LOCAL_FREQUENT_PATTERN,
  NUM_MERGERS,
  NUM_MERGER_LOCATIONS,
  NUM_META_FILES,
  NUM_NODES,
  NUM_PARTITIONS,
  NUM_PARTITIONS2,
  NUM_PATHS,
  NUM_PEERS,
  NUM_PEERS_REPLICATED_TO,
  NUM_PEERS_TO_REPLICATE_TO,
  NUM_PENDING_LAUNCH_TASKS,
  NUM_POD,
  NUM_POD_SHARED_SLOT,
  NUM_POD_TARGET,
  NUM_POINT,
  NUM_PREFIXES,
  NUM_PRUNED,
  NUM_PUSH_MERGED_LOCAL_BLOCKS,
  NUM_RECEIVERS,
  NUM_RECORDS_READ,
  NUM_RELEASED_LOCKS,
  NUM_REMAINED,
  NUM_REMOTE_BLOCKS,
  NUM_REMOVED_WORKERS,
  NUM_REPLICAS,
  NUM_REQUESTS,
  NUM_REQUEST_SYNC_TASK,
  NUM_RESOURCE_SLOTS,
  NUM_RETRIES,
  NUM_RETRY,
  NUM_RIGHT_PARTITION_VALUES,
  NUM_ROWS,
  NUM_RULE_OF_RUNS,
  NUM_SEQUENCES,
  NUM_SKIPPED,
  NUM_SLOTS,
  NUM_SPILLS,
  NUM_SPILL_WRITERS,
  NUM_SUB_DIRS,
  NUM_SUCCESSFUL_TASKS,
  NUM_TASKS,
  NUM_TASK_CPUS,
  NUM_TRAIN_WORD,
  NUM_UNFINISHED_DECOMMISSIONED,
  NUM_VERSIONS_RETAIN,
  NUM_WEIGHTED_EXAMPLES,
  NUM_WORKERS,
  OBJECT_AGG_SORT_BASED_FALLBACK_THRESHOLD,
  OBJECT_ID,
  OFFSET,
  OFFSETS,
  OFFSET_SEQUENCE_METADATA,
  OLD_BLOCK_MANAGER_ID,
  OLD_GENERATION_GC,
  OLD_VALUE,
  OPEN_COST_IN_BYTES,
  OPERATION,
  OPERATION_HANDLE,
  OPERATION_HANDLE_ID,
  OPERATION_ID,
  OPTIMIZED_PLAN_COLUMNS,
  OPTIMIZER_CLASS_NAME,
  OPTIONS,
  OP_ID,
  OP_TYPE,
  ORIGINAL_DISK_SIZE,
  ORIGINAL_MEMORY_SIZE,
  OS_ARCH,
  OS_NAME,
  OS_VERSION,
  OUTPUT,
  OUTPUT_BUFFER,
  OVERHEAD_MEMORY_SIZE,
  PAGE_SIZE,
  PARENT_STAGES,
  PARSE_MODE,
  PARTITIONED_FILE_READER,
  PARTITIONER,
  PARTITION_ID,
  PARTITION_IDS,
  PARTITION_SIZE,
  PARTITION_SPECIFICATION,
  PARTITION_SPECS,
  PATH,
  PATHS,
  PEER,
  PENDING_TIMES,
  PERCENT,
  PIPELINE_STAGE_UID,
  PLUGIN_NAME,
  POD_ID,
  POD_NAME,
  POD_NAMESPACE,
  POD_PHASE,
  POD_STATE,
  POINT_OF_CENTER,
  POLICY,
  POOL_NAME,
  PORT,
  PORT2,
  POST_SCAN_FILTERS,
  PREDICATE,
  PREDICATES,
  PREFERRED_SERVICE_NAME,
  PREFIX,
  PRETTY_ID_STRING,
  PRINCIPAL,
  PROCESS,
  PROCESSING_TIME,
  PRODUCER_ID,
  PROPERTY_NAME,
  PROPORTIONAL,
  PROTOCOL_VERSION,
  PROVIDER,
  PUSHED_FILTERS,
  PUSH_MERGED_LOCAL_BLOCKS_SIZE,
  PVC_METADATA_NAME,
  PYTHON_EXEC,
  PYTHON_PACKAGES,
  PYTHON_VERSION,
  PYTHON_WORKER_CHANNEL_IS_BLOCKING_MODE,
  PYTHON_WORKER_CHANNEL_IS_CONNECTED,
  PYTHON_WORKER_HAS_INPUTS,
  PYTHON_WORKER_IDLE_TIMEOUT,
  PYTHON_WORKER_IS_ALIVE,
  PYTHON_WORKER_MODULE,
  PYTHON_WORKER_RESPONSE,
  PYTHON_WORKER_SELECTION_KEY_INTERESTS,
  PYTHON_WORKER_SELECTION_KEY_IS_VALID,
  PYTHON_WORKER_SELECTOR_IS_OPEN,
  QUANTILES,
  QUERY_CACHE_VALUE,
  QUERY_HINT,
  QUERY_ID,
  QUERY_PLAN,
  QUERY_PLAN_COMPARISON,
  QUERY_PLAN_LENGTH_ACTUAL,
  QUERY_PLAN_LENGTH_MAX,
  QUERY_RUN_ID,
  RANGE,
  RATE_LIMIT,
  RATIO,
  RDD,
  RDD_CHECKPOINT_DIR,
  RDD_DEBUG_STRING,
  RDD_DESCRIPTION,
  RDD_ID,
  READ_LIMIT,
  REASON,
  REATTACHABLE,
  RECEIVED_BLOCK_INFO,
  RECEIVED_BLOCK_TRACKER_LOG_EVENT,
  RECEIVER_ID,
  RECEIVER_IDS,
  RECORDS,
  RECOVERY_STATE,
  RECURSIVE_DEPTH,
  REDACTED_STATEMENT,
  REDUCE_ID,
  REGEX,
  REGISTERED_EXECUTOR_FILE,
  REGISTER_MERGE_RESULTS,
  RELATION_NAME,
  RELATION_OUTPUT,
  RELATIVE_TOLERANCE,
  RELEASED_LOCKS,
  REMAINING_PARTITIONS,
  REMOTE_ADDRESS,
  REMOTE_BLOCKS_SIZE,
  REMOVE_FROM_MASTER,
  REPORT_DETAILS,
  REQUESTER_SIZE,
  REQUEST_EXECUTORS,
  REQUEST_ID,
  RESOURCE,
  RESOURCE_NAME,
  RESOURCE_PROFILE_ID,
  RESOURCE_PROFILE_IDS,
  RESOURCE_PROFILE_TO_TOTAL_EXECS,
  RESPONSE_BODY_SIZE,
  RESTART_TIME,
  RESULT,
  RESULT_SIZE_BYTES,
  RESULT_SIZE_BYTES_MAX,
  RETRY_INTERVAL,
  RETRY_WAIT_TIME,
  RIGHT_EXPR,
  RIGHT_LOGICAL_PLAN_STATS_SIZE_IN_BYTES,
  RMSE,
  ROCKS_DB_FILE_MAPPING,
  ROCKS_DB_LOG_LEVEL,
  ROCKS_DB_LOG_MESSAGE,
  RPC_ADDRESS,
  RPC_ENDPOINT_REF,
  RPC_MESSAGE_CAPACITY,
  RPC_SSL_ENABLED,
  RULE_EXECUTOR_NAME,
  RULE_NAME,
  RUN_ID,
  RUN_ID_STRING,
  SCALA_VERSION,
  SCALING_DOWN_RATIO,
  SCALING_UP_RATIO,
  SCHEDULER_POOL_NAME,
  SCHEDULING_MODE,
  SCHEMA,
  SCHEMA2,
  SERVER_NAME,
  SERVICE_NAME,
  SERVLET_CONTEXT_HANDLER_PATH,
  SESSION_HANDLE,
  SESSION_HOLD_INFO,
  SESSION_ID,
  SESSION_KEY,
  SET_CLIENT_INFO_REQUEST,
  SHARD_ID,
  SHORTER_SERVICE_NAME,
  SHORT_USER_NAME,
  SHUFFLE_BLOCK_INFO,
  SHUFFLE_DB_BACKEND_KEY,
  SHUFFLE_DB_BACKEND_NAME,
  SHUFFLE_ID,
  SHUFFLE_IDS,
  SHUFFLE_MERGE_ID,
  SHUFFLE_MERGE_RECOVERY_FILE,
  SHUFFLE_SERVICE_CONF_OVERLAY_URL,
  SHUFFLE_SERVICE_METRICS_NAMESPACE,
  SHUFFLE_SERVICE_NAME,
  SIGMAS_LENGTH,
  SIGNAL,
  SINK,
  SIZE,
  SLEEP_TIME,
  SLIDE_DURATION,
  SMALLEST_CLUSTER_INDEX,
  SNAPSHOT_EVENT,
  SNAPSHOT_EVENT_TIME_DELTA,
  SNAPSHOT_EVENT_VERSION_DELTA,
  SNAPSHOT_VERSION,
  SOCKET_ADDRESS,
  SOURCE,
  SOURCE_PATH,
  SPARK_BRANCH,
  SPARK_BUILD_DATE,
  SPARK_BUILD_USER,
  SPARK_DATA_STREAM,
  SPARK_PLAN_ID,
  SPARK_REPO_URL,
  SPARK_REVISION,
  SPARK_VERSION,
  SPILL_RECORDS_SIZE,
  SPILL_RECORDS_SIZE_THRESHOLD,
  SPILL_TIMES,
  SQL_TEXT,
  SRC_PATH,
  STAGE,
  STAGES,
  STAGE_ATTEMPT,
  STAGE_ATTEMPT_ID,
  STAGE_ID,
  STAGE_NAME,
  STAMP,
  START_INDEX,
  START_TIME,
  STATEMENT_ID,
  STATE_NAME,
  STATE_STORE_COORDINATOR,
  STATE_STORE_ID,
  STATE_STORE_PROVIDER,
  STATE_STORE_PROVIDER_ID,
  STATE_STORE_PROVIDER_IDS,
  STATE_STORE_STATE,
  STATE_STORE_VERSION,
  STATS,
  STATUS,
  STDERR,
  STOP_SITE_SHORT_FORM,
  STORAGE_LEVEL,
  STORAGE_LEVEL_DESERIALIZED,
  STORAGE_LEVEL_REPLICATION,
  STORAGE_MEMORY_SIZE,
  STORE_ID,
  STRATEGY,
  STREAMING_CONTEXT,
  STREAMING_DATA_SOURCE_DESCRIPTION,
  STREAMING_DATA_SOURCE_NAME,
  STREAMING_OFFSETS_END,
  STREAMING_OFFSETS_START,
  STREAMING_QUERY_PROGRESS,
  STREAMING_SOURCE,
  STREAMING_TABLE,
  STREAMING_WRITE,
  STREAM_CHUNK_ID,
  STREAM_ID,
  STREAM_NAME,
  SUBMISSION_ID,
  SUBSAMPLING_RATE,
  SUB_QUERY,
  TABLE_NAME,
  TABLE_TYPE,
  TABLE_TYPES,
  TAG,
  TARGET_NUM_EXECUTOR,
  TARGET_NUM_EXECUTOR_DELTA,
  TARGET_PATH,
  TARGET_SIZE,
  TASK_ATTEMPT_ID,
  TASK_ID,
  TASK_INDEX,
  TASK_LOCALITY,
  TASK_NAME,
  TASK_REQUIREMENTS,
  TASK_RESOURCES,
  TASK_RESOURCE_ASSIGNMENTS,
  TASK_SET_MANAGER,
  TASK_SET_NAME,
  TASK_STATE,
  TEMP_FILE,
  TEMP_OUTPUT_PATH,
  TEMP_PATH,
  TEST_SIZE,
  THREAD,
  THREAD_ID,
  THREAD_NAME,
  THREAD_POOL_KEEPALIVE_TIME,
  THREAD_POOL_SIZE,
  THREAD_POOL_WAIT_QUEUE_SIZE,
  THRESHOLD,
  THRESH_TIME,
  TIME,
  TIMEOUT,
  TIMER,
  TIMESTAMP,
  TIME_UNITS,
  TIP,
  TOKEN,
  TOKEN_KIND,
  TOKEN_REGEX,
  TOKEN_RENEWER,
  TOPIC,
  TOPIC_PARTITION,
  TOPIC_PARTITIONS,
  TOPIC_PARTITION_OFFSET,
  TOPIC_PARTITION_OFFSET_RANGE,
  TOTAL,
  TOTAL_EFFECTIVE_TIME,
  TOTAL_SIZE,
  TOTAL_TIME,
  TOTAL_TIME_READ,
  TO_TIME,
  TRAINING_SIZE,
  TRAIN_VALIDATION_SPLIT_METRIC,
  TRAIN_VALIDATION_SPLIT_METRICS,
  TRANSFER_TYPE,
  TREE_NODE,
  TRIGGER_INTERVAL,
  UI_ACLS,
  UI_FILTER,
  UI_FILTER_PARAMS,
  UI_PROXY_BASE,
  UNKNOWN_PARAM,
  UNSUPPORTED_EXPR,
  UNSUPPORTED_HINT_REASON,
  UNTIL_OFFSET,
  UPPER_BOUND,
  URI,
  URIS,
  URL,
  URL2,
  URLS,
  USER_ID,
  USER_NAME,
  UUID,
  VALUE,
  VERSIONS_TO_DELETE,
  VERSION_NUM,
  VIEW_ACLS,
  VIEW_ACLS_GROUPS,
  VIRTUAL_CORES,
  VOCAB_SIZE,
  WAIT_RESULT_TIME,
  WAIT_SEND_TIME,
  WATERMARK_CONSTRAINT,
  WEB_URL,
  WEIGHT,
  WORKER,
  WORKER_HOST,
  WORKER_ID,
  WORKER_PORT,
  WORKER_URL,
  WRITE_AHEAD_LOG_INFO,
  WRITE_AHEAD_LOG_RECORD_HANDLE,
  WRITE_JOB_UUID,
  XML_SCHEDULING_MODE,
  XSD_PATH,
  YARN_RESOURCE,
  YOUNG_GENERATION_GC,
  ZERO_TIME
}
