% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/DataFrame.R
\name{unpivot}
\alias{unpivot}
\alias{unpivot,SparkDataFrame,ANY,ANY,character,character-method}
\alias{melt}
\alias{melt,SparkDataFrame,ANY,ANY,character,character-method}
\title{Unpivot a DataFrame from wide format to long format.}
\usage{
unpivot(x, ids, values, variableColumnName, valueColumnName)

\S4method{unpivot}{SparkDataFrame,ANY,ANY,character,character}(x, ids, values, variableColumnName, valueColumnName)

\S4method{melt}{SparkDataFrame,ANY,ANY,character,character}(x, ids, values, variableColumnName, valueColumnName)
}
\arguments{
\item{x}{a SparkDataFrame.}

\item{ids}{a character vector or a list of columns}

\item{values}{a character vector, a list of columns or \code{NULL}.
If not NULL must not be empty. If \code{NULL}, uses all columns that
are not set as \code{ids}.}

\item{variableColumnName}{character Name of the variable column.}

\item{valueColumnName}{character Name of the value column.}
}
\value{
a SparkDataFrame.
}
\description{
This is the reverse to \code{groupBy(...).pivot(...).agg(...)},
except for the aggregation, which cannot be reversed.
}
\note{
unpivot since 3.4.0

melt since 3.4.0
}
\examples{
\dontrun{
df <- createDataFrame(data.frame(
  id = 1:3, x = c(1, 3, 5), y = c(2, 4, 6), z = c(-1, 0, 1)
))

head(unpivot(df, "id", c("x", "y"), "var", "val"))

head(unpivot(df, "id", NULL, "var", "val"))
}
}
\seealso{
Other SparkDataFrame functions: 
\code{\link{SparkDataFrame-class}},
\code{\link{agg}()},
\code{\link{alias}()},
\code{\link{arrange}()},
\code{\link{as.data.frame}()},
\code{\link{attach,SparkDataFrame-method}},
\code{\link{broadcast}()},
\code{\link{cache}()},
\code{\link{checkpoint}()},
\code{\link{coalesce}()},
\code{\link{collect}()},
\code{\link{colnames}()},
\code{\link{coltypes}()},
\code{\link{createOrReplaceTempView}()},
\code{\link{crossJoin}()},
\code{\link{cube}()},
\code{\link{dapplyCollect}()},
\code{\link{dapply}()},
\code{\link{describe}()},
\code{\link{dim}()},
\code{\link{distinct}()},
\code{\link{dropDuplicates}()},
\code{\link{dropna}()},
\code{\link{drop}()},
\code{\link{dtypes}()},
\code{\link{exceptAll}()},
\code{\link{except}()},
\code{\link{explain}()},
\code{\link{filter}()},
\code{\link{first}()},
\code{\link{gapplyCollect}()},
\code{\link{gapply}()},
\code{\link{getNumPartitions}()},
\code{\link{group_by}()},
\code{\link{head}()},
\code{\link{hint}()},
\code{\link{histogram}()},
\code{\link{insertInto}()},
\code{\link{intersectAll}()},
\code{\link{intersect}()},
\code{\link{isLocal}()},
\code{\link{isStreaming}()},
\code{\link{join}()},
\code{\link{limit}()},
\code{\link{localCheckpoint}()},
\code{\link{merge}()},
\code{\link{mutate}()},
\code{\link{ncol}()},
\code{\link{nrow}()},
\code{\link{persist}()},
\code{\link{printSchema}()},
\code{\link{randomSplit}()},
\code{\link{rbind}()},
\code{\link{rename}()},
\code{\link{repartitionByRange}()},
\code{\link{repartition}()},
\code{\link{rollup}()},
\code{\link{sample}()},
\code{\link{saveAsTable}()},
\code{\link{schema}()},
\code{\link{selectExpr}()},
\code{\link{select}()},
\code{\link{showDF}()},
\code{\link{show}()},
\code{\link{storageLevel}()},
\code{\link{str}()},
\code{\link{subset}()},
\code{\link{summary}()},
\code{\link{take}()},
\code{\link{toJSON}()},
\code{\link{unionAll}()},
\code{\link{unionByName}()},
\code{\link{union}()},
\code{\link{unpersist}()},
\code{\link{withColumn}()},
\code{\link{withWatermark}()},
\code{\link{with}()},
\code{\link{write.df}()},
\code{\link{write.jdbc}()},
\code{\link{write.json}()},
\code{\link{write.orc}()},
\code{\link{write.parquet}()},
\code{\link{write.stream}()},
\code{\link{write.text}()}
}
\concept{SparkDataFrame functions}
