/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import org.apache.datasketches.quantiles.DoublesBufferAccessor;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.quantiles.DoublesSketchAccessor;
import org.apache.datasketches.quantiles.Util;

class DoublesPmfCdfImpl {
    DoublesPmfCdfImpl() {
    }

    static double[] getPMFOrCDF(DoublesSketch sketch, double[] splitPoints, boolean isCDF) {
        double[] buckets = DoublesPmfCdfImpl.internalBuildHistogram(sketch, splitPoints);
        long n = sketch.getN();
        if (isCDF) {
            double subtotal = 0.0;
            for (int j = 0; j < buckets.length; ++j) {
                buckets[j] = (subtotal += buckets[j]) / (double)n;
            }
        } else {
            int j = 0;
            while (j < buckets.length) {
                int n2 = j++;
                buckets[n2] = buckets[n2] / (double)n;
            }
        }
        return buckets;
    }

    private static double[] internalBuildHistogram(DoublesSketch sketch, double[] splitPoints) {
        long myBitPattern;
        DoublesSketchAccessor sketchAccessor = DoublesSketchAccessor.wrap(sketch);
        Util.checkSplitPointsOrder(splitPoints);
        int numSplitPoints = splitPoints.length;
        int numCounters = numSplitPoints + 1;
        double[] counters = new double[numCounters];
        long weight = 1L;
        sketchAccessor.setLevel(-1);
        if (numSplitPoints < 50) {
            DoublesPmfCdfImpl.bilinearTimeIncrementHistogramCounters(sketchAccessor, weight, splitPoints, counters);
        } else {
            sketchAccessor.sort();
            DoublesPmfCdfImpl.linearTimeIncrementHistogramCounters(sketchAccessor, weight, splitPoints, counters);
        }
        int k = sketch.getK();
        assert (myBitPattern == sketch.getN() / (2L * (long)k));
        int lvl = 0;
        for (myBitPattern = sketch.getBitPattern(); myBitPattern != 0L; myBitPattern >>>= 1) {
            weight <<= 1;
            if ((myBitPattern & 1L) > 0L) {
                sketchAccessor.setLevel(lvl);
                DoublesPmfCdfImpl.linearTimeIncrementHistogramCounters(sketchAccessor, weight, splitPoints, counters);
            }
            ++lvl;
        }
        return counters;
    }

    static void bilinearTimeIncrementHistogramCounters(DoublesBufferAccessor samples, long weight, double[] splitPoints, double[] counters) {
        assert (splitPoints.length + 1 == counters.length);
        for (int i = 0; i < samples.numItems(); ++i) {
            double splitpoint;
            int j;
            double sample = samples.get(i);
            for (j = 0; j < splitPoints.length && !(sample < (splitpoint = splitPoints[j])); ++j) {
            }
            assert (j < counters.length);
            int n = j;
            counters[n] = counters[n] + (double)weight;
        }
    }

    static void linearTimeIncrementHistogramCounters(DoublesBufferAccessor samples, long weight, double[] splitPoints, double[] counters) {
        int i = 0;
        int j = 0;
        while (i < samples.numItems() && j < splitPoints.length) {
            if (samples.get(i) < splitPoints[j]) {
                int n = j;
                counters[n] = counters[n] + (double)weight;
                ++i;
                continue;
            }
            ++j;
        }
        if (j == splitPoints.length) {
            int n = j;
            counters[n] = counters[n] + (double)(weight * (long)(samples.numItems() - i));
        }
    }
}

