/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.mllib.classification.SVMModel;
import org.apache.spark.mllib.classification.SVMWithSGD;
import org.apache.spark.mllib.evaluation.BinaryClassificationMetrics;
import org.apache.spark.mllib.util.MLUtils;
import org.apache.spark.rdd.RDD;
import scala.Tuple2;

public class JavaSVMWithSGDExample {
    public static void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("JavaSVMWithSGDExample");
        SparkContext sc = new SparkContext(conf);
        String path = "data/mllib/sample_libsvm_data.txt";
        JavaRDD data = MLUtils.loadLibSVMFile((SparkContext)sc, (String)path).toJavaRDD();
        JavaRDD training = data.sample(false, 0.6, 11L);
        training.cache();
        JavaRDD test = data.subtract(training);
        int numIterations = 100;
        SVMModel model = SVMWithSGD.train((RDD)training.rdd(), (int)numIterations);
        model.clearThreshold();
        JavaRDD scoreAndLabels = test.map((Function & Serializable)p -> new Tuple2((Object)model.predict(p.features()), (Object)p.label()));
        BinaryClassificationMetrics metrics = new BinaryClassificationMetrics(JavaRDD.toRDD((JavaRDD)scoreAndLabels));
        double auROC = metrics.areaUnderROC();
        System.out.println("Area under ROC = " + auROC);
        model.save(sc, "target/tmp/javaSVMWithSGDModel");
        SVMModel sameModel = SVMModel.load((SparkContext)sc, (String)"target/tmp/javaSVMWithSGDModel");
        sc.stop();
    }
}

