/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2;

import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.ColumnSet;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.objectinspector.MetadataListStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class TestSerDe
implements SerDe {
    public static final Log LOG = LogFactory.getLog((String)TestSerDe.class.getName());
    public static final String DefaultSeparator = "\u0002";
    private String separator = "\u0002";
    private String nullString = "\\N";
    private List<String> columnNames;
    private ObjectInspector cachedObjectInspector;
    ColumnSet deserializeCache = new ColumnSet();
    Text serializeCache = new Text();

    public String getShortName() {
        return TestSerDe.shortName();
    }

    public static String shortName() {
        return "test_meta";
    }

    public String toString() {
        return "TestSerDe[" + this.separator + "," + this.columnNames + "]";
    }

    public void initialize(Configuration configuration, Properties properties) throws SerDeException {
        Object object;
        this.separator = DefaultSeparator;
        String string = properties.getProperty("testserde.default.serialization.format");
        if (string != null && string.length() > 0) {
            try {
                object = new byte[1];
                object[0] = Byte.valueOf(string);
                this.separator = new String((byte[])object);
            }
            catch (NumberFormatException numberFormatException) {
                this.separator = string;
            }
        }
        if ((object = properties.getProperty("columns")) == null || ((String)object).length() == 0) {
            this.cachedObjectInspector = ObjectInspectorFactory.getReflectionObjectInspector(ColumnSet.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
        } else {
            this.columnNames = Arrays.asList(((String)object).split(","));
            this.cachedObjectInspector = MetadataListStructObjectInspector.getInstance(this.columnNames);
        }
        LOG.info((Object)(this.getClass().getName() + ": initialized with columnNames: " + this.columnNames));
    }

    public static Object deserialize(ColumnSet columnSet, String string, String string2, String string3) throws Exception {
        String[] stringArray;
        if (columnSet.col == null) {
            columnSet.col = new ArrayList();
        } else {
            columnSet.col.clear();
        }
        for (String string4 : stringArray = string.split(string2, -1)) {
            if (string4.equals(string3)) {
                columnSet.col.add(null);
                continue;
            }
            columnSet.col.add(string4);
        }
        return columnSet;
    }

    public Object deserialize(Writable writable) throws SerDeException {
        String string = null;
        if (writable instanceof BytesWritable) {
            BytesWritable bytesWritable = (BytesWritable)writable;
            try {
                string = Text.decode((byte[])bytesWritable.get(), (int)0, (int)bytesWritable.getSize());
            }
            catch (CharacterCodingException characterCodingException) {
                throw new SerDeException((Throwable)characterCodingException);
            }
        } else if (writable instanceof Text) {
            string = writable.toString();
        }
        try {
            TestSerDe.deserialize(this.deserializeCache, string, this.separator, this.nullString);
            if (this.columnNames != null) assert (this.columnNames.size() == this.deserializeCache.col.size());
            return this.deserializeCache;
        }
        catch (ClassCastException classCastException) {
            throw new SerDeException(this.getClass().getName() + " expects Text or BytesWritable", (Throwable)classCastException);
        }
        catch (Exception exception) {
            throw new SerDeException((Throwable)exception);
        }
    }

    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.cachedObjectInspector;
    }

    public Class<? extends Writable> getSerializedClass() {
        return Text.class;
    }

    public Writable serialize(Object object, ObjectInspector objectInspector) throws SerDeException {
        if (objectInspector.getCategory() != ObjectInspector.Category.STRUCT) {
            throw new SerDeException(this.getClass().toString() + " can only serialize struct types, but we got: " + objectInspector.getTypeName());
        }
        StructObjectInspector structObjectInspector = (StructObjectInspector)objectInspector;
        List list = structObjectInspector.getAllStructFieldRefs();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(this.separator);
            }
            Object object2 = structObjectInspector.getStructFieldData(object, (StructField)list.get(i));
            if (((StructField)list.get(i)).getFieldObjectInspector().getCategory() == ObjectInspector.Category.PRIMITIVE) {
                stringBuilder.append(object2 == null ? this.nullString : object2.toString());
                continue;
            }
            stringBuilder.append(SerDeUtils.getJSONString((Object)object2, (ObjectInspector)((StructField)list.get(i)).getFieldObjectInspector()));
        }
        this.serializeCache.set(stringBuilder.toString());
        return this.serializeCache;
    }

    static {
        StackTraceElement[] stackTraceElementArray = new Exception().getStackTrace();
        String string = stackTraceElementArray[0].getClassName();
        try {
            SerDeUtils.registerSerDe((String)TestSerDe.shortName(), Class.forName(string));
            SerDeUtils.registerSerDe((String)"org.apache.hadoop.hive.serde.TestSerDe", Class.forName(string));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

