% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/column.R
\name{withField}
\alias{withField}
\alias{withField,Column,character,Column-method}
\alias{withField,Column-method}
\title{withField}
\usage{
withField(x, fieldName, col)

\S4method{withField}{Column,character,Column}(x, fieldName, col)
}
\arguments{
\item{x}{a Column}

\item{fieldName}{a character}

\item{col}{a Column expression}
}
\description{
Adds/replaces field in a struct \code{Column} by name.
}
\note{
withField since 3.1.0
}
\examples{
\dontrun{
df <- withColumn(
  createDataFrame(iris),
  "sepal",
   struct(column("Sepal_Width"), column("Sepal_Length"))
)

head(select(
  df,
  withField(df$sepal, "product", df$Sepal_Length * df$Sepal_Width)
))
}
}
