/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.gc;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jackrabbit.oak.spi.gc.GCMonitor;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.jetbrains.annotations.NotNull;

public class DelegatingGCMonitor
implements GCMonitor {
    private final Set<GCMonitor> gcMonitors = ConcurrentHashMap.newKeySet();

    public DelegatingGCMonitor(@NotNull Collection<? extends GCMonitor> gcMonitors) {
        this.gcMonitors.addAll(gcMonitors);
    }

    public DelegatingGCMonitor() {
        this(ConcurrentHashMap.newKeySet());
    }

    public Registration registerGCMonitor(final @NotNull GCMonitor gcMonitor) {
        this.gcMonitors.add(Objects.requireNonNull(gcMonitor));
        return new Registration(){

            @Override
            public void unregister() {
                DelegatingGCMonitor.this.gcMonitors.remove(gcMonitor);
            }
        };
    }

    @Override
    public void info(String message, Object ... arguments) {
        for (GCMonitor gcMonitor : this.gcMonitors) {
            gcMonitor.info(message, arguments);
        }
    }

    @Override
    public void warn(String message, Object ... arguments) {
        for (GCMonitor gcMonitor : this.gcMonitors) {
            gcMonitor.warn(message, arguments);
        }
    }

    @Override
    public void error(String message, Exception exception) {
        for (GCMonitor gcMonitor : this.gcMonitors) {
            gcMonitor.error(message, exception);
        }
    }

    @Override
    public void skipped(String reason, Object ... arguments) {
        for (GCMonitor gcMonitor : this.gcMonitors) {
            gcMonitor.skipped(reason, arguments);
        }
    }

    @Override
    public void compacted() {
        for (GCMonitor gcMonitor : this.gcMonitors) {
            gcMonitor.compacted();
        }
    }

    @Override
    public void cleaned(long reclaimedSize, long currentSize) {
        for (GCMonitor gcMonitor : this.gcMonitors) {
            gcMonitor.cleaned(reclaimedSize, currentSize);
        }
    }

    @Override
    public void updateStatus(String status) {
        for (GCMonitor gcMonitor : this.gcMonitors) {
            gcMonitor.updateStatus(status);
        }
    }
}

