/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.QuantityFluent;
import io.fabric8.kubernetes.api.model.QuantityFluentImpl;

public class QuantityBuilder
extends QuantityFluentImpl<QuantityBuilder>
implements VisitableBuilder<Quantity, QuantityBuilder> {
    QuantityFluent<?> fluent;
    Boolean validationEnabled;

    public QuantityBuilder() {
        this(false);
    }

    public QuantityBuilder(Boolean validationEnabled) {
        this(new Quantity(), validationEnabled);
    }

    public QuantityBuilder(QuantityFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public QuantityBuilder(QuantityFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Quantity(), validationEnabled);
    }

    public QuantityBuilder(QuantityFluent<?> fluent, Quantity instance) {
        this(fluent, instance, false);
    }

    public QuantityBuilder(QuantityFluent<?> fluent, Quantity instance, Boolean validationEnabled) {
        this.fluent = fluent;
        if (instance != null) {
            fluent.withAmount(instance.getAmount());
            fluent.withFormat(instance.getFormat());
            fluent.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public QuantityBuilder(Quantity instance) {
        this(instance, (Boolean)false);
    }

    public QuantityBuilder(Quantity instance, Boolean validationEnabled) {
        this.fluent = this;
        if (instance != null) {
            this.withAmount(instance.getAmount());
            this.withFormat(instance.getFormat());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Quantity build() {
        Quantity buildable = new Quantity(this.fluent.getAmount());
        buildable.setFormat(this.fluent.getFormat());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

