/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.util;

import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.common.util.BlockingTaskExecutor;
import com.linecorp.armeria.common.util.DefaultBlockingTaskExecutor;
import com.linecorp.armeria.common.util.ThreadFactories;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public final class BlockingTaskExecutorBuilder {
    private String threadNamePrefix = "armeria-blocking-tasks";
    private int numThreads = Flags.numCommonBlockingTaskThreads();
    private long keepAliveTimeMillis = 60000L;
    private boolean daemon = true;
    private int priority = 5;
    private Function<? super Runnable, ? extends Runnable> taskFunction = Function.identity();

    BlockingTaskExecutorBuilder() {
    }

    public BlockingTaskExecutorBuilder threadNamePrefix(String threadNamePrefix) {
        Objects.requireNonNull(threadNamePrefix, "threadNamePrefix");
        this.threadNamePrefix = threadNamePrefix;
        return this;
    }

    public BlockingTaskExecutorBuilder numThreads(int numThreads) {
        Preconditions.checkArgument(numThreads >= 0, "numThreads: %s (expected: >= 0)", numThreads);
        this.numThreads = numThreads;
        return this;
    }

    public BlockingTaskExecutorBuilder keepAliveTime(Duration keepAliveTime) {
        Preconditions.checkArgument(!Objects.requireNonNull(keepAliveTime, "keepAliveTime").isNegative(), "keepAliveTime: %s (expected: >= 0)", (Object)keepAliveTime);
        return this.keepAliveTimeMillis(keepAliveTime.toMillis());
    }

    public BlockingTaskExecutorBuilder keepAliveTimeMillis(long keepAliveTimeMillis) {
        Preconditions.checkArgument(keepAliveTimeMillis >= 0L, "keepAliveTimeMillis: %s (expected: >= 0)", keepAliveTimeMillis);
        this.keepAliveTimeMillis = keepAliveTimeMillis;
        return this;
    }

    public BlockingTaskExecutorBuilder daemon(boolean daemon) {
        this.daemon = daemon;
        return this;
    }

    public BlockingTaskExecutorBuilder priority(int priority) {
        Preconditions.checkArgument(priority >= 1 && priority <= 10, "priority: %s (expected: Thread.MIN_PRIORITY <= priority <= Thread.MAX_PRIORITY)", priority);
        this.priority = priority;
        return this;
    }

    public BlockingTaskExecutorBuilder taskFunction(Function<? super Runnable, ? extends Runnable> taskFunction) {
        this.taskFunction = Objects.requireNonNull(taskFunction, "taskFunction");
        return this;
    }

    public BlockingTaskExecutor build() {
        ThreadFactory threadFactory = ThreadFactories.builder(this.threadNamePrefix).daemon(this.daemon).priority(this.priority).taskFunction(this.taskFunction).build();
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(this.numThreads, threadFactory);
        if (this.keepAliveTimeMillis > 0L) {
            scheduledThreadPoolExecutor.setKeepAliveTime(this.keepAliveTimeMillis, TimeUnit.MILLISECONDS);
            scheduledThreadPoolExecutor.allowCoreThreadTimeOut(true);
        }
        return new DefaultBlockingTaskExecutor(scheduledThreadPoolExecutor);
    }
}

