/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.library.elasticsearch.requests.factory.v7plus;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpRequestBuilder;
import com.linecorp.armeria.common.MediaType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.skywalking.library.elasticsearch.ElasticSearchVersion;
import org.apache.skywalking.library.elasticsearch.requests.IndexRequest;
import org.apache.skywalking.library.elasticsearch.requests.UpdateRequest;
import org.apache.skywalking.library.elasticsearch.requests.factory.DocumentFactory;
import org.apache.skywalking.library.elasticsearch.requests.factory.v7plus.V7DocumentFactory;
import org.apache.skywalking.library.elasticsearch.requests.search.Query;

public class V81DocumentFactory
implements DocumentFactory {
    private final ElasticSearchVersion version;
    private final V7DocumentFactory v7DocumentFactory;

    public V81DocumentFactory(ElasticSearchVersion version) {
        this.version = version;
        this.v7DocumentFactory = new V7DocumentFactory(version);
    }

    @Override
    public HttpRequest update(UpdateRequest request, Map<String, ?> params) {
        Objects.requireNonNull(request, "request");
        String index = request.getIndex();
        String type = request.getType();
        String id = request.getId();
        Map<String, Object> doc = request.getDoc();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)index) ? 1 : 0) != 0, (Object)"index cannot be null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)type) ? 1 : 0) != 0, (Object)"type cannot be null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)id) ? 1 : 0) != 0, (Object)"id cannot be null or empty");
        Preconditions.checkArgument((doc != null && !Iterables.isEmpty(doc.entrySet()) ? 1 : 0) != 0, (Object)"doc cannot be null or empty");
        HttpRequestBuilder builder = HttpRequest.builder();
        if (params != null) {
            params.forEach((arg_0, arg_1) -> ((HttpRequestBuilder)builder).queryParam(arg_0, arg_1));
        }
        byte[] content = this.version.codec().encode(ImmutableMap.of((Object)"doc", doc));
        builder.post("/{index}/_update/{id}").pathParam("index", (Object)index).pathParam("id", (Object)id).content(MediaType.JSON, content);
        return builder.build();
    }

    @Override
    @Generated
    public HttpRequest exist(String index, String type, String id) {
        return this.v7DocumentFactory.exist(index, type, id);
    }

    @Override
    @Generated
    public HttpRequest get(String index, String type, String id) {
        return this.v7DocumentFactory.get(index, type, id);
    }

    @Override
    @Generated
    public HttpRequest mget(String index, String type, Iterable<String> ids) {
        return this.v7DocumentFactory.mget(index, type, ids);
    }

    @Override
    @Generated
    public HttpRequest mget(String type, Map<String, List<String>> indexIds) {
        return this.v7DocumentFactory.mget(type, indexIds);
    }

    @Override
    @Generated
    public HttpRequest index(IndexRequest request, Map<String, ?> params) {
        return this.v7DocumentFactory.index(request, params);
    }

    @Override
    @Generated
    public HttpRequest delete(String index, String type, Query query, Map<String, ?> params) {
        return this.v7DocumentFactory.delete(index, type, query, params);
    }

    @Override
    @Generated
    public HttpRequest deleteById(String index, String type, String id, Map<String, ?> params) {
        return this.v7DocumentFactory.deleteById(index, type, id, params);
    }
}

