/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.ij;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.derby.iapi.tools.i18n.LocalizedInput;
import org.apache.derby.iapi.tools.i18n.LocalizedOutput;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;
import org.apache.derby.impl.tools.ij.util;
import org.apache.derby.impl.tools.ij.utilMain;
import org.apache.derby.tools.JDBCDisplayUtil;

public class Main {
    private utilMain utilInstance;

    public static void main(String[] stringArray) throws IOException {
        Main.mainCore(stringArray, new Main(true));
    }

    public static void mainCore(String[] stringArray, Main main) throws IOException {
        Object object;
        String string;
        LocalizedOutput localizedOutput;
        LocalizedResource localizedResource;
        LocalizedInput localizedInput;
        block16: {
            localizedInput = null;
            InputStream inputStream = null;
            localizedResource = LocalizedResource.getInstance();
            localizedOutput = localizedResource.getNewOutput(System.out);
            if (util.invalidArgs(stringArray)) {
                util.Usage(localizedOutput);
                return;
            }
            boolean bl = util.getPropertyArg(stringArray);
            localizedResource.init();
            localizedOutput = localizedResource.getNewOutput(System.out);
            main.initAppUI();
            String string2 = util.getFileArg(stringArray);
            String string3 = util.getInputResourceNameArg(stringArray);
            if (string3 != null) {
                localizedInput = localizedResource.getNewInput(util.getResourceAsStream(string3));
                if (localizedInput == null) {
                    localizedOutput.println(localizedResource.getTextMessage("IJ_IjErroResoNo", string3));
                    return;
                }
            } else if (string2 == null) {
                localizedInput = localizedResource.getNewInput(System.in);
                localizedOutput.flush();
            } else {
                try {
                    string = string2;
                    inputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                        @Override
                        public FileInputStream run() throws FileNotFoundException {
                            return new FileInputStream(string);
                        }
                    });
                    if (inputStream != null) {
                        inputStream = new BufferedInputStream(inputStream, 2048);
                        localizedInput = localizedResource.getNewInput(inputStream);
                    }
                }
                catch (PrivilegedActionException privilegedActionException) {
                    if (Boolean.getBoolean("ij.searchClassPath")) {
                        localizedInput = localizedResource.getNewInput(util.getResourceAsStream(string2));
                    }
                    if (localizedInput != null) break block16;
                    localizedOutput.println(localizedResource.getTextMessage("IJ_IjErroFileNo", string2));
                    return;
                }
            }
        }
        if ((string = util.getSystemProperty("ij.outfile")) != null && string.length() > 0) {
            object = localizedOutput;
            FileOutputStream fileOutputStream = AccessController.doPrivileged(new PrivilegedAction<FileOutputStream>(){

                @Override
                public FileOutputStream run() {
                    FileOutputStream fileOutputStream = null;
                    try {
                        fileOutputStream = new FileOutputStream(string);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        fileOutputStream = null;
                    }
                    return fileOutputStream;
                }
            });
            localizedOutput = localizedResource.getNewOutput(fileOutputStream);
            if (localizedOutput == null) {
                ((PrintWriter)object).println(localizedResource.getTextMessage("IJ_IjErroUnabTo", string));
            }
        }
        if ((object = util.getSystemProperty("maximumDisplayWidth")) == null) {
            object = util.getSystemProperty("ij.maximumDisplayWidth");
        }
        if (object != null && ((String)object).length() > 0) {
            try {
                int n = Integer.parseInt((String)object);
                JDBCDisplayUtil.setMaxDisplayWidth(n);
            }
            catch (NumberFormatException numberFormatException) {
                localizedOutput.println(localizedResource.getTextMessage("IJ_IjErroMaxiVa", object));
            }
        }
        Main main2 = main.getMain(localizedOutput);
        main2.go(localizedInput, localizedOutput);
        localizedInput.close();
        localizedOutput.close();
    }

    public Main getMain(LocalizedOutput localizedOutput) {
        return new Main(localizedOutput);
    }

    public utilMain getutilMain(int n, LocalizedOutput localizedOutput) {
        return new utilMain(n, localizedOutput);
    }

    public utilMain getutilMain(int n, LocalizedOutput localizedOutput, boolean bl) {
        return new utilMain(n, localizedOutput, bl);
    }

    private void go(LocalizedInput localizedInput, LocalizedOutput localizedOutput) {
        LocalizedInput[] localizedInputArray = new LocalizedInput[]{localizedInput};
        this.utilInstance.go(localizedInputArray, localizedOutput);
    }

    public Main() {
        this(null);
    }

    public Main(LocalizedOutput localizedOutput) {
        if (localizedOutput == null) {
            localizedOutput = LocalizedResource.getInstance().getNewOutput(System.out);
        }
        this.utilInstance = this.getutilMain(1, localizedOutput);
        this.utilInstance.initFromEnvironment();
    }

    public Main(boolean bl) {
    }

    private void initAppUI() {
        LocalizedResource.getInstance();
    }
}

