/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.sis.parameter.DefaultParameterValueGroup;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.parameter.UnmodifiableParameterValue;
import org.apache.sis.parameter.Verifier;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.LenientComparable;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;

class UnmodifiableParameterValueGroup
extends Parameters
implements LenientComparable,
Serializable {
    private static final long serialVersionUID = -7980778116268449513L;
    private final ParameterDescriptorGroup descriptor;
    private final List<GeneralParameterValue> values;

    UnmodifiableParameterValueGroup(UnmodifiableParameterValueGroup group) {
        this.descriptor = group.descriptor;
        this.values = group.values;
    }

    private UnmodifiableParameterValueGroup(ParameterValueGroup group, Map<ParameterValueGroup, Boolean> done) {
        if (done.put(group, Boolean.TRUE) != null) {
            throw new IllegalArgumentException(Errors.format((short)28));
        }
        this.descriptor = group.getDescriptor();
        List values = group.values();
        Object[] array = new GeneralParameterValue[values.size()];
        for (int i = 0; i < array.length; ++i) {
            Object value = (GeneralParameterValue)values.get(i);
            ArgumentChecks.ensureNonNullElement((String)"values", (int)i, (Object)value);
            if (value instanceof ParameterValue) {
                value = UnmodifiableParameterValue.create((ParameterValue)value);
            } else if (value instanceof ParameterValueGroup) {
                value = new UnmodifiableParameterValueGroup((ParameterValueGroup)value, done);
            }
            array[i] = value;
        }
        this.values = Containers.viewAsUnmodifiableList((Object[])array);
    }

    static UnmodifiableParameterValueGroup create(ParameterValueGroup group) {
        if (group == null || group instanceof UnmodifiableParameterValueGroup) {
            return (UnmodifiableParameterValueGroup)group;
        }
        return new UnmodifiableParameterValueGroup(group, new IdentityHashMap<ParameterValueGroup, Boolean>(4));
    }

    public ParameterDescriptorGroup getDescriptor() {
        return this.descriptor;
    }

    public List<GeneralParameterValue> values() {
        return this.values;
    }

    @Override
    final boolean isKnownImplementation() {
        return true;
    }

    public final ParameterValue<?> parameter(String name) throws ParameterNotFoundException {
        ParameterValue<?> value = this.parameterIfExist(Objects.requireNonNull(name));
        if (value != null) {
            return value;
        }
        throw new ParameterNotFoundException(Resources.format((short)61, Verifier.getDisplayName((GeneralParameterDescriptor)this.descriptor), name), name);
    }

    public List<ParameterValueGroup> groups(String name) throws ParameterNotFoundException {
        Objects.requireNonNull(name);
        ArrayList<ParameterValueGroup> groups = new ArrayList<ParameterValueGroup>(4);
        for (GeneralParameterValue value : this.values) {
            if (!(value instanceof ParameterValueGroup) || !IdentifiedObjects.isHeuristicMatchForName((IdentifiedObject)value.getDescriptor(), name)) continue;
            groups.add((ParameterValueGroup)value);
        }
        if (groups.isEmpty() && !(this.descriptor.descriptor(name) instanceof ParameterDescriptorGroup)) {
            throw new ParameterNotFoundException(Resources.format((short)61, Verifier.getDisplayName((GeneralParameterDescriptor)this.descriptor), name), name);
        }
        return groups;
    }

    public final ParameterValueGroup addGroup(String name) throws IllegalStateException {
        throw new UnsupportedOperationException(Errors.format((short)185, ParameterValueGroup.class));
    }

    @Override
    public Parameters clone() {
        DefaultParameterValueGroup copy = new DefaultParameterValueGroup(this.descriptor);
        Parameters.copy(this, copy);
        return copy;
    }

    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (object != null) {
            if (mode == ComparisonMode.STRICT) {
                if (this.getClass() == object.getClass()) {
                    UnmodifiableParameterValueGroup that = (UnmodifiableParameterValueGroup)object;
                    return Objects.equals(this.descriptor, that.descriptor) && Objects.equals(this.values, that.values);
                }
            } else if (object instanceof ParameterValueGroup) {
                return DefaultParameterValueGroup.equals(this, (ParameterValueGroup)object, mode);
            }
        }
        return false;
    }

    public final boolean equals(Object object) {
        return this.equals(object, ComparisonMode.STRICT);
    }

    public int hashCode() {
        return this.descriptor.hashCode() ^ this.values.hashCode();
    }
}

