/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff.reader;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.sis.io.stream.ChannelDataInput;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.math.Fraction;
import org.apache.sis.math.Vector;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.internal.shared.Numerics;
import org.apache.sis.util.resources.Errors;

public enum Type {
    UNDEFINED(7, 1, false){

        @Override
        public long readAsLong(ChannelDataInput input, long count) throws IOException {
            throw new UnsupportedOperationException(this.name());
        }

        @Override
        public Object readAsObject(ChannelDataInput input, long count) throws IOException {
            return null;
        }
    }
    ,
    BYTE(6, 1, false){

        @Override
        public long readAsLong(ChannelDataInput input, long count) throws IOException {
            long value = input.readByte();
            for (long i = 1L; i < count; ++i) {
                Type.ensureSingleton(value, input.readByte(), count);
            }
            return value;
        }

        @Override
        public Object readAsArray(ChannelDataInput input, int count) throws IOException {
            return input.readBytes(count);
        }
    }
    ,
    UBYTE(1, 1, true){

        @Override
        public long readAsLong(ChannelDataInput input, long count) throws IOException {
            long value = input.readUnsignedByte();
            for (long i = 1L; i < count; ++i) {
                Type.ensureSingleton(value, input.readUnsignedByte(), count);
            }
            return value;
        }

        @Override
        public Object readAsArray(ChannelDataInput input, int count) throws IOException {
            return input.readBytes(count);
        }
    }
    ,
    SHORT(8, 2, false){

        @Override
        public long readAsLong(ChannelDataInput input, long count) throws IOException {
            long value = input.readShort();
            for (long i = 1L; i < count; ++i) {
                Type.ensureSingleton(value, input.readShort(), count);
            }
            return value;
        }

        @Override
        public Object readAsArray(ChannelDataInput input, int count) throws IOException {
            return input.readShorts(count);
        }
    }
    ,
    USHORT(3, 2, true){

        @Override
        public long readAsLong(ChannelDataInput input, long count) throws IOException {
            long value = input.readUnsignedShort();
            for (long i = 1L; i < count; ++i) {
                Type.ensureSingleton(value, input.readUnsignedShort(), count);
            }
            return value;
        }

        @Override
        public Object readAsArray(ChannelDataInput input, int count) throws IOException {
            return input.readShorts(count);
        }
    }
    ,
    INT(9, 4, false){

        @Override
        public long readAsLong(ChannelDataInput input, long count) throws IOException {
            long value = input.readInt();
            for (long i = 1L; i < count; ++i) {
                Type.ensureSingleton(value, input.readInt(), count);
            }
            return value;
        }

        @Override
        public Object readAsArray(ChannelDataInput input, int count) throws IOException {
            return input.readInts(count);
        }
    }
    ,
    UINT(4, 4, true){

        @Override
        public long readAsLong(ChannelDataInput input, long count) throws IOException {
            long value = input.readUnsignedInt();
            for (long i = 1L; i < count; ++i) {
                Type.ensureSingleton(value, input.readUnsignedInt(), count);
            }
            return value;
        }

        @Override
        public Object readAsArray(ChannelDataInput input, int count) throws IOException {
            return input.readInts(count);
        }
    }
    ,
    LONG(17, 8, false){

        @Override
        public long readAsLong(ChannelDataInput input, long count) throws IOException {
            long value = input.readLong();
            for (long i = 1L; i < count; ++i) {
                Type.ensureSingleton(value, input.readLong(), count);
            }
            return value;
        }

        @Override
        public Object readAsArray(ChannelDataInput input, int count) throws IOException {
            return input.readLongs(count);
        }
    }
    ,
    ULONG(16, 8, true){

        @Override
        public long readAsLong(ChannelDataInput input, long count) throws IOException {
            long value = input.readLong();
            for (long i = 1L; i < count; ++i) {
                Type.ensureSingleton(value, input.readLong(), count);
            }
            if (value >= 0L) {
                return value;
            }
            throw new ArithmeticException(this.canNotConvert(Long.toUnsignedString(value)));
        }

        @Override
        public double readAsDouble(ChannelDataInput input, long count) throws IOException {
            return Numerics.toUnsignedDouble((long)this.readAsLong(input, count));
        }

        @Override
        public Object readAsArray(ChannelDataInput input, int count) throws IOException {
            return input.readLongs(count);
        }
    }
    ,
    FLOAT(11, 4, false){

        private float readAsFloat(ChannelDataInput input, long count) throws IOException {
            float value = input.readFloat();
            for (long i = 1L; i < count; ++i) {
                Type.ensureSingleton(value, input.readFloat(), count);
            }
            return value;
        }

        @Override
        public long readAsLong(ChannelDataInput input, long count) throws IOException {
            float value = this.readAsFloat(input, count);
            long r = (long)value;
            if ((float)r == value) {
                return r;
            }
            throw new ArithmeticException(this.canNotConvert(Float.toString(value)));
        }

        @Override
        public double readAsDouble(ChannelDataInput input, long count) throws IOException {
            return DecimalFunctions.floatToDouble((float)this.readAsFloat(input, count));
        }

        @Override
        public Object readAsArray(ChannelDataInput input, int count) throws IOException {
            return input.readFloats(count);
        }
    }
    ,
    DOUBLE(12, 8, false){

        @Override
        public double readAsDouble(ChannelDataInput input, long count) throws IOException {
            double value = input.readDouble();
            for (long i = 1L; i < count; ++i) {
                Type.ensureSingleton(value, input.readDouble(), count);
            }
            return value;
        }

        @Override
        public Object readAsArray(ChannelDataInput input, int count) throws IOException {
            return input.readDoubles(count);
        }
    }
    ,
    RATIONAL(10, 8, false){

        @Override
        public double readAsDouble(ChannelDataInput input, long count) throws IOException {
            return this.readFraction(input, count).doubleValue();
        }

        @Override
        public Object readAsArray(ChannelDataInput input, int count) throws IOException {
            return this.readFractions(input, count);
        }

        @Override
        public Object readAsObject(ChannelDataInput input, long count) throws IOException {
            return count == 1L ? this.readFraction(input, count) : super.readAsObject(input, count);
        }
    }
    ,
    URATIONAL(5, 8, true){

        @Override
        public double readAsDouble(ChannelDataInput input, long count) throws IOException {
            return this.readFraction(input, count).doubleValue();
        }

        @Override
        public Object readAsArray(ChannelDataInput input, int count) throws IOException {
            return this.readFractions(input, count);
        }

        @Override
        public Object readAsObject(ChannelDataInput input, long count) throws IOException {
            return count == 1L ? this.readFraction(input, count) : super.readAsObject(input, count);
        }
    }
    ,
    ASCII(2, 1, false){

        @Override
        public String[] readAsStrings(ChannelDataInput input, long length, Charset charset) throws IOException {
            byte[] chars = input.readBytes(Math.toIntExact(length));
            Object[] lines = new String[1];
            int count = 0;
            int lower = 0;
            for (int i = 0; i < chars.length; ++i) {
                if (chars[i] != 0) continue;
                if (count >= lines.length) {
                    lines = (String[])Arrays.copyOf(lines, 2 * count);
                }
                lines[count++] = new String(chars, lower, i - lower, charset);
            }
            return (String[])ArraysExt.resize((Object[])lines, (int)count);
        }

        private String readAsString(ChannelDataInput input, long count, boolean mandatory) throws IOException {
            String[] lines = this.readAsStrings(input, count, StandardCharsets.US_ASCII);
            if (lines.length != 0) {
                String value = lines[0];
                int i = 1;
                do {
                    if (i < lines.length) continue;
                    return value;
                } while (value.equals(lines[i++]));
            } else if (!mandatory) {
                return null;
            }
            throw new IllegalArgumentException(Errors.format((short)164, (Object)1, (Object)lines.length));
        }

        @Override
        public long readAsLong(ChannelDataInput input, long count) throws IOException {
            return Long.parseLong(this.readAsString(input, count, true));
        }

        @Override
        public double readAsDouble(ChannelDataInput input, long count) throws IOException {
            String text = this.readAsString(input, count, false);
            if (text == null || (text = text.trim()).isEmpty() || text.equalsIgnoreCase("NaN")) {
                return Double.NaN;
            }
            return Double.parseDouble(text);
        }

        @Override
        public Object readAsArray(ChannelDataInput input, int count) throws IOException {
            return this.readAsStrings(input, count, StandardCharsets.US_ASCII);
        }

        @Override
        public Object readAsObject(ChannelDataInput input, long count) throws IOException {
            return this.readAsString(input, count, false);
        }
    };

    final int code;
    public final int size;
    final boolean isUnsigned;
    private static final Type[] FROM_CODES;

    private Type(int code, int size, boolean isUnsigned) {
        this.code = code;
        this.size = size;
        this.isUnsigned = isUnsigned;
    }

    public static Type valueOf(int code) {
        return code >= 0 && code < FROM_CODES.length ? FROM_CODES[code] : null;
    }

    private Number nextFraction(ChannelDataInput input) throws IOException {
        if (this.isUnsigned) {
            return Numerics.fraction((long)input.readUnsignedInt(), (long)input.readUnsignedInt());
        }
        return new Fraction(input.readInt(), input.readInt()).unique();
    }

    final Number[] readFractions(ChannelDataInput input, int count) throws IOException {
        Number[] values = new Number[count];
        for (int i = 0; i < count; ++i) {
            values[i] = this.nextFraction(input);
        }
        return values;
    }

    final Number readFraction(ChannelDataInput input, long count) throws IOException {
        Number value = this.nextFraction(input);
        for (long i = 1L; i < count; ++i) {
            Type.ensureSingleton(value.doubleValue(), this.nextFraction(input).doubleValue(), count);
        }
        return value;
    }

    private static void ensureSingleton(long previous, long actual, long count) {
        if (previous != actual) {
            throw new IllegalArgumentException(Errors.format((short)164, (Object)1, (Object)count));
        }
    }

    private static void ensureSingleton(double previous, double actual, long count) {
        if (Double.doubleToLongBits(previous) != Double.doubleToLongBits(actual)) {
            throw new IllegalArgumentException(Errors.format((short)164, (Object)1, (Object)count));
        }
    }

    final String canNotConvert(String value) {
        return Errors.format((short)12, (Object)value, (Object)this.name());
    }

    public final short readAsShort(ChannelDataInput input, long count) throws IOException {
        long value = this.readAsLong(input, count);
        if (value >= -32768L && value <= 32767L) {
            return (short)value;
        }
        throw new ArithmeticException(this.canNotConvert(Long.toString(value)));
    }

    public final int readAsInt(ChannelDataInput input, long count) throws IOException {
        long value = this.readAsLong(input, count);
        if (value >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE) {
            return (int)value;
        }
        throw new ArithmeticException(this.canNotConvert(Long.toString(value)));
    }

    public final long readAsUnsignedLong(ChannelDataInput input, long count) throws IOException {
        long value = this.readAsLong(input, count);
        if (value >= 0L) {
            return value;
        }
        throw new ArithmeticException(this.canNotConvert(Long.toUnsignedString(value)));
    }

    public long readAsLong(ChannelDataInput input, long count) throws IOException {
        double value = this.readAsDouble(input, count);
        long r = (long)value;
        if ((double)r == value) {
            return r;
        }
        throw new ArithmeticException(this.canNotConvert(Double.toString(value)));
    }

    public double readAsDouble(ChannelDataInput input, long count) throws IOException {
        return this.readAsLong(input, count);
    }

    public String[] readAsStrings(ChannelDataInput input, long length, Charset charset) throws IOException {
        String[] s = new String[Math.toIntExact(length)];
        for (int i = 0; i < s.length; ++i) {
            double value = this.readAsDouble(input, 1L);
            long r = (long)value;
            s[i] = (double)r == value ? String.valueOf(r) : String.valueOf(value);
        }
        return s;
    }

    public Object readAsObject(ChannelDataInput input, long count) throws IOException {
        return this.readAsVector(input, count);
    }

    public Object readAsArray(ChannelDataInput input, int count) throws IOException {
        throw new UnsupportedOperationException(this.name());
    }

    public final Vector readAsVector(ChannelDataInput input, long count) throws IOException {
        return Vector.create((Object)this.readAsArray(input, Math.toIntExact(count)), (boolean)this.isUnsigned);
    }

    static {
        FROM_CODES = new Type[19];
        Type[] typeArray = Type.values();
        int n = typeArray.length;
        for (int i = 0; i < n; ++i) {
            Type type;
            Type.FROM_CODES[type.code] = type = typeArray[i];
        }
        Type.FROM_CODES[13] = UINT;
        Type.FROM_CODES[18] = ULONG;
    }
}

