/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.setup;

import java.sql.SQLException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.apache.sis.system.Shutdown;
import org.apache.sis.system.SystemListener;
import org.apache.sis.util.internal.shared.MetadataServices;
import org.apache.sis.util.logging.Logging;

public final class Configuration {
    private static final Configuration DEFAULT = new Configuration();

    private Configuration() {
    }

    public static Configuration current() {
        return DEFAULT;
    }

    public Optional<DataSource> getDatabase() throws SQLException {
        return Optional.of(MetadataServices.getInstance().getDataSource());
    }

    public void setDatabase(Supplier<DataSource> source) {
        MetadataServices.getInstance().setDataSource(Objects.requireNonNull(source));
    }

    public void shutdown() {
        try {
            Shutdown.stop(Configuration.class);
        }
        catch (Exception e) {
            Logging.unexpectedException(SystemListener.LOGGER, Configuration.class, "stop", e);
        }
    }
}

