/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.CharBuffer;
import org.apache.sis.io.Appender;
import org.apache.sis.io.IO;

final class AppendableWriter
extends Writer {
    private final Appendable out;

    AppendableWriter(Appendable out) {
        super(AppendableWriter.getLock(out));
        this.out = out;
    }

    private static Object getLock(Appendable out) {
        while (out instanceof Appender) {
            out = ((Appender)out).out;
        }
        if (out instanceof StringWriter) {
            return ((StringWriter)out).getBuffer();
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Writer append(char c) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.out.append(c);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int c) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.out.append((char)c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Writer append(CharSequence sequence) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.out.append(sequence);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String string) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.out.append(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Writer append(CharSequence sequence, int start, int end) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.out.append(sequence, start, end);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String string, int start, int length) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.out.append(string, start, start + length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cbuf, int offset, int length) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.out.append(CharBuffer.wrap(cbuf, offset, length));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            IO.flush(this.out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            IO.close(this.out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            return IO.toString(this.out);
        }
    }
}

