/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.stream;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.AccessDeniedException;
import java.util.List;
import org.apache.sis.io.stream.FileCacheByteChannel;
import org.apache.sis.storage.internal.Resources;

final class HttpByteChannel
extends FileCacheByteChannel {
    private final String filename;
    private final HttpRequest.Builder request;
    private final HttpClient client;
    private static WeakReference<HttpClient> sharedClient;

    private static synchronized HttpClient sharedClient() {
        HttpClient client;
        if (sharedClient != null && (client = (HttpClient)sharedClient.get()) != null) {
            return client;
        }
        client = HttpClient.newHttpClient();
        sharedClient = new WeakReference<HttpClient>(client);
        return client;
    }

    public HttpByteChannel(String name, URI path) throws IOException {
        super("http-");
        this.filename = name;
        this.request = HttpRequest.newBuilder(path);
        this.client = HttpByteChannel.sharedClient();
    }

    @Override
    protected String filename() {
        return this.filename;
    }

    @Override
    protected FileCacheByteChannel.Connection openConnection(long start, long end) throws IOException {
        HttpResponse<InputStream> response;
        HttpRequest.Builder r = this.request;
        String range = FileCacheByteChannel.Connection.formatRange(start, end);
        if (range != null) {
            r = r.copy().setHeader("Range", range);
        }
        try {
            response = this.client.send(r.build(), HttpResponse.BodyHandlers.ofInputStream());
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        switch (response.statusCode()) {
            default: {
                throw new IOException(this.cannotConnect(response));
            }
            case 204: 
            case 404: {
                throw new FileNotFoundException(this.cannotConnect(response));
            }
            case 401: 
            case 403: 
            case 451: {
                throw new AccessDeniedException(this.cannotConnect(response));
            }
            case 200: 
            case 203: {
            }
            case 206: 
        }
        InputStream stream = response.body();
        HttpHeaders headers = response.headers();
        range = headers.firstValue("Content-Range").orElse(null);
        List<String> rangeUnits = headers.allValues("Accept-Ranges");
        try {
            if (range == null) {
                long length = headers.firstValueAsLong("Content-Length").orElse(-1L);
                return new FileCacheByteChannel.Connection((FileCacheByteChannel)this, stream, length, rangeUnits);
            }
            return new FileCacheByteChannel.Connection((FileCacheByteChannel)this, stream, range, rangeUnits);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e);
        }
    }

    private String cannotConnect(HttpResponse<?> response) {
        return Resources.format((short)85, this.filename, response.statusCode());
    }

    @Override
    protected boolean abort(FileCacheByteChannel.Connection connection) throws IOException {
        connection.input.close();
        return true;
    }
}

