/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.util.EnumMap;
import java.util.Map;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.ProjectionException;
import org.apache.sis.referencing.operation.provider.Equirectangular;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.MathTransformProvider;
import org.apache.sis.referencing.operation.transform.TransformJoiner;
import org.apache.sis.util.internal.shared.DoubleDouble;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;

public class EquidistantCylindrical
extends NormalizedProjection {
    private static final long serialVersionUID = -8049874881401710767L;
    private static final boolean ALLOW_TRIGONOMETRIC_IDENTITIES = true;
    private final double c0;
    private final double cf1;
    private final double cf2;
    private final double cf3;
    private final double cf4;
    private final double cf5;
    private final double cf6;
    private final double cf7;
    private final double ci1;
    private final double ci2;
    private final double ci3;
    private final double ci4;
    private final double ci5;
    private final double ci6;
    private final double ci7;

    public EquidistantCylindrical(OperationMethod method, Parameters parameters) {
        this(EquidistantCylindrical.initializer(method, parameters));
    }

    private static Initializer initializer(OperationMethod method, Parameters parameters) {
        EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>> roles = new EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>>(NormalizedProjection.ParameterRole.class);
        roles.put(NormalizedProjection.ParameterRole.FALSE_EASTING, Equirectangular.FALSE_EASTING);
        roles.put(NormalizedProjection.ParameterRole.FALSE_NORTHING, Equirectangular.FALSE_NORTHING);
        roles.put(NormalizedProjection.ParameterRole.CENTRAL_MERIDIAN, Equirectangular.LONGITUDE_OF_ORIGIN);
        return new Initializer(method, parameters, roles, null);
    }

    private EquidistantCylindrical(Initializer initializer) {
        super(initializer, null);
        double \u03c61 = Math.toRadians(initializer.getAndStore(Equirectangular.STANDARD_PARALLEL));
        DoubleDouble sx = initializer.r\u03bd2(Math.sin(\u03c61)).sqrt().multiply(Math.cos(\u03c61), false);
        MatrixSIS denormalize = this.context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION);
        denormalize.convertBefore(0, (Number)sx, null);
        double e2 = this.eccentricitySquared;
        double e4 = e2 * e2;
        double e6 = e2 * e4;
        double e8 = e4 * e4;
        double e10 = e4 * e6;
        double e12 = e6 * e6;
        double e14 = e6 * e8;
        this.c0 = -0.0033752918243408203 * e14 + -0.004626274108886719 * e12 + -0.0067291259765625 * e10 + -0.01068115234375 * e8 + -0.01953125 * e6 + -0.046875 * e4 + -0.25 * e2 + 1.0;
        this.cf1 = 8.805956159319197E-4 * e14 + -2.349853515625E-4 * e12 + -0.00333251953125 * e10 + -0.011393229166666666 * e8 + -0.032552083333333336 * e6 + -0.09375 * e4 + -0.375 * e2;
        this.cf2 = 0.008949637413024902 * e14 + 0.01707315444946289 * e12 + 0.03124237060546875 * e10 + 0.054473876953125 * e8 + 0.087890625 * e6 + 0.1171875 * e4;
        this.cf3 = -0.025334657941545758 * e14 + -0.037127685546875 * e12 + -0.0497314453125 * e10 + -0.056966145833333336 * e8 + -0.045572916666666664 * e6;
        this.cf4 = 0.03460526466369629 * e14 + 0.037817955017089844 * e12 + 0.0336456298828125 * e10 + 0.01922607421875 * e8;
        this.cf5 = -0.02616070338657924 * e14 + -0.0190338134765625 * e12 + -0.00845947265625 * e10;
        this.cf6 = 0.010500907897949219 * e14 + 0.003818511962890625 * e12;
        this.cf7 = -0.0017533983503069197 * e14;
        double n1 = initializer.axisLengthRatio().ratio_1m_1p().doubleValue();
        double n2 = n1 * n1;
        double n3 = n1 * n2;
        double n4 = n2 * n2;
        double n5 = n2 * n3;
        double n6 = n3 * n3;
        double n7 = n3 * n4;
        this.ci1 = -23.772381882440477 * n7 + 6.9125 * n5 + -2.4166666666666665 * n3 + 1.5 * n1;
        this.ci2 = 56.237890625 * n6 + -12.0078125 * n4 + 2.625 * n2;
        this.ci3 = 343.18560267857146 * n7 + -50.5828125 * n5 + 6.291666666666667 * n3;
        this.ci4 = -201.38072916666667 * n6 + 17.140625 * n4;
        this.ci5 = -816.6883370535714 * n7 + 50.06875 * n5;
        this.ci6 = 152.80885416666666 * n6;
        this.ci7 = 509.35275297619046 * n7;
    }

    @Override
    public MathTransform createMapProjection(MathTransformProvider.Context parameters) throws FactoryException {
        if (this.eccentricity == 0.0) {
            return Equirectangular.provider().createMathTransform(parameters);
        }
        return this.completeWithWraparound(parameters);
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws ProjectionException {
        double \u03c6 = srcPts[srcOff + 1];
        double sin\u03b8 = Math.sin(2.0 * \u03c6);
        double cos\u03b8 = Math.cos(2.0 * \u03c6);
        if (dstPts != null) {
            double y = ((((((this.cf7 * cos\u03b8 + this.cf6) * cos\u03b8 + this.cf5) * cos\u03b8 + this.cf4) * cos\u03b8 + this.cf3) * cos\u03b8 + this.cf2) * cos\u03b8 + this.cf1) * sin\u03b8 + this.c0 * \u03c6;
            dstPts[dstOff] = srcPts[srcOff];
            dstPts[dstOff + 1] = y;
        }
        if (!derivate) {
            return null;
        }
        Matrix2 derivative = new Matrix2();
        double d = ((((((this.cf7 * cos\u03b8 + this.cf6) * cos\u03b8 + this.cf5) * cos\u03b8 + this.cf4) * cos\u03b8 + this.cf3) * cos\u03b8 + this.cf2) * cos\u03b8 + this.cf1) * cos\u03b8 - (((((6.0 * this.cf7 * cos\u03b8 + 5.0 * this.cf6) * cos\u03b8 + 4.0 * this.cf5) * cos\u03b8 + 3.0 * this.cf4) * cos\u03b8 + 2.0 * this.cf3) * cos\u03b8 + this.cf2) * (sin\u03b8 * sin\u03b8);
        derivative.m11 = 2.0 * d + this.c0;
        return derivative;
    }

    @Override
    protected void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff) throws ProjectionException {
        double \u03bc = srcPts[srcOff + 1] / this.c0;
        double sin\u03b8 = Math.sin(2.0 * \u03bc);
        double cos\u03b8 = Math.cos(2.0 * \u03bc);
        double y = ((((((this.ci7 * cos\u03b8 + this.ci6) * cos\u03b8 + this.ci5) * cos\u03b8 + this.ci4) * cos\u03b8 + this.ci3) * cos\u03b8 + this.ci2) * cos\u03b8 + this.ci1) * sin\u03b8;
        dstPts[dstOff] = srcPts[srcOff];
        dstPts[dstOff + 1] = y + \u03bc;
    }

    @Override
    final boolean tryInverseConcatenate(TransformJoiner context) throws FactoryException {
        return context.replacePassThrough(Map.of(0, 0));
    }

    @Override
    protected final void tryConcatenate(TransformJoiner context) throws FactoryException {
        if (!this.tryInverseConcatenate(context)) {
            super.tryConcatenate(context);
        }
    }
}

