/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.internal.shared;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.measure.Unit;
import javax.measure.quantity.Angle;
import org.apache.sis.metadata.internal.shared.Identifiers;
import org.apache.sis.parameter.DefaultParameterDescriptorGroup;
import org.apache.sis.pending.geoapi.referencing.MissingMethods;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.ImmutableIdentifier;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.referencing.crs.DefaultGeographicCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.DefaultEllipsoidalCS;
import org.apache.sis.referencing.datum.DefaultPrimeMeridian;
import org.apache.sis.referencing.internal.VerticalDatumTypes;
import org.apache.sis.referencing.internal.shared.AxisDirections;
import org.apache.sis.referencing.internal.shared.NilReferencingObject;
import org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.apache.sis.xml.NilObject;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.MathTransformFactory;

public final class ReferencingUtilities {
    private ReferencingUtilities() {
    }

    public static double getGreenwichLongitude(PrimeMeridian primeMeridian, Unit<Angle> unit) {
        if (primeMeridian == null) {
            return 0.0;
        }
        if (primeMeridian instanceof DefaultPrimeMeridian) {
            return ((DefaultPrimeMeridian)primeMeridian).getGreenwichLongitude(unit);
        }
        return primeMeridian.getAngularUnit().getConverterTo(unit).convert(primeMeridian.getGreenwichLongitude());
    }

    public static Unit<?> getUnit(CoordinateSystem cs) {
        Unit unit = null;
        if (cs != null) {
            int i = cs.getDimension();
            while (--i >= 0) {
                Unit candidate;
                CoordinateSystemAxis axis = cs.getAxis(i);
                if (axis == null || (candidate = axis.getUnit()) == null) continue;
                if (unit == null) {
                    unit = candidate;
                    continue;
                }
                if (unit.equals((Object)candidate)) continue;
                return null;
            }
        }
        return unit;
    }

    public static Unit<?> getUnit(CoordinateReferenceSystem crs) {
        return crs != null ? ReferencingUtilities.getUnit(crs.getCoordinateSystem()) : null;
    }

    public static int getDimension(CoordinateReferenceSystem crs) {
        CoordinateSystem cs;
        if (crs != null && (cs = crs.getCoordinateSystem()) != null) {
            return cs.getDimension();
        }
        return 0;
    }

    public static Class<?> getInterface(Object object) {
        if (object instanceof AbstractIdentifiedObject) {
            return ((AbstractIdentifiedObject)object).getInterface();
        }
        return ReferencingUtilities.getInterface(IdentifiedObject.class, Classes.getClass((Object)object));
    }

    public static <T extends IdentifiedObject> Class<? extends T> getInterface(Class<T> baseType, T object) {
        if (object instanceof AbstractIdentifiedObject) {
            return ((AbstractIdentifiedObject)object).getInterface().asSubclass(baseType);
        }
        return ReferencingUtilities.getInterface(baseType, Classes.getClass(object));
    }

    public static <T extends IdentifiedObject> Class<? extends T> getInterface(Class<T> baseType, Class<? extends T> type) {
        Class[] types = Classes.getLeafInterfaces(type, baseType);
        return types.length != 0 ? types[0] : type;
    }

    public static boolean getSingleComponents(Iterable<? extends CoordinateReferenceSystem> source, Collection<? super SingleCRS> addTo) throws ClassCastException {
        boolean sameContent = true;
        for (CoordinateReferenceSystem coordinateReferenceSystem : source) {
            if (coordinateReferenceSystem instanceof CompoundCRS) {
                ReferencingUtilities.getSingleComponents(((CompoundCRS)coordinateReferenceSystem).getComponents(), addTo);
                sameContent = false;
                continue;
            }
            if (coordinateReferenceSystem instanceof SingleCRS) {
                addTo.add((SingleCRS)((SingleCRS)coordinateReferenceSystem));
                continue;
            }
            if (coordinateReferenceSystem instanceof NilObject) {
                String message = Errors.format((short)120, (Object)Identifiers.getNilReason((NilObject)((NilObject)coordinateReferenceSystem)));
                throw new NoSuchElementException(message);
            }
            String message = Errors.format((short)119, ReferencingUtilities.getInterface(coordinateReferenceSystem));
            throw new ClassCastException(message);
        }
        return sameContent;
    }

    public static boolean isEllipsoidalHeight(VerticalDatum datum) {
        if (datum != null) {
            return VerticalDatumTypes.ellipsoidal(datum.getVerticalDatumType());
        }
        return false;
    }

    public static GeographicCRS toNormalizedGeographicCRS(CoordinateReferenceSystem crs, boolean latlon, boolean allow3D) {
        while (crs instanceof GeneralDerivedCRS) {
            crs = ((GeneralDerivedCRS)crs).getBaseCRS();
        }
        if (crs instanceof GeodeticCRS) {
            EllipsoidalCS normalizedCS;
            CoordinateSystem cs = crs.getCoordinateSystem();
            if (!latlon && crs instanceof DefaultGeographicCRS && (allow3D || cs.getDimension() == 2)) {
                return ((DefaultGeographicCRS)crs).forConvention(AxesConvention.NORMALIZED);
            }
            if (allow3D && cs.getDimension() >= 3) {
                normalizedCS = CommonCRS.WGS84.geographic3D().getCoordinateSystem();
                if (!latlon) {
                    normalizedCS = DefaultEllipsoidalCS.castOrCopy(normalizedCS).forConvention(AxesConvention.NORMALIZED);
                }
            } else {
                normalizedCS = latlon ? CommonCRS.WGS84.geographic().getCoordinateSystem() : CommonCRS.defaultGeographic().getCoordinateSystem();
            }
            if (crs instanceof GeographicCRS && Utilities.equalsIgnoreMetadata((Object)normalizedCS, (Object)cs)) {
                return (GeographicCRS)crs;
            }
            GeodeticCRS source = (GeodeticCRS)crs;
            return new DefaultGeographicCRS(Map.of("name", NilReferencingObject.UNNAMED), source.getDatum(), MissingMethods.getDatumEnsemble(source), normalizedCS);
        }
        if (crs instanceof CompoundCRS) {
            for (CoordinateReferenceSystem e : ((CompoundCRS)crs).getComponents()) {
                GeographicCRS candidate = ReferencingUtilities.toNormalizedGeographicCRS(e, latlon, allow3D);
                if (candidate == null) continue;
                return candidate;
            }
        }
        return null;
    }

    public static boolean startsWithNorthEast(CoordinateSystem cs) {
        int dimension = cs.getDimension();
        return dimension >= 2 && cs.getAxis(0).getDirection() == AxisDirection.NORTH && cs.getAxis(1).getDirection() == AxisDirection.EAST;
    }

    public static Map<String, ?> getPropertiesWithoutIdentifiers(IdentifiedObject object, Map<String, ?> overwrite) {
        boolean keepName;
        Map<String, ?> properties = IdentifiedObjects.getProperties(object, "identifiers");
        ReferenceIdentifier name = object.getName();
        boolean bl = keepName = name.getCodeSpace() == null && name.getAuthority() == null;
        if (keepName && overwrite == null) {
            return properties;
        }
        HashMap copy = new HashMap(properties);
        if (!keepName) {
            copy.put("name", new NamedIdentifier(null, name.getCode()));
        }
        if (overwrite != null) {
            copy.putAll(overwrite);
        }
        return copy;
    }

    public static Map<String, ?> getPropertiesForModifiedCRS(IdentifiedObject object) {
        String name;
        Map<String, ?> properties = IdentifiedObjects.getProperties(object, "identifiers");
        Identifier id = (Identifier)properties.get("name");
        if (id != null && (name = id.getCode()) != null) {
            int c;
            for (int i = 0; i < name.length(); i += Character.charCount(c)) {
                String extra;
                int endAt;
                c = name.codePointAt(i);
                if (Character.isUnicodeIdentifierPart(c) || Character.isSpaceChar(c)) continue;
                if (c == 40 && (endAt = name.indexOf(41, i)) >= 0 && CharSequences.isUnicodeIdentifier((CharSequence)(extra = name.substring(i + 1, endAt)))) {
                    i += extra.length() + 2;
                }
                if ((name = CharSequences.trimWhitespaces((CharSequence)name, (int)0, (int)i).toString()).isEmpty()) continue;
                HashMap copy = new HashMap(properties);
                copy.put("name", name);
                return copy;
            }
        }
        return properties;
    }

    public static StringBuilder toPropertyName(Class<?> base, Class<?> type) {
        String name;
        int length;
        StringBuilder buffer;
        Specification spec;
        UML uml = type.getAnnotation(UML.class);
        if (uml != null && (spec = uml.specification()) == Specification.ISO_19111 && (buffer = new StringBuilder(length = (name = uml.identifier()).length()).append(name, name.indexOf(95) + 1, length)).length() != 0) {
            buffer.setCharAt(0, Character.toLowerCase(buffer.charAt(0)));
            return buffer;
        }
        for (Class<?> c : type.getInterfaces()) {
            StringBuilder name2;
            if (!base.isAssignableFrom(c) || (name2 = ReferencingUtilities.toPropertyName(base, c)) == null) continue;
            return name2;
        }
        return null;
    }

    public static MathTransformFactory nonNull(MathTransformFactory factory) {
        if (factory == null) {
            factory = DefaultMathTransformFactory.provider().caching(false);
        }
        return factory;
    }

    public static Map<Integer, String> identifierToName(ParameterDescriptorGroup parameters, Citation authority) {
        HashMap<Integer, String> mapping = new HashMap<Integer, String>();
        for (GeneralParameterDescriptor descriptor : parameters.descriptors()) {
            Identifier id = IdentifiedObjects.getIdentifier((IdentifiedObject)descriptor, authority);
            if (id == null) continue;
            String name = IdentifiedObjects.getName((IdentifiedObject)descriptor, authority);
            if (name == null) {
                name = IdentifiedObjects.getName((IdentifiedObject)descriptor, null);
            }
            if (mapping.put(Integer.valueOf(id.getCode()), name) == null) continue;
            throw new IllegalArgumentException(Errors.format((short)39, (Object)id));
        }
        return mapping;
    }

    public static ParameterDescriptorGroup rename(ParameterDescriptorGroup parameters, String code) {
        ReferenceIdentifier name;
        if (parameters != null && !code.equals((name = parameters.getName()).getCode())) {
            name = new ImmutableIdentifier(name.getAuthority(), name.getCodeSpace(), code);
            return new DefaultParameterDescriptorGroup(Map.of("name", name), parameters);
        }
        return parameters;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String[] getShortAxisNames(Vocabulary resources, CoordinateReferenceSystem crs) {
        boolean isGeographic = crs instanceof GeographicCRS;
        boolean isProjected = crs instanceof ProjectedCRS;
        CoordinateSystem cs = crs.getCoordinateSystem();
        String[] names = new String[cs.getDimension()];
        int i = 0;
        while (i < names.length) {
            int key = 0;
            CoordinateSystemAxis axis = cs.getAxis(i);
            AxisDirection direction = axis.getDirection();
            if (AxisDirections.isCardinal(direction)) {
                boolean isMeridional;
                boolean bl = isMeridional = direction == AxisDirection.NORTH || direction == AxisDirection.SOUTH;
                if (isGeographic) {
                    key = isMeridional ? 112 : 122;
                } else if (!isProjected) {
                    // empty if block
                }
            } else if (direction == AxisDirection.UP && isGeographic | isProjected) {
                key = 98;
            }
            names[i] = key != 0 ? resources.getString((short)key) : axis.getName().getCode();
            ++i;
        }
        return names;
    }
}

