/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.datum;

import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Map;
import java.util.Objects;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Length;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.internal.shared.ImplementationHelper;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.datum.Sphere;
import org.apache.sis.referencing.internal.shared.Formulas;
import org.apache.sis.referencing.internal.shared.NilReferencingObject;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.internal.shared.DoubleDouble;
import org.apache.sis.util.internal.shared.Numerics;
import org.apache.sis.xml.bind.gml.Measure;
import org.apache.sis.xml.bind.referencing.SecondDefiningParameter;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.datum.Ellipsoid;

@XmlType(name="EllipsoidType", propOrder={"semiMajorAxisMeasure", "secondDefiningParameter"})
@XmlRootElement(name="Ellipsoid")
public class DefaultEllipsoid
extends AbstractIdentifiedObject
implements Ellipsoid {
    private static final long serialVersionUID = -1149451543954764081L;
    private double semiMajorAxis;
    private double semiMinorAxis;
    private double inverseFlattening;
    private boolean ivfDefinitive;
    private Unit<Length> unit;

    protected DefaultEllipsoid(Map<String, ?> properties, double semiMajorAxis, double semiMinorAxis, double inverseFlattening, boolean ivfDefinitive, Unit<Length> unit) {
        super(properties);
        ArgumentChecks.ensureNonNull((String)"unit", unit);
        ArgumentChecks.ensureStrictlyPositive((String)"semiMajorAxis", (double)semiMajorAxis);
        ArgumentChecks.ensureStrictlyPositive((String)"semiMinorAxis", (double)semiMinorAxis);
        ArgumentChecks.ensureBetween((String)"inverseFlattening", (double)1.0, (double)Double.POSITIVE_INFINITY, (double)inverseFlattening);
        this.unit = unit;
        this.semiMajorAxis = semiMajorAxis;
        this.semiMinorAxis = semiMinorAxis;
        this.inverseFlattening = inverseFlattening;
        this.ivfDefinitive = ivfDefinitive;
    }

    protected DefaultEllipsoid(Ellipsoid ellipsoid) {
        super((IdentifiedObject)ellipsoid);
        this.semiMajorAxis = ellipsoid.getSemiMajorAxis();
        this.semiMinorAxis = ellipsoid.getSemiMinorAxis();
        this.inverseFlattening = ellipsoid.getInverseFlattening();
        this.ivfDefinitive = ellipsoid.isIvfDefinitive();
        this.unit = ellipsoid.getAxisUnit();
    }

    public static DefaultEllipsoid createEllipsoid(Map<String, ?> properties, double semiMajorAxis, double semiMinorAxis, Unit<Length> unit) {
        if (semiMajorAxis == semiMinorAxis) {
            return new Sphere(properties, semiMajorAxis, false, unit);
        }
        return new DefaultEllipsoid(properties, semiMajorAxis, semiMinorAxis, Formulas.getInverseFlattening(semiMajorAxis, semiMinorAxis), false, unit);
    }

    public static DefaultEllipsoid createFlattenedSphere(Map<String, ?> properties, double semiMajorAxis, double inverseFlattening, Unit<Length> unit) {
        if (Double.isInfinite(inverseFlattening)) {
            return new Sphere(properties, semiMajorAxis, true, unit);
        }
        return new DefaultEllipsoid(properties, semiMajorAxis, Formulas.getSemiMinor(semiMajorAxis, inverseFlattening), inverseFlattening, true, unit);
    }

    public static DefaultEllipsoid castOrCopy(Ellipsoid object) {
        if (object == null || object instanceof DefaultEllipsoid) {
            return (DefaultEllipsoid)object;
        }
        Map<String, ?> properties = IdentifiedObjects.getProperties((IdentifiedObject)object, new String[0]);
        double semiMajor = object.getSemiMajorAxis();
        Unit unit = object.getAxisUnit();
        return object.isIvfDefinitive() ? DefaultEllipsoid.createFlattenedSphere(properties, semiMajor, object.getInverseFlattening(), (Unit<Length>)unit) : DefaultEllipsoid.createEllipsoid(properties, semiMajor, object.getSemiMinorAxis(), (Unit<Length>)unit);
    }

    public Class<? extends Ellipsoid> getInterface() {
        return Ellipsoid.class;
    }

    public Unit<Length> getAxisUnit() {
        return this.unit;
    }

    public double getSemiMajorAxis() {
        return this.semiMajorAxis;
    }

    public double getSemiMinorAxis() {
        return this.semiMinorAxis;
    }

    public double getAuthalicRadius() {
        return Formulas.getAuthalicRadius(this.getSemiMajorAxis(), this.getSemiMinorAxis());
    }

    public double getGeocentricRadius(double \u03c6) {
        return Formulas.geocentricRadius(this, Math.toRadians(\u03c6));
    }

    @Deprecated(since="1.4", forRemoval=true)
    public double getRadius(double \u03c6) {
        return this.getGeocentricRadius(\u03c6);
    }

    public double getEccentricity() {
        return this.eccentricitySquared().sqrt().doubleValue();
    }

    public double getEccentricitySquared() {
        return this.eccentricitySquared().doubleValue();
    }

    private DoubleDouble eccentricitySquared() {
        DoubleDouble f = DefaultEllipsoid.flattening(this);
        return f.scalb(1).subtract(f.square());
    }

    private static DoubleDouble flattening(Ellipsoid e) {
        boolean decimal = true;
        if (e.isIvfDefinitive()) {
            return DoubleDouble.ONE.divide(e.getInverseFlattening(), true);
        }
        DoubleDouble a = DoubleDouble.of((double)e.getSemiMajorAxis(), (boolean)true);
        return a.subtract(e.getSemiMinorAxis(), true).divide(a);
    }

    public double getInverseFlattening() {
        return this.inverseFlattening;
    }

    public boolean isIvfDefinitive() {
        return this.ivfDefinitive;
    }

    public boolean isSphere() {
        return this.semiMajorAxis == this.semiMinorAxis;
    }

    public double semiMajorAxisDifference(Ellipsoid other) {
        double semiMajor = other.getSemiMajorAxis();
        semiMajor = other.getAxisUnit().getConverterTo(this.getAxisUnit()).convert(semiMajor);
        DoubleDouble a = DoubleDouble.of((double)semiMajor, (boolean)true);
        return a.subtract(this.getSemiMajorAxis(), true).doubleValue();
    }

    public double flatteningDifference(Ellipsoid other) {
        return DefaultEllipsoid.flattening(other).subtract(DefaultEllipsoid.flattening(this)).doubleValue();
    }

    final Map<String, ?> properties(Unit<Length> target) {
        return Map.of("name", "\u201c" + this.getName().getCode() + "\u201d converted to " + String.valueOf(target), "domains", this.getDomains());
    }

    public DefaultEllipsoid convertTo(Unit<Length> target) {
        UnitConverter c = this.unit.getConverterTo(target);
        if (c.isIdentity()) {
            return this;
        }
        return new DefaultEllipsoid(this.properties(target), c.convert(this.semiMajorAxis), c.convert(this.semiMinorAxis), this.inverseFlattening, this.ivfDefinitive, target);
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object, mode)) {
            return false;
        }
        switch (mode) {
            case STRICT: {
                DefaultEllipsoid that = (DefaultEllipsoid)object;
                return this.ivfDefinitive == that.ivfDefinitive && Numerics.equals((double)this.semiMajorAxis, (double)that.semiMajorAxis) && Numerics.equals((double)this.semiMinorAxis, (double)that.semiMinorAxis) && Numerics.equals((double)this.inverseFlattening, (double)that.inverseFlattening) && Objects.equals(this.unit, that.unit);
            }
            case BY_CONTRACT: {
                if (this.isIvfDefinitive() != ((Ellipsoid)object).isIvfDefinitive()) {
                    return false;
                }
            }
            case COMPATIBILITY: 
            case IGNORE_METADATA: {
                if (Numerics.equals((double)this.getInverseFlattening(), (double)((Ellipsoid)object).getInverseFlattening())) break;
                return false;
            }
        }
        Ellipsoid that = (Ellipsoid)object;
        Unit<Length> unit = this.getAxisUnit();
        if (!Utilities.deepEquals(unit, (Object)that.getAxisUnit(), (ComparisonMode)mode)) {
            return false;
        }
        UnitConverter c = mode.isApproximate() ? unit.getConverterTo(Units.METRE) : null;
        boolean isMinor = false;
        double v1 = this.getSemiMajorAxis();
        double v2 = that.getSemiMajorAxis();
        if (c == null ? Numerics.equals((double)v1, (double)v2) : Numerics.epsilonEqual((double)c.convert(v1), (double)c.convert(v2), (double)0.01)) {
            isMinor = true;
            v1 = this.getSemiMinorAxis();
            v2 = that.getSemiMinorAxis();
            if (c == null ? Numerics.equals((double)v1, (double)v2) : Numerics.epsilonEqual((double)c.convert(v1), (double)c.convert(v2), (double)0.01)) {
                return true;
            }
        }
        assert (mode != ComparisonMode.DEBUG) : Numerics.messageForDifference((String)(isMinor ? "semiMinorAxis" : "semiMajorAxis"), (double)v1, (double)v2);
        return false;
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + Double.doubleToLongBits(this.semiMajorAxis) + 31L * Double.doubleToLongBits(this.ivfDefinitive ? this.inverseFlattening : this.semiMinorAxis);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        super.formatTo(formatter);
        Convention convention = formatter.getConvention();
        boolean isWKT1 = convention.majorVersion() == 1;
        Unit<Length> unit = this.getAxisUnit();
        double length = this.getSemiMajorAxis();
        if (isWKT1) {
            length = unit.getConverterTo(Units.METRE).convert(length);
        }
        formatter.append(length);
        double inverseFlattening = this.getInverseFlattening();
        formatter.append(Double.isInfinite(inverseFlattening) ? 0.0 : inverseFlattening);
        if (isWKT1) {
            return "Spheroid";
        }
        if (!convention.isSimplified() || !Units.METRE.equals(unit)) {
            formatter.append(unit);
        }
        return "Ellipsoid";
    }

    private DefaultEllipsoid() {
        super((IdentifiedObject)NilReferencingObject.INSTANCE);
    }

    private void afterUnmarshal(Unmarshaller unmarshaller, Object parent) {
        if (this.ivfDefinitive) {
            if (this.semiMinorAxis == 0.0) {
                this.semiMinorAxis = Formulas.getSemiMinor(this.semiMajorAxis, this.inverseFlattening);
            }
        } else if (this.inverseFlattening == 0.0) {
            this.inverseFlattening = Formulas.getInverseFlattening(this.semiMajorAxis, this.semiMinorAxis);
        } else if (this.inverseFlattening == Double.POSITIVE_INFINITY && this.semiMinorAxis == 0.0) {
            this.semiMinorAxis = this.semiMajorAxis;
        }
        if (this.unit == null) {
            this.unit = Units.METRE;
            Measure.missingUOM(DefaultEllipsoid.class, (String)"semiMajorAxis");
        }
    }

    @XmlElement(name="semiMajorAxis", required=true)
    private Measure getSemiMajorAxisMeasure() {
        return new Measure(this.semiMajorAxis, this.unit);
    }

    private void setSemiMajorAxisMeasure(Measure measure) {
        if (this.semiMajorAxis == 0.0) {
            Unit<Length> uom = this.unit;
            this.semiMajorAxis = measure.value;
            ArgumentChecks.ensureStrictlyPositive((String)"semiMajorAxis", (double)this.semiMajorAxis);
            this.unit = measure.getUnit(Length.class);
            this.harmonizeAxisUnits(uom);
        } else {
            ImplementationHelper.propertyAlreadySet(DefaultEllipsoid.class, (String)"setSemiMajorAxisMeasure", (String)"semiMajorAxis");
        }
    }

    @XmlElement(name="secondDefiningParameter", required=true)
    private SecondDefiningParameter getSecondDefiningParameter() {
        return new SecondDefiningParameter(this, true);
    }

    private void setSecondDefiningParameter(SecondDefiningParameter second) {
        boolean isIvfDefinitive;
        Measure measure;
        if (second.secondDefiningParameter != null) {
            second = second.secondDefiningParameter;
        }
        boolean duplicate = false;
        if (Boolean.TRUE.equals(second.isSphere)) {
            boolean bl = duplicate = this.inverseFlattening != 0.0;
            if (!duplicate) {
                this.inverseFlattening = Double.POSITIVE_INFINITY;
            }
        }
        if ((measure = second.measure) != null && !(duplicate |= ((isIvfDefinitive = second.isIvfDefinitive()) ? this.inverseFlattening : this.semiMinorAxis) != 0.0)) {
            this.ivfDefinitive = isIvfDefinitive;
            double value = measure.value;
            if (isIvfDefinitive) {
                if (value == 0.0) {
                    value = Double.POSITIVE_INFINITY;
                }
                this.inverseFlattening = value;
                ArgumentChecks.ensureBetween((String)"inverseFlattening", (double)1.0, (double)Double.POSITIVE_INFINITY, (double)this.inverseFlattening);
            } else {
                this.semiMinorAxis = value;
                ArgumentChecks.ensureStrictlyPositive((String)"semiMinorAxis", (double)this.semiMinorAxis);
                this.harmonizeAxisUnits((Unit<Length>)measure.getUnit(Length.class));
            }
        }
        if (duplicate) {
            ImplementationHelper.propertyAlreadySet(DefaultEllipsoid.class, (String)"setSecondDefiningParameter", (String)"secondDefiningParameter");
        }
    }

    private void harmonizeAxisUnits(Unit<Length> uom) {
        if (this.unit == null) {
            this.unit = uom;
        } else if (uom != null && uom != this.unit) {
            this.semiMinorAxis = uom.getConverterTo(this.unit).convert(this.semiMinorAxis);
        }
    }
}

