/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import jakarta.xml.bind.annotation.XmlTransient;
import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.measure.IncommensurableException;
import javax.measure.Unit;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.measure.Range;
import org.apache.sis.parameter.DefaultParameterDescriptor;
import org.apache.sis.parameter.DefaultParameterValue;
import org.apache.sis.parameter.FilteredParameters;
import org.apache.sis.parameter.ParameterFormat;
import org.apache.sis.parameter.UnmodifiableParameterValueGroup;
import org.apache.sis.parameter.Verifier;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ObjectConverters;
import org.apache.sis.util.Printable;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.bind.metadata.replace.ServiceParameter;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.InvalidParameterNameException;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.MemberName;

@XmlTransient
public abstract class Parameters
implements ParameterValueGroup,
Cloneable,
Printable {
    protected Parameters() {
    }

    public static boolean isUnmodifiable(ParameterValueGroup parameters) {
        return parameters instanceof UnmodifiableParameterValueGroup;
    }

    public static Parameters unmodifiable(ParameterValueGroup parameters) {
        return UnmodifiableParameterValueGroup.create(parameters);
    }

    public static Parameters unmodifiable(ParameterValueGroup parameters, Predicate<? super GeneralParameterDescriptor> filter) {
        return FilteredParameters.create(UnmodifiableParameterValueGroup.create(parameters), filter);
    }

    public static Parameters castOrWrap(ParameterValueGroup parameters) {
        if (parameters == null || parameters instanceof Parameters) {
            return (Parameters)parameters;
        }
        return new Wrapper(parameters);
    }

    public static <T> ParameterDescriptor<T> cast(ParameterDescriptor<?> descriptor, Class<T> valueClass) throws ClassCastException {
        Class actual;
        ArgumentChecks.ensureNonNull((String)"valueClass", valueClass);
        if (descriptor != null && !valueClass.equals(actual = descriptor.getValueClass())) {
            throw new ClassCastException(Resources.format((short)23, Verifier.getDisplayName(descriptor), actual));
        }
        return descriptor;
    }

    public static <T> ParameterValue<T> cast(ParameterValue<?> parameter, Class<T> valueClass) throws ClassCastException {
        ParameterDescriptor descriptor;
        Class actual;
        ArgumentChecks.ensureNonNull((String)"valueClass", valueClass);
        if (parameter != null && !valueClass.equals(actual = (descriptor = parameter.getDescriptor()).getValueClass())) {
            throw new ClassCastException(Resources.format((short)23, Verifier.getDisplayName((GeneralParameterDescriptor)descriptor), actual));
        }
        return parameter;
    }

    public static GeneralParameterDescriptor[] getDescriptors(GeneralParameterValue ... parameters) {
        if (parameters == null) {
            return null;
        }
        GeneralParameterDescriptor[] descriptors = new GeneralParameterDescriptor[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            GeneralParameterValue p = parameters[i];
            if (p == null) continue;
            descriptors[i] = p.getDescriptor();
        }
        return descriptors;
    }

    public static MemberName getMemberName(ParameterDescriptor<?> parameter) {
        return ServiceParameter.getMemberName(parameter);
    }

    public static Range<?> getValueDomain(ParameterDescriptor<?> descriptor) {
        if (descriptor != null) {
            if (descriptor instanceof DefaultParameterDescriptor) {
                return ((DefaultParameterDescriptor)descriptor).getValueDomain();
            }
            Class<Object> valueClass = descriptor.getValueClass();
            Comparable minimumValue = descriptor.getMinimumValue();
            Comparable maximumValue = descriptor.getMaximumValue();
            if (valueClass == null && (valueClass = Classes.findCommonClass((Class)Classes.getClass((Object)minimumValue), (Class)Classes.getClass((Object)maximumValue))) == null) {
                valueClass = Object.class;
            }
            if ((minimumValue == null || valueClass.isInstance(minimumValue)) && (maximumValue == null || valueClass.isInstance(maximumValue))) {
                if (Number.class.isAssignableFrom(valueClass)) {
                    Unit unit = descriptor.getUnit();
                    if (unit != null) {
                        return new MeasurementRange(valueClass, (Number)((Object)minimumValue), true, (Number)((Object)maximumValue), true, unit);
                    }
                    if (minimumValue != null || maximumValue != null) {
                        return new NumberRange(valueClass, (Number)((Object)minimumValue), true, (Number)((Object)maximumValue), true);
                    }
                } else if (minimumValue != null || maximumValue != null) {
                    return new Range(valueClass, minimumValue, true, maximumValue, true);
                }
            }
        }
        return null;
    }

    private String getName(GeneralParameterDescriptor source) {
        Citation authority;
        String name;
        ReferenceIdentifier group;
        ParameterDescriptorGroup descriptor = this.getDescriptor();
        if (descriptor != null && (group = descriptor.getName()) != null && ((name = IdentifiedObjects.getName((IdentifiedObject)source, authority = group.getAuthority())) != null || authority == null)) {
            return name;
        }
        return IdentifiedObjects.getName((IdentifiedObject)source, null);
    }

    ParameterValue<?> parameterIfExist(String name) throws ParameterNotFoundException {
        ParameterDescriptor d2;
        int i1 = 0;
        int i2 = 0;
        ParameterValue first = null;
        ParameterValue ambiguity = null;
        List values = this.values();
        int size = values.size();
        for (int i = 0; i < size; ++i) {
            ParameterValue param;
            GeneralParameterValue value = (GeneralParameterValue)values.get(i);
            if (!(value instanceof ParameterValue) || !IdentifiedObjects.isHeuristicMatchForName((IdentifiedObject)(param = (ParameterValue)value).getDescriptor(), name)) continue;
            if (first == null) {
                first = param;
                i1 = i;
                continue;
            }
            ambiguity = param;
            i2 = i;
        }
        if (ambiguity == null || !this.isKnownImplementation()) {
            return first;
        }
        ParameterDescriptor d1 = first.getDescriptor();
        String message = d1 == (d2 = ambiguity.getDescriptor()) ? Errors.format((short)114, (Object)name, (Object)i1, (Object)i2) : Errors.format((short)2, (Object)IdentifiedObjects.toString((Identifier)d1.getName()), (Object)IdentifiedObjects.toString((Identifier)d2.getName()), (Object)name);
        throw new ParameterNotFoundException(message, name);
    }

    ParameterValue<?> getParameter(ParameterDescriptor<?> parameter) throws ParameterNotFoundException {
        ArgumentChecks.ensureNonNull((String)"parameter", parameter);
        String name = this.getName((GeneralParameterDescriptor)parameter);
        ParameterValue<?> value = this.parameterIfExist(name);
        if (value == null || this.isKnownImplementation()) {
            return value;
        }
        return this.parameter(name);
    }

    boolean isKnownImplementation() {
        return false;
    }

    public Optional<URI> getSourceFile(ParameterDescriptor<?> parameter) throws ParameterNotFoundException {
        ParameterValue<?> p = this.getParameter(parameter);
        if (p instanceof DefaultParameterValue) {
            return ((DefaultParameterValue)p).getSourceFile();
        }
        return Optional.empty();
    }

    public <T> T getValue(ParameterDescriptor<T> parameter) throws ParameterNotFoundException {
        ParameterValue<?> p = this.getParameter(parameter);
        if (p != null) {
            Class type = parameter.getValueClass();
            Unit unit = parameter.getUnit();
            Object value = p.getValue();
            if (value != null) {
                if (unit != null) {
                    value = type.isArray() ? (Object)p.doubleValueList(unit) : Double.valueOf(p.doubleValue(unit));
                }
                return (T)ObjectConverters.convert((Object)value, (Class)type);
            }
        }
        return (T)parameter.getDefaultValue();
    }

    public <T> T getMandatoryValue(ParameterDescriptor<T> parameter) throws ParameterNotFoundException {
        ParameterValue<?> p = this.getParameter(parameter);
        if (p != null) {
            Class type = parameter.getValueClass();
            Unit unit = parameter.getUnit();
            Object value = unit == null ? p.getValue() : (type.isArray() ? (Object)p.doubleValueList(unit) : Double.valueOf(p.doubleValue(unit)));
            Object result = value != null ? ObjectConverters.convert((Object)value, (Class)type) : parameter.getDefaultValue();
            if (result != null) {
                return (T)result;
            }
        }
        throw new IllegalStateException(Resources.format((short)44, Verifier.getDisplayName(parameter)));
    }

    private static <T> T defaultValue(ParameterDescriptor<T> parameter) throws IllegalStateException {
        Object value = parameter.getDefaultValue();
        if (value != null) {
            return (T)value;
        }
        throw new IllegalStateException(Resources.format((short)44, Verifier.getDisplayName(parameter)));
    }

    public boolean booleanValue(ParameterDescriptor<Boolean> parameter) throws ParameterNotFoundException {
        ParameterValue<?> value = this.getParameter(parameter);
        return value != null ? value.booleanValue() : Parameters.defaultValue(parameter).booleanValue();
    }

    public int intValue(ParameterDescriptor<? extends Number> parameter) throws ParameterNotFoundException {
        ParameterValue<?> value = this.getParameter(parameter);
        return value != null ? value.intValue() : Parameters.defaultValue(parameter).intValue();
    }

    public int[] intValueList(ParameterDescriptor<int[]> parameter) throws ParameterNotFoundException {
        ParameterValue<?> value = this.getParameter(parameter);
        return value != null ? value.intValueList() : Parameters.defaultValue(parameter);
    }

    public double doubleValue(ParameterDescriptor<? extends Number> parameter) throws ParameterNotFoundException {
        ParameterValue<?> value = this.getParameter(parameter);
        if (value != null) {
            Unit unit = parameter.getUnit();
            return unit != null ? value.doubleValue(unit) : value.doubleValue();
        }
        return Parameters.defaultValue(parameter).doubleValue();
    }

    public double doubleValue(ParameterDescriptor<? extends Number> parameter, Unit<?> unit) throws ParameterNotFoundException {
        ArgumentChecks.ensureNonNull((String)"unit", unit);
        ParameterValue<?> value = this.getParameter(parameter);
        if (value != null) {
            return value.doubleValue(unit);
        }
        double d = Parameters.defaultValue(parameter).doubleValue();
        Unit source = parameter.getUnit();
        if (source != null) {
            try {
                d = source.getConverterToAny(unit).convert(d);
            }
            catch (IncommensurableException e) {
                throw new IllegalArgumentException(Errors.format((short)84, (Object)source, unit), e);
            }
        }
        return d;
    }

    public double[] doubleValueList(ParameterDescriptor<double[]> parameter) throws ParameterNotFoundException {
        ParameterValue<?> value = this.getParameter(parameter);
        if (value != null) {
            Unit unit = parameter.getUnit();
            return unit != null ? value.doubleValueList(unit) : value.doubleValueList();
        }
        return Parameters.defaultValue(parameter);
    }

    public String stringValue(ParameterDescriptor<? extends CharSequence> parameter) throws ParameterNotFoundException {
        ParameterValue<?> value = this.getParameter(parameter);
        return value != null ? value.stringValue() : Parameters.defaultValue(parameter).toString();
    }

    public <T> ParameterValue<T> getOrCreate(ParameterDescriptor<T> parameter) throws ParameterNotFoundException {
        return Parameters.cast(this.parameter(this.getName((GeneralParameterDescriptor)parameter)), parameter.getValueClass());
    }

    public Parameters clone() {
        try {
            return (Parameters)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void copy(ParameterValueGroup values, ParameterValueGroup destination) throws InvalidParameterNameException, InvalidParameterValueException {
        Integer ZERO = 0;
        HashMap<String, Integer> occurrences = new HashMap<String, Integer>();
        for (GeneralParameterValue value : values.values()) {
            String name = value.getDescriptor().getName().getCode();
            int occurrence = occurrences.getOrDefault(name, ZERO);
            if (value instanceof ParameterValueGroup) {
                List groups = destination.groups(name);
                Parameters.copy((ParameterValueGroup)value, occurrence < groups.size() ? (ParameterValueGroup)groups.get(occurrence) : destination.addGroup(name));
            } else {
                ParameterValue target;
                ParameterValue source = (ParameterValue)value;
                if (occurrence == 0) {
                    try {
                        target = destination.parameter(name);
                    }
                    catch (ParameterNotFoundException cause) {
                        throw (InvalidParameterNameException)new InvalidParameterNameException(Errors.format((short)172, (Object)name), name).initCause((Throwable)cause);
                    }
                } else {
                    target = (ParameterValue)Parameters.getOrCreate(destination, name, occurrence);
                }
                Object v = source.getValue();
                Unit unit = source.getUnit();
                if (unit == null) {
                    target.setValue(v);
                } else if (v instanceof Number) {
                    target.setValue(((Number)v).doubleValue(), unit);
                } else if (v instanceof double[]) {
                    target.setValue((double[])v, unit);
                } else if (v != target.getValue()) {
                    throw new InvalidParameterValueException(Errors.format((short)59, (Object)name, (Object)v), name, v);
                }
                if (source instanceof DefaultParameterValue && target instanceof DefaultParameterValue) {
                    ((DefaultParameterValue)source).getSourceFile().ifPresent(file -> ((DefaultParameterValue)target).setSourceFile((URI)file));
                }
            }
            occurrences.put(name, occurrence + 1);
        }
    }

    private static GeneralParameterValue getOrCreate(ParameterValueGroup values, String name, int n) {
        for (GeneralParameterValue value : values.values()) {
            if (!name.equals(value.getDescriptor().getName().getCode()) || --n >= 0) continue;
            return value;
        }
        if (n == 0) {
            GeneralParameterValue value = values.getDescriptor().descriptor(name).createValue();
            values.values().add(value);
            return value;
        }
        throw new IndexOutOfBoundsException(name);
    }

    public String toString() {
        return ParameterFormat.sharedFormat(this);
    }

    public void print() {
        ParameterFormat.print(this);
    }

    private static final class Wrapper
    extends Parameters
    implements Serializable {
        private static final long serialVersionUID = -5491790565456920471L;
        private final ParameterValueGroup delegate;

        Wrapper(ParameterValueGroup delegate) {
            this.delegate = delegate;
        }

        public ParameterDescriptorGroup getDescriptor() {
            return this.delegate.getDescriptor();
        }

        public List<GeneralParameterValue> values() {
            return this.delegate.values();
        }

        public ParameterValue<?> parameter(String name) {
            return this.delegate.parameter(name);
        }

        public List<ParameterValueGroup> groups(String name) {
            return this.delegate.groups(name);
        }

        public ParameterValueGroup addGroup(String name) {
            return this.delegate.addGroup(name);
        }

        @Override
        public Parameters clone() {
            return new Wrapper(this.delegate.clone());
        }
    }
}

