/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.entity;

import java.sql.Timestamp;
import java.util.Objects;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.common.utils.UUIDUtils;

public final class AuthPathDO
extends BaseDO {
    private static final long serialVersionUID = 2265360597468199607L;
    private String authId;
    private String appName;
    private String path;
    private Boolean enabled;

    public AuthPathDO() {
    }

    public AuthPathDO(String authId, String appName, String path, Boolean enabled) {
        this.authId = authId;
        this.appName = appName;
        this.path = path;
        this.enabled = enabled;
    }

    public String getAuthId() {
        return this.authId;
    }

    public void setAuthId(String authId) {
        this.authId = authId;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public static AuthPathDO create(String path, String authId, String appName) {
        Timestamp currentTime = new Timestamp(System.currentTimeMillis());
        return AuthPathDO.builder().id(UUIDUtils.getInstance().generateShortUuid()).authId(authId).appName(appName).path(path).enabled(true).dateCreated(currentTime).dateUpdated(currentTime).build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (Objects.isNull(o) || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AuthPathDO that = (AuthPathDO)o;
        return Objects.equals(this.authId, that.authId) && Objects.equals(this.appName, that.appName) && Objects.equals(this.path, that.path) && Objects.equals(this.enabled, that.enabled);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.authId, this.appName, this.path, this.enabled);
    }

    public static AuthPathDOBuilder builder() {
        return new AuthPathDOBuilder();
    }

    public static final class AuthPathDOBuilder {
        private String authId;
        private String appName;
        private String path;
        private Boolean enabled;
        private String id;
        private Timestamp dateCreated;
        private Timestamp dateUpdated;

        private AuthPathDOBuilder() {
        }

        public AuthPathDOBuilder authId(String authId) {
            this.authId = authId;
            return this;
        }

        public AuthPathDOBuilder appName(String appName) {
            this.appName = appName;
            return this;
        }

        public AuthPathDOBuilder path(String path) {
            this.path = path;
            return this;
        }

        public AuthPathDOBuilder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public AuthPathDOBuilder id(String id) {
            this.id = id;
            return this;
        }

        public AuthPathDOBuilder dateCreated(Timestamp dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public AuthPathDOBuilder dateUpdated(Timestamp dateUpdated) {
            this.dateUpdated = dateUpdated;
            return this;
        }

        public AuthPathDO build() {
            AuthPathDO authPathDO = new AuthPathDO();
            authPathDO.setAuthId(this.authId);
            authPathDO.setAppName(this.appName);
            authPathDO.setPath(this.path);
            authPathDO.setEnabled(this.enabled);
            authPathDO.setId(this.id);
            authPathDO.setDateCreated(this.dateCreated);
            authPathDO.setDateUpdated(this.dateUpdated);
            return authPathDO;
        }
    }
}

