/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf.internal.schema.deserializer.scalar;

import com.fasterxml.jackson.databind.JavaType;
import io.protostuff.InputEx;
import io.protostuff.compiler.model.Field;
import io.protostuff.runtime.FieldSchema;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import org.apache.servicecomb.foundation.common.utils.bean.LongSetter;
import org.apache.servicecomb.foundation.protobuf.internal.bean.PropertyDescriptor;
import org.apache.servicecomb.foundation.protobuf.internal.schema.deserializer.scalar.AbstractScalarReadSchemas;

public class Int64ReadSchemas {
    public static <T> FieldSchema<T> create(Field protoField, PropertyDescriptor propertyDescriptor) {
        JavaType javaType = propertyDescriptor.getJavaType();
        if (Long.TYPE.equals(javaType.getRawClass())) {
            return new LongFiledLongPrimitiveSchema(protoField, propertyDescriptor);
        }
        return new Int64Schema(protoField, propertyDescriptor);
    }

    private static class LongFiledLongPrimitiveSchema<T>
    extends FieldSchema<T> {
        protected final LongSetter<T> setter;

        public LongFiledLongPrimitiveSchema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor.getJavaType());
            this.setter = (LongSetter)propertyDescriptor.getSetter();
        }

        @Override
        public int mergeFrom(InputEx input, T message) throws IOException {
            long value = input.readInt64();
            this.setter.set(message, value);
            return input.readFieldNumber();
        }
    }

    private static class Int64Schema<T>
    extends AbstractScalarReadSchemas.AbstractLongSchema<T> {
        public Int64Schema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor);
        }

        @Override
        public int mergeFrom(InputEx input, T message) throws IOException {
            long value = input.readInt64();
            if (Date.class.equals((Object)this.javaType.getRawClass())) {
                this.setter.set(message, (Object)new Date(value));
            } else if (LocalDate.class.equals((Object)this.javaType.getRawClass())) {
                this.setter.set(message, (Object)LocalDate.ofEpochDay(value));
            } else if (LocalDateTime.class.equals((Object)this.javaType.getRawClass())) {
                this.setter.set(message, (Object)LocalDateTime.ofInstant(Instant.ofEpochMilli(value), ZoneOffset.UTC));
            } else {
                this.setter.set(message, (Object)value);
            }
            return input.readFieldNumber();
        }
    }
}

