/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.governance;

import java.util.Map;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.governance.marker.GovernanceRequestExtractor;

public final class MatchType {
    public static final String REST = "rest";
    public static final String RPC = "rpc";

    public static GovernanceRequestExtractor createGovHttpRequest(Invocation invocation) {
        return new GovernanceRequestExtractorImpl(invocation);
    }

    private static String concatAbsolutePath(String basePath, String operationPath) {
        return ("/" + MatchType.nonNullify(basePath) + "/" + MatchType.nonNullify(operationPath)).replaceAll("/{2,}", "/");
    }

    private static String nonNullify(String path) {
        return path == null ? "" : path;
    }

    private static class GovernanceRequestExtractorImpl
    implements GovernanceRequestExtractor {
        private final Invocation invocation;

        private GovernanceRequestExtractorImpl(Invocation invocation) {
            this.invocation = invocation;
        }

        public String apiPath() {
            if (MatchType.REST.equalsIgnoreCase(this.invocation.getOperationMeta().getConfig().getGovernanceMatchType())) {
                if (this.invocation.isConsumer()) {
                    return MatchType.concatAbsolutePath(this.invocation.getSchemaMeta().getSwagger().getBasePath(), this.invocation.getOperationMeta().getOperationPath());
                }
                if (this.invocation.getRequestEx() != null) {
                    return this.invocation.getRequestEx().getRequestURI();
                }
            }
            if (this.invocation.isConsumer()) {
                return this.invocation.getOperationMeta().getMicroserviceQualifiedName();
            }
            return this.invocation.getOperationMeta().getSchemaQualifiedName();
        }

        public String method() {
            return this.invocation.getOperationMeta().getHttpMethod();
        }

        public String header(String key) {
            Map<String, Object> arguments = this.invocation.getSwaggerArguments();
            if (arguments != null && arguments.get(key) != null) {
                return arguments.get(key).toString();
            }
            if (this.invocation.getContext(key) != null) {
                return this.invocation.getContext(key);
            }
            if (this.invocation.getRequestEx() != null) {
                return this.invocation.getRequestEx().getHeader(key);
            }
            return null;
        }

        public String instanceId() {
            if (this.invocation.isConsumer()) {
                return this.invocation.getEndpoint().getMicroserviceInstance().getInstanceId();
            }
            return null;
        }

        public String serviceName() {
            if (this.invocation.isConsumer()) {
                return this.invocation.getMicroserviceName();
            }
            return null;
        }

        public Object sourceRequest() {
            return this.invocation;
        }
    }
}

