/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.filter.impl;

import jakarta.annotation.Nonnull;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.exception.Exceptions;
import org.apache.servicecomb.core.filter.FilterNode;
import org.apache.servicecomb.core.filter.ProducerFilter;
import org.apache.servicecomb.core.invocation.InvocationStageTrace;
import org.apache.servicecomb.swagger.invocation.Response;
import org.springframework.stereotype.Component;

@Component
public class ScheduleFilter
implements ProducerFilter {
    public static final String NAME = "schedule";

    @Override
    @Nonnull
    public String getName() {
        return NAME;
    }

    @Override
    public CompletableFuture<Response> onFilter(Invocation invocation, FilterNode next) {
        invocation.getInvocationStageTrace().startSchedule();
        Executor executor = invocation.getOperationMeta().getExecutor();
        return CompletableFuture.completedFuture(null).thenComposeAsync(response -> this.runInExecutor(invocation, next), executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletableFuture<Response> runInExecutor(Invocation invocation, FilterNode next) {
        invocation.onExecuteStart();
        try {
            InvocationStageTrace trace = invocation.getInvocationStageTrace();
            trace.startServerFiltersRequest();
            invocation.onStartHandlersRequest();
            this.checkInQueueTimeout(invocation);
            CompletionStage completionStage = next.onFilter(invocation).whenComplete((response, throwable) -> this.whenComplete(invocation));
            return completionStage;
        }
        finally {
            invocation.onExecuteFinish();
        }
    }

    private void checkInQueueTimeout(Invocation invocation) {
        long nanoTimeout = invocation.getOperationMeta().getConfig().getNanoRequestWaitInPoolTimeout(invocation.getTransport().getName());
        if (System.nanoTime() - invocation.getInvocationStageTrace().getStart() > nanoTimeout) {
            throw Exceptions.genericProducer("Request in the queue timed out.");
        }
    }

    private void whenComplete(Invocation invocation) {
        invocation.getInvocationStageTrace().finishHandlersResponse();
        invocation.getInvocationStageTrace().finishServerFiltersResponse();
    }
}

