/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.executor;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import org.apache.servicecomb.core.executor.ThreadPoolExecutorEx;

public class LinkedBlockingQueueEx
extends LinkedBlockingQueue<Runnable> {
    private static final long serialVersionUID = -1L;
    private volatile transient ThreadPoolExecutorEx owner = null;

    public LinkedBlockingQueueEx(int capacity) {
        super(capacity);
    }

    public void setOwner(ThreadPoolExecutorEx owner) {
        this.owner = owner;
    }

    @Override
    public boolean offer(Runnable runnable) {
        if (this.owner == null) {
            return super.offer(runnable);
        }
        if (this.owner.getPoolSize() == this.owner.getMaximumPoolSize()) {
            return super.offer(runnable);
        }
        if (this.owner.getNotFinished() <= this.owner.getPoolSize()) {
            return super.offer(runnable);
        }
        if (this.owner.getPoolSize() < this.owner.getMaximumPoolSize()) {
            return false;
        }
        return super.offer(runnable);
    }

    public boolean force(Runnable runnable) {
        if (this.owner == null || this.owner.isShutdown()) {
            throw new RejectedExecutionException("queue is not running.");
        }
        return super.offer(runnable);
    }
}

