/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.highway;

import com.google.common.annotations.VisibleForTesting;
import com.netflix.config.DynamicPropertyFactory;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Vertx;
import io.vertx.core.net.ClientOptionsBase;
import jakarta.ws.rs.core.Response;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.apache.servicecomb.codec.protobuf.definition.OperationProtobuf;
import org.apache.servicecomb.codec.protobuf.definition.ProtobufManager;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.foundation.ssl.SSLCustom;
import org.apache.servicecomb.foundation.ssl.SSLOption;
import org.apache.servicecomb.foundation.ssl.SSLOptionFactory;
import org.apache.servicecomb.foundation.vertx.VertxTLSBuilder;
import org.apache.servicecomb.foundation.vertx.VertxUtils;
import org.apache.servicecomb.foundation.vertx.client.ClientPoolFactory;
import org.apache.servicecomb.foundation.vertx.client.ClientPoolManager;
import org.apache.servicecomb.foundation.vertx.client.ClientVerticle;
import org.apache.servicecomb.foundation.vertx.client.tcp.TcpClientConfig;
import org.apache.servicecomb.foundation.vertx.client.tcp.TcpData;
import org.apache.servicecomb.swagger.invocation.AsyncResponse;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.exception.CommonExceptionData;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.apache.servicecomb.transport.highway.HighwayClientConnection;
import org.apache.servicecomb.transport.highway.HighwayClientConnectionPool;
import org.apache.servicecomb.transport.highway.HighwayClientPackage;
import org.apache.servicecomb.transport.highway.HighwayClientPoolFactory;
import org.apache.servicecomb.transport.highway.HighwayCodec;
import org.apache.servicecomb.transport.highway.HighwayConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HighwayClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(HighwayClient.class);
    private static final String SSL_KEY = "highway.consumer";
    private ClientPoolManager<HighwayClientConnectionPool> clientMgr;

    public void init(Vertx vertx) throws Exception {
        TcpClientConfig normalConfig = this.createTcpClientConfig();
        normalConfig.setSsl(false);
        TcpClientConfig sslConfig = this.createTcpClientConfig();
        sslConfig.setSsl(true);
        this.clientMgr = new ClientPoolManager(vertx, (ClientPoolFactory)new HighwayClientPoolFactory(normalConfig, sslConfig));
        DeploymentOptions deployOptions = VertxUtils.createClientDeployOptions(this.clientMgr, (int)HighwayConfig.getClientThreadCount());
        Map result = VertxUtils.blockDeploy((Vertx)vertx, ClientVerticle.class, (DeploymentOptions)deployOptions);
        if (!((Boolean)result.get("code")).booleanValue()) {
            throw new IllegalStateException((String)result.get("message"));
        }
    }

    @VisibleForTesting
    TcpClientConfig createTcpClientConfig() {
        TcpClientConfig tcpClientConfig = new TcpClientConfig();
        tcpClientConfig.setMsLoginTimeout(DynamicPropertyFactory.getInstance().getLongProperty("servicecomb.request.timeout", 30000L).get());
        SSLOptionFactory factory = SSLOptionFactory.createSSLOptionFactory((String)SSL_KEY, null);
        SSLOption sslOption = factory == null ? SSLOption.buildFromYaml((String)SSL_KEY) : factory.createSSLOption();
        SSLCustom sslCustom = SSLCustom.createSSLCustom((String)sslOption.getSslCustomClass());
        VertxTLSBuilder.buildClientOptionsBase((SSLOption)sslOption, (SSLCustom)sslCustom, (ClientOptionsBase)tcpClientConfig);
        if (!sslOption.isCheckCNHost()) {
            tcpClientConfig.setHostnameVerificationAlgorithm("");
        } else {
            tcpClientConfig.setHostnameVerificationAlgorithm("HTTPS");
        }
        return tcpClientConfig;
    }

    public void send(Invocation invocation, AsyncResponse asyncResp) throws Exception {
        invocation.getInvocationStageTrace().startGetConnection();
        HighwayClientConnection tcpClient = this.findClientPool(invocation);
        invocation.getInvocationStageTrace().startClientFiltersRequest();
        OperationProtobuf operationProtobuf = ProtobufManager.getOrCreateOperation((Invocation)invocation);
        HighwayClientPackage clientPackage = this.createClientPackage(invocation, operationProtobuf);
        invocation.onStartSendRequest();
        tcpClient.send(clientPackage, ar -> {
            invocation.getInvocationStageTrace().finishWriteToBuffer(clientPackage.getFinishWriteToBuffer());
            invocation.getInvocationStageTrace().finishReceiveResponse();
            invocation.getResponseExecutor().execute(() -> {
                invocation.getInvocationStageTrace().startClientFiltersResponse();
                if (ar.failed()) {
                    invocation.getInvocationStageTrace().finishClientFiltersResponse();
                    if (ar.cause() instanceof TimeoutException) {
                        LOGGER.info("Request timeout, Details: {}.", (Object)ar.cause().getMessage());
                        asyncResp.consumerFail((Throwable)new InvocationException((Response.StatusType)Response.Status.REQUEST_TIMEOUT, (Object)new CommonExceptionData("Request Timeout.")));
                        return;
                    }
                    asyncResp.consumerFail(ar.cause());
                    return;
                }
                try {
                    Response response = HighwayCodec.decodeResponse(invocation, operationProtobuf, (TcpData)ar.result());
                    invocation.getInvocationStageTrace().finishClientFiltersResponse();
                    asyncResp.complete(response);
                }
                catch (Throwable e) {
                    invocation.getInvocationStageTrace().finishClientFiltersResponse();
                    asyncResp.consumerFail(e);
                }
            });
        });
    }

    public HighwayClientPackage createClientPackage(Invocation invocation, OperationProtobuf operationProtobuf) {
        long msRequestTimeout = invocation.getOperationMeta().getConfig().getMsRequestTimeout();
        return new HighwayClientPackage(invocation, operationProtobuf, msRequestTimeout);
    }

    public HighwayClientConnection findClientPool(Invocation invocation) {
        HighwayClientConnection tcpClient = (HighwayClientConnection)((HighwayClientConnectionPool)((Object)this.clientMgr.findClientPool(invocation.isSync()))).findOrCreateClient(invocation.getEndpoint().getEndpoint());
        invocation.getInvocationStageTrace().finishGetConnection();
        return tcpClient;
    }
}

