/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf.internal.schema.deserializer.repeated.impl.bools;

import com.fasterxml.jackson.databind.JavaType;
import io.protostuff.InputEx;
import io.protostuff.compiler.model.Field;
import io.protostuff.runtime.FieldSchema;
import java.io.IOException;
import java.util.Arrays;
import org.apache.servicecomb.foundation.common.utils.bean.Getter;
import org.apache.servicecomb.foundation.common.utils.bean.Setter;
import org.apache.servicecomb.foundation.protobuf.internal.bean.PropertyDescriptor;
import org.apache.servicecomb.foundation.protobuf.internal.schema.deserializer.repeated.AbstractPrimitiveReaders;
import org.apache.servicecomb.foundation.protobuf.internal.schema.deserializer.repeated.PrimitiveArrayBuilderWrapper;
import org.apache.servicecomb.foundation.protobuf.internal.schema.deserializer.repeated.RepeatedReadSchemas;

public class BoolRepeatedReadSchemas {
    public static <T> FieldSchema<T> create(Field protoField, PropertyDescriptor propertyDescriptor, AbstractPrimitiveReaders<boolean[], Boolean> readers) {
        JavaType javaType = propertyDescriptor.getJavaType();
        if (boolean[].class.equals((Object)javaType.getRawClass())) {
            return new BoolPrimitiveArray(protoField, propertyDescriptor, readers);
        }
        return RepeatedReadSchemas.create(protoField, propertyDescriptor, readers);
    }

    static class BoolPrimitiveArray<T>
    extends FieldSchema<T> {
        private final Getter<T, boolean[]> getter;
        private final Setter<T, boolean[]> setter;
        private final AbstractPrimitiveReaders<boolean[], Boolean> readers;

        public BoolPrimitiveArray(Field protoField, PropertyDescriptor propertyDescriptor, AbstractPrimitiveReaders<boolean[], Boolean> readers) {
            super(protoField, propertyDescriptor.getJavaType());
            this.getter = (Getter)propertyDescriptor.getGetter();
            this.setter = (Setter)propertyDescriptor.getSetter();
            this.readers = readers;
        }

        @Override
        public int mergeFrom(InputEx input, T message) throws IOException {
            PrimitiveArrayBuilderWrapper builderWrapper = new PrimitiveArrayBuilderWrapper(input.getArrayBuilders().getBooleanBuilder());
            int fieldNumber = this.readers.primitiveArrayReader.read(input, builderWrapper);
            boolean[] newValue = (boolean[])builderWrapper.getArray();
            newValue = this.mergeArray((boolean[])this.getter.get(message), newValue);
            this.setter.set(message, (Object)newValue);
            return fieldNumber;
        }

        private boolean[] mergeArray(boolean[] oldValue, boolean[] newValue) {
            if (oldValue == null || oldValue.length == 0) {
                return newValue;
            }
            return this.concatArray(oldValue, newValue);
        }

        private boolean[] concatArray(boolean[] oldValue, boolean[] newValue) {
            int len1 = oldValue.length;
            int len2 = newValue.length;
            boolean[] result = Arrays.copyOf(oldValue, len1 + len2);
            System.arraycopy(newValue, 0, result, len1, len2);
            return result;
        }
    }
}

