/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.transaction;

import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.common.ServiceThread;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;

public class TransactionMetricsFlushService
extends ServiceThread {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqTransaction");
    private BrokerController brokerController;

    public TransactionMetricsFlushService(BrokerController brokerController) {
        this.brokerController = brokerController;
    }

    public String getServiceName() {
        return "TransactionFlushService";
    }

    public void run() {
        log.info(this.getServiceName() + " service start");
        long start = System.currentTimeMillis();
        while (!this.isStopped()) {
            try {
                if (System.currentTimeMillis() - start <= this.brokerController.getBrokerConfig().getTransactionMetricFlushInterval()) continue;
                start = System.currentTimeMillis();
                this.brokerController.getTransactionalMessageService().getTransactionMetrics().persist();
                this.waitForRunning(this.brokerController.getBrokerConfig().getTransactionMetricFlushInterval());
            }
            catch (Throwable e) {
                log.error("Error occurred in " + this.getServiceName(), e);
            }
        }
        log.info(this.getServiceName() + " service end");
    }
}

