/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tools.command.broker;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.exception.RemotingConnectException;
import org.apache.rocketmq.remoting.exception.RemotingSendRequestException;
import org.apache.rocketmq.remoting.exception.RemotingTimeoutException;
import org.apache.rocketmq.tools.admin.DefaultMQAdminExt;
import org.apache.rocketmq.tools.admin.MQAdminExt;
import org.apache.rocketmq.tools.command.CommandUtil;
import org.apache.rocketmq.tools.command.SubCommand;
import org.apache.rocketmq.tools.command.SubCommandException;

public class GetColdDataFlowCtrInfoSubCommand
implements SubCommand {
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @Override
    public String commandName() {
        return "getColdDataFlowCtrInfo";
    }

    @Override
    public String commandDesc() {
        return "Get cold data flow ctr info.";
    }

    @Override
    public Options buildCommandlineOptions(Options options) {
        Option opt = new Option("b", "brokerAddr", true, "get from which broker");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("c", "clusterName", true, "get from which cluster");
        opt.setRequired(false);
        options.addOption(opt);
        return options;
    }

    @Override
    public void execute(CommandLine commandLine, Options options, RPCHook rpcHook) throws SubCommandException {
        DefaultMQAdminExt defaultMQAdminExt = new DefaultMQAdminExt(rpcHook);
        defaultMQAdminExt.setInstanceName(Long.toString(System.currentTimeMillis()));
        try {
            if (commandLine.hasOption('b')) {
                String brokerAddr = commandLine.getOptionValue('b').trim();
                defaultMQAdminExt.start();
                this.getAndPrint(defaultMQAdminExt, String.format("============%s============\n", brokerAddr), brokerAddr);
            } else if (commandLine.hasOption('c')) {
                String clusterName = commandLine.getOptionValue('c').trim();
                defaultMQAdminExt.start();
                Map<String, List<String>> masterAndSlaveMap = CommandUtil.fetchMasterAndSlaveDistinguish(defaultMQAdminExt, clusterName);
                for (String masterAddr : masterAndSlaveMap.keySet()) {
                    this.getAndPrint(defaultMQAdminExt, String.format("============Master: %s============\n", masterAddr), masterAddr);
                    for (String slaveAddr : masterAndSlaveMap.get(masterAddr)) {
                        this.getAndPrint(defaultMQAdminExt, String.format("============My Master: %s=====Slave: %s============\n", masterAddr, slaveAddr), slaveAddr);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new SubCommandException(this.getClass().getSimpleName() + " command failed", e);
        }
        finally {
            defaultMQAdminExt.shutdown();
        }
    }

    protected void getAndPrint(MQAdminExt defaultMQAdminExt, String printPrefix, String addr) throws InterruptedException, RemotingConnectException, UnsupportedEncodingException, RemotingTimeoutException, MQBrokerException, RemotingSendRequestException {
        System.out.print(" " + printPrefix);
        String rstStr = defaultMQAdminExt.getColdDataFlowCtrInfo(addr);
        if (rstStr == null) {
            System.out.printf("Broker[%s] has no cold ctr table !\n", addr);
            return;
        }
        JSONObject jsonObject = JSON.parseObject((String)rstStr);
        Map runtimeTable = (Map)jsonObject.get("runtimeTable");
        runtimeTable.entrySet().stream().forEach(i -> {
            JSONObject value = (JSONObject)i.getValue();
            Date lastColdReadTimeMillsDate = new Date(Long.parseLong(String.valueOf(value.get("lastColdReadTimeMills"))));
            value.put((Object)"lastColdReadTimeFormat", (Object)this.sdf.format(lastColdReadTimeMillsDate));
            value.remove((Object)"lastColdReadTimeMills");
            Date createTimeMillsDate = new Date(Long.parseLong(String.valueOf(value.get("createTimeMills"))));
            value.put((Object)"createTimeFormat", (Object)this.sdf.format(createTimeMillsDate));
            value.remove((Object)"createTimeMills");
        });
        String formatStr = JSON.toJSONString((Object)jsonObject, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.PrettyFormat});
        System.out.printf(formatStr, new Object[0]);
        System.out.printf("%n", new Object[0]);
    }
}

