/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.queue;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.rocketmq.common.BoundaryType;
import org.apache.rocketmq.common.Pair;
import org.apache.rocketmq.common.attribute.CQType;
import org.apache.rocketmq.common.message.MessageExtBrokerInner;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.store.DispatchRequest;
import org.apache.rocketmq.store.MessageFilter;
import org.apache.rocketmq.store.config.MessageStoreConfig;
import org.apache.rocketmq.store.queue.ConsumeQueueInterface;
import org.apache.rocketmq.store.queue.CqUnit;
import org.apache.rocketmq.store.queue.QueueOffsetOperator;
import org.apache.rocketmq.store.queue.ReferredIterator;
import org.apache.rocketmq.store.queue.RocksDBConsumeQueueStore;
import org.rocksdb.RocksDBException;

public class RocksDBConsumeQueue
implements ConsumeQueueInterface {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqStore");
    private static final Logger ERROR_LOG = LoggerFactory.getLogger((String)"RocketmqStoreError");
    private final MessageStoreConfig messageStoreConfig;
    private final RocksDBConsumeQueueStore consumeQueueStore;
    private final String topic;
    private final int queueId;

    public RocksDBConsumeQueue(MessageStoreConfig messageStoreConfig, RocksDBConsumeQueueStore consumeQueueStore, String topic, int queueId) {
        this.messageStoreConfig = messageStoreConfig;
        this.consumeQueueStore = consumeQueueStore;
        this.topic = topic;
        this.queueId = queueId;
    }

    public RocksDBConsumeQueue(String topic, int queueId) {
        this(null, null, topic, queueId);
    }

    @Override
    public boolean load() {
        return true;
    }

    @Override
    public void recover() {
    }

    @Override
    public void checkSelf() {
    }

    @Override
    public boolean flush(int flushLeastPages) {
        return true;
    }

    @Override
    public void destroy() {
    }

    @Override
    public void truncateDirtyLogicFiles(long maxCommitLogPos) {
    }

    @Override
    public int deleteExpiredFile(long minCommitLogPos) {
        return 0;
    }

    @Override
    public long rollNextFile(long nextBeginOffset) {
        return 0L;
    }

    @Override
    public boolean isFirstFileAvailable() {
        return true;
    }

    @Override
    public boolean isFirstFileExist() {
        return true;
    }

    @Override
    public void swapMap(int reserveNum, long forceSwapIntervalMs, long normalSwapIntervalMs) {
    }

    @Override
    public void cleanSwappedMap(long forceCleanSwapIntervalMs) {
    }

    @Override
    public long getMaxOffsetInQueue() {
        try {
            return this.consumeQueueStore.getMaxOffsetInQueue(this.topic, this.queueId);
        }
        catch (RocksDBException e) {
            ERROR_LOG.error("getMaxOffsetInQueue Failed. topic: {}, queueId: {}", new Object[]{this.topic, this.queueId, e});
            return 0L;
        }
    }

    @Override
    public long getMessageTotalInQueue() {
        try {
            long maxOffsetInQueue = this.consumeQueueStore.getMaxOffsetInQueue(this.topic, this.queueId);
            long minOffsetInQueue = this.consumeQueueStore.getMinOffsetInQueue(this.topic, this.queueId);
            return maxOffsetInQueue - minOffsetInQueue;
        }
        catch (RocksDBException e) {
            ERROR_LOG.error("getMessageTotalInQueue Failed. topic: {}, queueId: {}, {}", new Object[]{this.topic, this.queueId, e});
            return -1L;
        }
    }

    @Override
    public long getOffsetInQueueByTime(long timestamp) {
        return 0L;
    }

    @Override
    public long getOffsetInQueueByTime(long timestamp, BoundaryType boundaryType) {
        return 0L;
    }

    @Override
    public long getMaxPhysicOffset() {
        Long maxPhyOffset = this.consumeQueueStore.getMaxPhyOffsetInConsumeQueue(this.topic, this.queueId);
        return maxPhyOffset == null ? -1L : maxPhyOffset;
    }

    @Override
    public long getMinLogicOffset() {
        return 0L;
    }

    @Override
    public CQType getCQType() {
        return CQType.RocksDBCQ;
    }

    @Override
    public long getTotalSize() {
        return 0L;
    }

    @Override
    public int getUnitSize() {
        return 20;
    }

    @Override
    public void correctMinOffset(long minCommitLogOffset) {
    }

    @Override
    public void putMessagePositionInfoWrapper(DispatchRequest request) {
    }

    @Override
    public void assignQueueOffset(QueueOffsetOperator queueOffsetOperator, MessageExtBrokerInner msg) throws RocksDBException {
        String topicQueueKey = this.getTopic() + "-" + this.getQueueId();
        Long queueOffset = queueOffsetOperator.getTopicQueueNextOffset(topicQueueKey);
        if (queueOffset == null) {
            queueOffset = this.consumeQueueStore.getMaxOffsetInQueue(this.topic, this.queueId);
            queueOffsetOperator.updateQueueOffset(topicQueueKey, queueOffset);
        }
        msg.setQueueOffset(queueOffset.longValue());
    }

    @Override
    public void increaseQueueOffset(QueueOffsetOperator queueOffsetOperator, MessageExtBrokerInner msg, short messageNum) {
        String topicQueueKey = this.getTopic() + "-" + this.getQueueId();
        queueOffsetOperator.increaseQueueOffset(topicQueueKey, messageNum);
    }

    @Override
    public long estimateMessageCount(long from, long to, MessageFilter filter) {
        int maxSampleSize;
        Pair<CqUnit, Long> fromUnit = this.getCqUnitAndStoreTime(from);
        if (fromUnit == null) {
            return -1L;
        }
        if (from >= to) {
            return -1L;
        }
        if (to > this.getMaxOffsetInQueue()) {
            to = this.getMaxOffsetInQueue();
        }
        int sampleSize = to - from > (long)(maxSampleSize = this.messageStoreConfig.getMaxConsumeQueueScan()) ? maxSampleSize : (int)(to - from);
        int matchThreshold = this.messageStoreConfig.getSampleCountThreshold();
        int matchSize = 0;
        for (int i = 0; i < sampleSize; ++i) {
            CqUnit cqUnit;
            long index = from + (long)i;
            Pair<CqUnit, Long> pair = this.getCqUnitAndStoreTime(index);
            if (pair == null || !filter.isMatchedByConsumeQueue((cqUnit = (CqUnit)pair.getObject1()).getTagsCode(), cqUnit.getCqExtUnit()) || ++matchSize <= matchThreshold) continue;
            sampleSize = i;
            break;
        }
        return sampleSize == 0 ? 0L : (long)((double)(to - from) * ((double)matchSize / ((double)sampleSize * 1.0)));
    }

    @Override
    public long getMinOffsetInQueue() {
        try {
            return this.consumeQueueStore.getMinOffsetInQueue(this.topic, this.queueId);
        }
        catch (RocksDBException e) {
            ERROR_LOG.error("getMinOffsetInQueue Failed. topic: {}, queueId: {}", new Object[]{this.topic, this.queueId, e});
            return -1L;
        }
    }

    private int pullNum(long cqOffset, long maxCqOffset) {
        long diffLong = maxCqOffset - cqOffset;
        if (diffLong < Integer.MAX_VALUE) {
            return (int)diffLong;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public ReferredIterator<CqUnit> iterateFrom(long startIndex) {
        long maxCqOffset = this.getMaxOffsetInQueue();
        if (startIndex < maxCqOffset && startIndex >= 0L) {
            int num = this.pullNum(startIndex, maxCqOffset);
            return new LargeRocksDBConsumeQueueIterator(startIndex, num);
        }
        return null;
    }

    @Override
    public ReferredIterator<CqUnit> iterateFrom(long startIndex, int count) throws RocksDBException {
        long maxCqOffset = this.getMaxOffsetInQueue();
        if (startIndex < maxCqOffset) {
            int num = Math.min((int)(maxCqOffset - startIndex), count);
            return this.iterateFrom0(startIndex, num);
        }
        return null;
    }

    @Override
    public CqUnit get(long index) {
        Pair<CqUnit, Long> pair = this.getCqUnitAndStoreTime(index);
        return pair == null ? null : (CqUnit)pair.getObject1();
    }

    @Override
    public Pair<CqUnit, Long> getCqUnitAndStoreTime(long index) {
        ByteBuffer byteBuffer;
        try {
            byteBuffer = this.consumeQueueStore.get(this.topic, this.queueId, index);
        }
        catch (RocksDBException e) {
            ERROR_LOG.error("getUnitAndStoreTime Failed. topic: {}, queueId: {}", new Object[]{this.topic, this.queueId, e});
            return null;
        }
        if (byteBuffer == null || byteBuffer.remaining() < 28) {
            return null;
        }
        long phyOffset = byteBuffer.getLong();
        int size = byteBuffer.getInt();
        long tagCode = byteBuffer.getLong();
        long messageStoreTime = byteBuffer.getLong();
        return new Pair((Object)new CqUnit(index, phyOffset, size, tagCode), (Object)messageStoreTime);
    }

    @Override
    public Pair<CqUnit, Long> getEarliestUnitAndStoreTime() {
        try {
            long minOffset = this.consumeQueueStore.getMinOffsetInQueue(this.topic, this.queueId);
            return this.getCqUnitAndStoreTime(minOffset);
        }
        catch (RocksDBException e) {
            ERROR_LOG.error("getEarliestUnitAndStoreTime Failed. topic: {}, queueId: {}", new Object[]{this.topic, this.queueId, e});
            return null;
        }
    }

    @Override
    public CqUnit getEarliestUnit() {
        Pair<CqUnit, Long> pair = this.getEarliestUnitAndStoreTime();
        return pair == null ? null : (CqUnit)pair.getObject1();
    }

    @Override
    public CqUnit getLatestUnit() {
        try {
            long maxOffset = this.consumeQueueStore.getMaxOffsetInQueue(this.topic, this.queueId);
            return this.get(maxOffset > 0L ? maxOffset - 1L : maxOffset);
        }
        catch (RocksDBException e) {
            ERROR_LOG.error("getLatestUnit Failed. topic: {}, queueId: {}, {}", new Object[]{this.topic, this.queueId, e.getMessage()});
            return null;
        }
    }

    @Override
    public long getLastOffset() {
        return this.getMaxPhysicOffset();
    }

    private ReferredIterator<CqUnit> iterateFrom0(long startIndex, int count) throws RocksDBException {
        List<ByteBuffer> byteBufferList = this.consumeQueueStore.rangeQuery(this.topic, this.queueId, startIndex, count);
        if (byteBufferList == null || byteBufferList.isEmpty()) {
            if (this.messageStoreConfig.isEnableRocksDBLog()) {
                log.warn("iterateFrom0 - find nothing, startIndex:{}, count:{}", (Object)startIndex, (Object)count);
            }
            return null;
        }
        return new RocksDBConsumeQueueIterator(byteBufferList, startIndex);
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public int getQueueId() {
        return this.queueId;
    }

    @Override
    public void initializeWithOffset(long offset, long minPhyOffset) {
        log.info("RocksDBConsumeQueue initializeWithOffset topic={}, queueId={}, offset={}, oldMax={}, oldMin={}", new Object[]{this.topic, this.queueId, offset, this.getMaxOffsetInQueue(), this.getMinOffsetInQueue()});
        try {
            this.consumeQueueStore.cleanExpired(minPhyOffset);
            this.consumeQueueStore.updateCqOffset(this.topic, this.queueId, 0L, offset - 1L, true);
            this.consumeQueueStore.updateCqOffset(this.topic, this.queueId, 0L, offset, false);
        }
        catch (RocksDBException e) {
            ERROR_LOG.error("RocksDBConsumeQueue initializeWithOffset Failed. topic={}, queueId={}, offset={}", new Object[]{this.topic, this.queueId, offset, e});
        }
    }

    private class LargeRocksDBConsumeQueueIterator
    implements ReferredIterator<CqUnit> {
        private final long startIndex;
        private final int totalCount;
        private int currentIndex;

        public LargeRocksDBConsumeQueueIterator(long startIndex, int num) {
            this.startIndex = startIndex;
            this.totalCount = num;
            this.currentIndex = 0;
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex < this.totalCount;
        }

        @Override
        public CqUnit next() {
            ByteBuffer byteBuffer;
            if (!this.hasNext()) {
                return null;
            }
            try {
                byteBuffer = RocksDBConsumeQueue.this.consumeQueueStore.get(RocksDBConsumeQueue.this.topic, RocksDBConsumeQueue.this.queueId, this.startIndex + (long)this.currentIndex);
            }
            catch (RocksDBException e) {
                ERROR_LOG.error("get cq from rocksdb failed. topic: {}, queueId: {}", new Object[]{RocksDBConsumeQueue.this.topic, RocksDBConsumeQueue.this.queueId, e});
                return null;
            }
            if (byteBuffer == null || byteBuffer.remaining() < 28) {
                return null;
            }
            CqUnit cqUnit = new CqUnit(this.startIndex + (long)this.currentIndex, byteBuffer.getLong(), byteBuffer.getInt(), byteBuffer.getLong());
            ++this.currentIndex;
            return cqUnit;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        public void release() {
        }

        @Override
        public CqUnit nextAndRelease() {
            try {
                CqUnit cqUnit = this.next();
                return cqUnit;
            }
            finally {
                this.release();
            }
        }
    }

    private class RocksDBConsumeQueueIterator
    implements ReferredIterator<CqUnit> {
        private final List<ByteBuffer> byteBufferList;
        private final long startIndex;
        private final int totalCount;
        private int currentIndex;

        public RocksDBConsumeQueueIterator(List<ByteBuffer> byteBufferList, long startIndex) {
            this.byteBufferList = byteBufferList;
            this.startIndex = startIndex;
            this.totalCount = byteBufferList.size();
            this.currentIndex = 0;
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex < this.totalCount;
        }

        @Override
        public CqUnit next() {
            if (!this.hasNext()) {
                return null;
            }
            int currentIndex = this.currentIndex++;
            ByteBuffer byteBuffer = this.byteBufferList.get(currentIndex);
            CqUnit cqUnit = new CqUnit(this.startIndex + (long)currentIndex, byteBuffer.getLong(), byteBuffer.getInt(), byteBuffer.getLong());
            return cqUnit;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        public void release() {
        }

        @Override
        public CqUnit nextAndRelease() {
            try {
                CqUnit cqUnit = this.next();
                return cqUnit;
            }
            finally {
                this.release();
            }
        }
    }
}

