/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.ratis.util.Daemon;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.LogUtils;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.TimeoutExecutor;
import org.apache.ratis.util.function.CheckedRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TimeoutScheduler
implements TimeoutExecutor {
    public static final Logger LOG = LoggerFactory.getLogger(TimeoutScheduler.class);
    static final TimeDuration DEFAULT_GRACE_PERIOD = TimeDuration.valueOf(1L, TimeUnit.MINUTES);
    private static final Supplier<TimeoutScheduler> INSTANCE = JavaUtils.memoize(TimeoutScheduler::new);
    private static final AtomicInteger THREAD_COUNT = new AtomicInteger(0);
    private final AtomicReference<TimeDuration> gracePeriod = new AtomicReference<TimeDuration>(DEFAULT_GRACE_PERIOD);
    private int numTasks = 0;
    private int scheduleID = 0;
    private ShutdownTask shutdownTask = null;
    private final Scheduler scheduler = new Scheduler();

    public static TimeoutScheduler getInstance() {
        return INSTANCE.get();
    }

    static TimeoutScheduler newInstance() {
        return new TimeoutScheduler();
    }

    private TimeoutScheduler() {
    }

    @Override
    public int getTaskCount() {
        return this.scheduler.getQueueSize();
    }

    TimeDuration getGracePeriod() {
        return this.gracePeriod.get();
    }

    void setGracePeriod(TimeDuration gracePeriod) {
        this.gracePeriod.set(gracePeriod);
    }

    boolean hasScheduler() {
        return this.scheduler.hasExecutor();
    }

    @Override
    public <THROWABLE extends Throwable> void onTimeout(TimeDuration timeout, CheckedRunnable<THROWABLE> task, Consumer<THROWABLE> errorHandler) {
        this.onTimeout(timeout, sid -> {
            LOG.debug("run a task: sid {}", sid);
            try {
                task.run();
            }
            catch (Throwable t2) {
                errorHandler.accept(JavaUtils.cast(t2));
            }
            finally {
                this.onTaskCompleted();
            }
        });
    }

    private synchronized void onTimeout(TimeDuration timeout, Consumer<Integer> toSchedule) {
        ++this.numTasks;
        int sid = this.scheduleID++;
        LOG.debug("schedule a task: timeout {}, sid {}", (Object)timeout, (Object)sid);
        this.scheduler.schedule(() -> toSchedule.accept(sid), () -> "task #" + sid, timeout);
    }

    private synchronized void onTaskCompleted() {
        if (--this.numTasks > 0) {
            return;
        }
        int sid = this.scheduleID;
        if (this.shutdownTask != null) {
            if (this.shutdownTask.getSid() == sid) {
                return;
            }
            this.shutdownTask.cancel();
        }
        TimeDuration grace = this.getGracePeriod();
        LOG.debug("Schedule a shutdown task: grace {}, sid {}", (Object)grace, (Object)sid);
        ScheduledFuture<?> future = this.scheduler.schedule(() -> this.tryShutdownScheduler(sid), () -> "shutdown task #" + sid, grace);
        this.shutdownTask = new ShutdownTask(sid, future);
    }

    private synchronized void tryShutdownScheduler(int sid) {
        if (sid == this.scheduleID) {
            LOG.debug("shutdown scheduler: sid {}", (Object)sid);
            this.scheduler.shutdown();
        } else {
            LOG.debug("shutdown cancelled: scheduleID has changed from {} to {}", (Object)sid, (Object)this.scheduleID);
        }
    }

    public synchronized void tryShutdownScheduler() {
        this.tryShutdownScheduler(this.scheduleID);
    }

    private static class Scheduler {
        private final AtomicReference<ScheduledThreadPoolExecutor> executor = new AtomicReference();

        private Scheduler() {
        }

        boolean hasExecutor() {
            return this.executor.get() != null;
        }

        int getQueueSize() {
            return Optional.ofNullable(this.executor.get()).map(ScheduledThreadPoolExecutor::getQueue).map(Collection::size).orElse(0);
        }

        ScheduledFuture<?> schedule(Runnable task, Supplier<String> name, TimeDuration time) {
            return this.executor.updateAndGet(e -> Optional.ofNullable(e).orElseGet(Scheduler::newExecutor)).schedule(LogUtils.newRunnable(LOG, task, name), time.getDuration(), time.getUnit());
        }

        private static ScheduledThreadPoolExecutor newExecutor() {
            LOG.debug("new ScheduledThreadPoolExecutor");
            ScheduledThreadPoolExecutor e = new ScheduledThreadPoolExecutor(1, runnable -> Daemon.newBuilder().setName("TimeoutScheduler-" + THREAD_COUNT.getAndIncrement()).setRunnable(runnable).build());
            e.setRemoveOnCancelPolicy(true);
            return e;
        }

        void shutdown() {
            Optional.ofNullable(this.executor.getAndSet(null)).ifPresent(ScheduledThreadPoolExecutor::shutdown);
        }
    }

    static class ShutdownTask {
        private final int sid;
        private final ScheduledFuture<?> future;

        ShutdownTask(int sid, ScheduledFuture<?> future) {
            this.sid = sid;
            this.future = future;
        }

        int getSid() {
            return this.sid;
        }

        void cancel() {
            this.future.cancel(false);
        }
    }
}

