/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.discovery;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.qpid.jms.provider.Provider;
import org.apache.qpid.jms.provider.ProviderFactory;
import org.apache.qpid.jms.provider.ProviderFutureFactory;
import org.apache.qpid.jms.provider.discovery.DiscoveryAgent;
import org.apache.qpid.jms.provider.discovery.DiscoveryAgentFactory;
import org.apache.qpid.jms.provider.discovery.DiscoveryProvider;
import org.apache.qpid.jms.provider.failover.FailoverProvider;
import org.apache.qpid.jms.util.PropertyUtil;
import org.apache.qpid.jms.util.URISupport;

public class DiscoveryProviderFactory
extends ProviderFactory {
    public static final String DISCOVERY_OPTION_PREFIX = "discovery.";
    public static final String DISCOVERY_DISCOVERED_OPTION_PREFIX_ADON = "discovered.";

    public Provider createProvider(URI remoteURI) throws Exception {
        return this.createProvider(remoteURI, null);
    }

    public Provider createProvider(URI remoteURI, ProviderFutureFactory futureFactory) throws Exception {
        Map leftOverDiscoveryOptions;
        FailoverProvider failover;
        DiscoveryProvider discovery;
        Map unusedOptions;
        URISupport.CompositeData composite = URISupport.parseComposite((URI)remoteURI);
        Map options = composite.getParameters();
        Map failoverOptions = PropertyUtil.filterProperties((Map)options, (String)"failover.");
        Map failoverNestedOptions = PropertyUtil.filterProperties((Map)failoverOptions, (String)"nested.");
        Map discoveryOptions = PropertyUtil.filterProperties((Map)options, (String)DISCOVERY_OPTION_PREFIX);
        Map discoveredOptions = PropertyUtil.filterProperties((Map)discoveryOptions, (String)DISCOVERY_DISCOVERED_OPTION_PREFIX_ADON);
        HashMap mainOptions = new HashMap();
        mainOptions.putAll(failoverOptions);
        mainOptions.putAll(discoveryOptions);
        HashMap nestedOptions = new HashMap();
        nestedOptions.putAll(failoverNestedOptions);
        nestedOptions.putAll(discoveredOptions);
        Map providerOptions = PropertyUtil.filterProperties((Map)options, (String)"provider.");
        if (futureFactory == null) {
            futureFactory = ProviderFutureFactory.create((Map)providerOptions);
            if (!providerOptions.isEmpty()) {
                String msg = " Not all Provider options could be applied during Failover Provider creation. Check the options are spelled correctly. Unused parameters=[" + String.valueOf(providerOptions) + "]. This provider instance cannot be started.";
                throw new IllegalArgumentException(msg);
            }
        }
        if (!(unusedOptions = PropertyUtil.setProperties((Object)(discovery = new DiscoveryProvider(remoteURI, failover = new FailoverProvider(Collections.emptyList(), nestedOptions, futureFactory))), (Map)(leftOverDiscoveryOptions = PropertyUtil.setProperties((Object)failover, mainOptions)))).isEmpty()) {
            String msg = " Not all options could be set on the Discovery provider. Check the options are spelled correctly. Unused parameters=[" + String.valueOf(unusedOptions) + "]. This Provider cannot be started.";
            throw new IllegalArgumentException(msg);
        }
        List agentURIs = composite.getComponents();
        ArrayList<DiscoveryAgent> discoveryAgents = new ArrayList<DiscoveryAgent>(agentURIs.size());
        for (URI agentURI : agentURIs) {
            discoveryAgents.add(DiscoveryAgentFactory.createAgent(agentURI));
        }
        discovery.setDiscoveryAgents(discoveryAgents);
        return discovery;
    }

    public String getName() {
        return "Discovery";
    }
}

