/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.vti;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import org.apache.derby.iapi.types.HarmonySerialBlob;
import org.apache.derby.iapi.types.HarmonySerialClob;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.util.ArrayUtil;
import org.apache.derby.vti.VTITemplate;

public abstract class StringColumnVTI
extends VTITemplate {
    private String[] _columnNames;
    private boolean _lastColumnWasNull;

    protected abstract String getRawColumn(int var1) throws SQLException;

    public StringColumnVTI(String[] stringArray) {
        if (stringArray != null) {
            this._columnNames = (String[])ArrayUtil.copy((Object[])stringArray);
        }
    }

    public void setColumnNames(String[] stringArray) throws SQLException {
        if (this._columnNames != null) {
            throw this.makeSQLException("X0Y92.S", new Object[0]);
        }
        this._columnNames = (String[])ArrayUtil.copy((Object[])stringArray);
    }

    public int getColumnCount() {
        return this._columnNames.length;
    }

    public String getColumnName(int n) {
        return this._columnNames[n - 1];
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this._lastColumnWasNull;
    }

    @Override
    public int findColumn(String string) throws SQLException {
        int n = this._columnNames.length;
        for (int i = 0; i < n; ++i) {
            if (!this._columnNames[i].equals(string)) continue;
            return i + 1;
        }
        throw new SQLException("Unknown column name.");
    }

    @Override
    public String getString(int n) throws SQLException {
        String string = this.getRawColumn(n);
        this.checkNull(string);
        return string;
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return false;
        }
        return Boolean.valueOf(string);
    }

    @Override
    public byte getByte(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return 0;
        }
        try {
            return Byte.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.wrap(numberFormatException);
        }
    }

    @Override
    public short getShort(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return 0;
        }
        try {
            return Short.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.wrap(numberFormatException);
        }
    }

    @Override
    public int getInt(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return 0;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.wrap(numberFormatException);
        }
    }

    @Override
    public long getLong(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return 0L;
        }
        try {
            return Long.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.wrap(numberFormatException);
        }
    }

    @Override
    public float getFloat(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.wrap(numberFormatException);
        }
    }

    @Override
    public double getDouble(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return 0.0;
        }
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.wrap(numberFormatException);
        }
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        try {
            return new BigDecimal(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.wrap(numberFormatException);
        }
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        try {
            return string.getBytes("UTF-8");
        }
        catch (Throwable throwable) {
            throw new SQLException(throwable.getMessage());
        }
    }

    @Override
    public Date getDate(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        return new Date(this.parseDateTime(string));
    }

    @Override
    public Time getTime(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        return new Time(this.parseDateTime(string));
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        return new Timestamp(this.parseDateTime(string));
    }

    @Override
    public InputStream getAsciiStream(int n) throws SQLException {
        String string = this.getString(n);
        return this.getEncodedStream(string, "US-ASCII");
    }

    @Override
    public InputStream getBinaryStream(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        return new ByteArrayInputStream(this.getBytes(n));
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        return new HarmonySerialBlob(this.getBytes(n));
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        return new HarmonySerialClob(this.getString(n));
    }

    private void checkNull(String string) {
        this._lastColumnWasNull = string == null;
    }

    private SQLException wrap(Throwable throwable) {
        return new SQLException(throwable.getMessage());
    }

    private long parseDateTime(String string) throws SQLException {
        try {
            DateFormat dateFormat = DateFormat.getDateTimeInstance();
            java.util.Date date = dateFormat.parse(string);
            return date.getTime();
        }
        catch (ParseException parseException) {
            throw this.wrap(parseException);
        }
    }

    private InputStream getEncodedStream(String string, String string2) throws SQLException {
        if (string == null) {
            return null;
        }
        try {
            byte[] byArray = string.getBytes(string2);
            return new ByteArrayInputStream(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw this.wrap(unsupportedEncodingException);
        }
    }

    private SQLException makeSQLException(String string, Object ... objectArray) {
        StandardException standardException = StandardException.newException((String)string, (Object[])objectArray);
        return new SQLException(standardException.getMessage(), standardException.getSQLState());
    }
}

