/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PermissionsDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.shared.common.error.StandardException;

public class TablePermsDescriptor
extends PermissionsDescriptor {
    private UUID tableUUID;
    private String tableName;
    private String selectPriv;
    private String deletePriv;
    private String insertPriv;
    private String updatePriv;
    private String referencesPriv;
    private String triggerPriv;

    public TablePermsDescriptor(DataDictionary dataDictionary, String string, String string2, UUID uUID, String string3, String string4, String string5, String string6, String string7, String string8) throws StandardException {
        super(dataDictionary, string, string2);
        this.tableUUID = uUID;
        this.selectPriv = string3;
        this.deletePriv = string4;
        this.insertPriv = string5;
        this.updatePriv = string6;
        this.referencesPriv = string7;
        this.triggerPriv = string8;
        if (uUID != null) {
            this.tableName = dataDictionary.getTableDescriptor(uUID).getName();
        }
    }

    public TablePermsDescriptor(DataDictionary dataDictionary, String string, String string2, UUID uUID) throws StandardException {
        this(dataDictionary, string, string2, uUID, null, null, null, null, null, null);
    }

    public TablePermsDescriptor(DataDictionary dataDictionary, UUID uUID) throws StandardException {
        this(dataDictionary, null, null, null, null, null, null, null, null, null);
        this.oid = uUID;
    }

    @Override
    public int getCatalogNumber() {
        return 16;
    }

    public UUID getTableUUID() {
        return this.tableUUID;
    }

    public String getSelectPriv() {
        return this.selectPriv;
    }

    public String getDeletePriv() {
        return this.deletePriv;
    }

    public String getInsertPriv() {
        return this.insertPriv;
    }

    public String getUpdatePriv() {
        return this.updatePriv;
    }

    public String getReferencesPriv() {
        return this.referencesPriv;
    }

    public String getTriggerPriv() {
        return this.triggerPriv;
    }

    public String toString() {
        return "tablePerms: grantee=" + this.getGrantee() + ",tablePermsUUID=" + this.getUUID() + ",grantor=" + this.getGrantor() + ",tableUUID=" + this.getTableUUID() + ",selectPriv=" + this.getSelectPriv() + ",deletePriv=" + this.getDeletePriv() + ",insertPriv=" + this.getInsertPriv() + ",updatePriv=" + this.getUpdatePriv() + ",referencesPriv=" + this.getReferencesPriv() + ",triggerPriv=" + this.getTriggerPriv();
    }

    public boolean equals(Object object) {
        if (!(object instanceof TablePermsDescriptor)) {
            return false;
        }
        TablePermsDescriptor tablePermsDescriptor = (TablePermsDescriptor)object;
        return super.keyEquals(tablePermsDescriptor) && this.tableUUID.equals(tablePermsDescriptor.tableUUID);
    }

    public int hashCode() {
        return super.keyHashCode() + this.tableUUID.hashCode();
    }

    @Override
    public boolean checkOwner(String string) throws StandardException {
        TableDescriptor tableDescriptor = this.getDataDictionary().getTableDescriptor(this.tableUUID);
        return tableDescriptor.getSchemaDescriptor().getAuthorizationId().equals(string);
    }

    @Override
    public String getObjectName() {
        return "Table Privilege on " + this.tableName;
    }

    @Override
    public String getClassType() {
        return "TablePrivilege";
    }

    @Override
    public DependableFinder getDependableFinder() {
        return this.getDependableFinder(462);
    }
}

