/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.util;

import com.sleepycat.je.EnvironmentLockedException;
import com.sleepycat.je.EnvironmentNotFoundException;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.DumpFileReader;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.log.LastFileReader;
import com.sleepycat.je.log.PrintFileReader;
import com.sleepycat.je.log.StatsFileReader;
import com.sleepycat.je.log.VLSNDistributionReader;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.utilint.CmdUtil;
import java.io.File;
import java.lang.reflect.Constructor;

public class DbPrintLog {
    public void dump(File envHome, String entryTypes, String txnIds, long startLsn, long endLsn, boolean verbose, boolean stats, boolean repEntriesOnly, boolean csvFormat, boolean forwards, boolean vlsnDistribution, String customDumpReaderClass) throws EnvironmentNotFoundException, EnvironmentLockedException {
        this.dump(envHome, entryTypes, "", txnIds, startLsn, endLsn, verbose, stats, repEntriesOnly, csvFormat, forwards, vlsnDistribution, customDumpReaderClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dump(File envHome, String entryTypes, String dbIds, String txnIds, long startLsn, long endLsn, boolean verbose, boolean stats, boolean repEntriesOnly, boolean csvFormat, boolean forwards, boolean vlsnDistribution, String customDumpReaderClass) {
        EnvironmentImpl env = CmdUtil.makeUtilityEnvironment(envHome, true);
        FileManager fileManager = env.getFileManager();
        fileManager.setIncludeDeletedFiles(true);
        int readBufferSize = env.getConfigManager().getInt(EnvironmentParams.LOG_ITERATOR_READ_SIZE);
        long endOfFileLsn = -1L;
        if (startLsn == -1L && endLsn == -1L && !forwards) {
            LastFileReader fileReader = new LastFileReader(env, readBufferSize);
            while (fileReader.readNextEntry()) {
            }
            startLsn = fileReader.getLastValidLsn();
            endOfFileLsn = fileReader.getEndOfLog();
        }
        try {
            DumpFileReader reader = null;
            reader = customDumpReaderClass != null ? this.getDebugReader(customDumpReaderClass, env, readBufferSize, startLsn, endLsn, endOfFileLsn, entryTypes, txnIds, verbose, repEntriesOnly, forwards) : (stats ? new StatsFileReader(env, readBufferSize, startLsn, endLsn, endOfFileLsn, entryTypes, dbIds, txnIds, verbose, repEntriesOnly, forwards) : (vlsnDistribution ? new VLSNDistributionReader(env, readBufferSize, startLsn, endLsn, endOfFileLsn, verbose, forwards) : new PrintFileReader(env, readBufferSize, startLsn, endLsn, endOfFileLsn, entryTypes, dbIds, txnIds, verbose, repEntriesOnly, forwards)));
            if (!csvFormat) {
                System.out.println("<DbPrintLog>");
            }
            while (reader.readNextEntry()) {
            }
            reader.summarize(csvFormat);
            if (!csvFormat) {
                System.out.println("</DbPrintLog>");
            }
        }
        finally {
            env.close();
        }
    }

    public static void main(String[] argv) {
        try {
            String entryTypes = null;
            String dbIds = null;
            String txnIds = null;
            long startLsn = -1L;
            long endLsn = -1L;
            boolean verbose = true;
            boolean stats = false;
            boolean csvFormat = false;
            boolean repEntriesOnly = false;
            boolean forwards = true;
            String customDumpReaderClass = null;
            boolean vlsnDistribution = false;
            File envHome = new File(".");
            Key.DUMP_TYPE = Key.DumpType.BINARY;
            for (int whichArg = 0; whichArg < argv.length; ++whichArg) {
                String nextArg = argv[whichArg];
                if (nextArg.equals("-h")) {
                    envHome = new File(CmdUtil.getArg(argv, ++whichArg));
                    continue;
                }
                if (nextArg.equals("-ty")) {
                    entryTypes = CmdUtil.getArg(argv, ++whichArg);
                    continue;
                }
                if (nextArg.equals("-db")) {
                    dbIds = CmdUtil.getArg(argv, ++whichArg);
                    continue;
                }
                if (nextArg.equals("-tx")) {
                    txnIds = CmdUtil.getArg(argv, ++whichArg);
                    continue;
                }
                if (nextArg.equals("-s")) {
                    startLsn = CmdUtil.readLsn(CmdUtil.getArg(argv, ++whichArg));
                    continue;
                }
                if (nextArg.equals("-e")) {
                    endLsn = CmdUtil.readLsn(CmdUtil.getArg(argv, ++whichArg));
                    continue;
                }
                if (nextArg.equals("-k")) {
                    String dumpType;
                    if ((dumpType = CmdUtil.getArg(argv, ++whichArg)).equalsIgnoreCase("text")) {
                        Key.DUMP_TYPE = Key.DumpType.TEXT;
                        continue;
                    }
                    if (dumpType.equalsIgnoreCase("hex")) {
                        Key.DUMP_TYPE = Key.DumpType.HEX;
                        continue;
                    }
                    if (dumpType.equalsIgnoreCase("binary")) {
                        Key.DUMP_TYPE = Key.DumpType.BINARY;
                        continue;
                    }
                    if (dumpType.equalsIgnoreCase("obfuscate")) {
                        Key.DUMP_TYPE = Key.DumpType.OBFUSCATE;
                        continue;
                    }
                    System.err.println(dumpType + " is not a supported dump format type.");
                    continue;
                }
                if (nextArg.equals("-q")) {
                    verbose = false;
                    continue;
                }
                if (nextArg.equals("-b")) {
                    forwards = false;
                    continue;
                }
                if (nextArg.equals("-S")) {
                    stats = true;
                    continue;
                }
                if (nextArg.equals("-SC")) {
                    stats = true;
                    csvFormat = true;
                    continue;
                }
                if (nextArg.equals("-r")) {
                    repEntriesOnly = true;
                    continue;
                }
                if (nextArg.equals("-c")) {
                    customDumpReaderClass = CmdUtil.getArg(argv, ++whichArg);
                    continue;
                }
                if (nextArg.equals("-vd")) {
                    vlsnDistribution = true;
                    continue;
                }
                System.err.println(nextArg + " is not a supported option.");
                DbPrintLog.usage();
                System.exit(-1);
            }
            if (!(startLsn == -1L && endLsn == -1L || forwards)) {
                throw new UnsupportedOperationException("Backwards scans are not supported when -s or -e are used. They can only be used against the entire log.");
            }
            DbPrintLog printer = new DbPrintLog();
            printer.dump(envHome, entryTypes, dbIds, txnIds, startLsn, endLsn, verbose, stats, repEntriesOnly, csvFormat, forwards, vlsnDistribution, customDumpReaderClass);
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
            DbPrintLog.usage();
            System.exit(1);
        }
    }

    private static void usage() {
        System.out.println("Usage: " + CmdUtil.getJavaCommand(DbPrintLog.class));
        System.out.println(" -h  <envHomeDir>");
        System.out.println(" -s  <start file number or LSN, in hex>");
        System.out.println(" -e  <end file number or LSN, in hex>");
        System.out.println(" -k  <binary|text|hex|obfuscate> (format for dumping the key and data)");
        System.out.println(" -db <targeted db ids, comma separated>");
        System.out.println(" -tx <targeted txn ids, comma separated>");
        System.out.println(" -ty <targeted entry types, comma separated>");
        System.out.println(" -S  show Summary of log entries");
        System.out.println(" -SC show Summary of log entries in CSV format");
        System.out.println(" -r  only print replicated log entries");
        System.out.println(" -b  scan all the log files backwards, don't ");
        System.out.println("     support scan between two log files");
        System.out.println(" -q  if specified, concise version is printed");
        System.out.println("     Default is verbose version.)");
        System.out.println(" -c  <custom dump reader class> if specified, ");
        System.out.println("     attempt to load this class to use for the ");
        System.out.println("     formatting of dumped log entries");
        System.out.println("All arguments are optional");
    }

    private DumpFileReader getDebugReader(String customDumpReaderClass, EnvironmentImpl env, int readBufferSize, long startLsn, long finishLsn, long endOfFileLsn, String entryTypes, String txnIds, boolean verbose, boolean repEntriesOnly, boolean forwards) {
        Class<?> debugClass = null;
        try {
            debugClass = Class.forName(customDumpReaderClass);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("-c was specified, but couldn't load " + customDumpReaderClass + " ", e);
        }
        Class[] args = new Class[]{EnvironmentImpl.class, Integer.class, Long.class, Long.class, Long.class, String.class, String.class, Boolean.class, Boolean.class, Boolean.class};
        DumpFileReader debugReader = null;
        try {
            Constructor<?> con = debugClass.getConstructor(args);
            debugReader = (DumpFileReader)con.newInstance(env, readBufferSize, startLsn, finishLsn, endOfFileLsn, entryTypes, txnIds, verbose, repEntriesOnly, forwards);
        }
        catch (Exception e) {
            throw new IllegalStateException("-c was specified, but couldn't instantiate " + customDumpReaderClass + " ", e);
        }
        return debugReader;
    }
}

