/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.qpid.server.store.jdbc;

import org.apache.qpid.server.model.KeyStore;
import org.apache.qpid.server.model.TrustStore;
import org.apache.qpid.server.store.Settings;

public interface JDBCSettings extends Settings
{
    String CONNECTION_URL = "connectionUrl";
    String CONNECTION_POOL_TYPE = "connectionPoolType";
    String USERNAME = "username";
    String PASSWORD = "password";
    String TABLE_NAME_PREFIX = "tableNamePrefix";

    String getConnectionUrl();

    String getConnectionPoolType();

    String getUsername();

    String getPassword();

    String getTableNamePrefix();

    KeyStore<?> getKeyStore();

    String getKeyStorePathPropertyName();

    String getKeyStorePasswordPropertyName();

    TrustStore<?> getTrustStore();

    String getTrustStorePathPropertyName();

    String getTrustStorePasswordPropertyName();
}
