/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.message.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.message.internal.InternalMessageHeader;
import org.apache.qpid.server.message.internal.InternalMessageMetaDataType;
import org.apache.qpid.server.store.StorableMessageMetaData;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;

public class InternalMessageMetaData
implements StorableMessageMetaData {
    private final boolean _isPersistent;
    private final InternalMessageHeader _header;
    private final int _contentSize;
    private volatile byte[] _headerBytes;

    public InternalMessageMetaData(boolean isPersistent, InternalMessageHeader header, int contentSize) {
        this._isPersistent = isPersistent;
        this._header = header;
        this._contentSize = contentSize;
    }

    @Override
    public InternalMessageMetaDataType getType() {
        return InternalMessageMetaDataType.INSTANCE;
    }

    @Override
    public int getStorableSize() {
        this.ensureHeaderIsEncoded();
        return this._headerBytes.length;
    }

    @Override
    public void writeToBuffer(QpidByteBuffer dest) {
        this.ensureHeaderIsEncoded();
        dest.put(this._headerBytes);
    }

    @Override
    public int getContentSize() {
        return this._contentSize;
    }

    @Override
    public boolean isPersistent() {
        return this._isPersistent;
    }

    @Override
    public void dispose() {
    }

    InternalMessageHeader getHeader() {
        return this._header;
    }

    @Override
    public void clearEncodedForm() {
    }

    @Override
    public void reallocate() {
    }

    static InternalMessageMetaData create(boolean persistent, InternalMessageHeader header, int contentSize) {
        return new InternalMessageMetaData(persistent, header, contentSize);
    }

    private void ensureHeaderIsEncoded() {
        if (this._headerBytes == null) {
            try (ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
                 ObjectOutputStream os = new ObjectOutputStream(bytesOut);){
                os.writeInt(this._contentSize);
                os.writeObject(this._header);
                os.close();
                this._headerBytes = bytesOut.toByteArray();
            }
            catch (IOException e) {
                throw new ConnectionScopedRuntimeException("Unexpected IO Exception on in memory operation", e);
            }
        }
    }
}

