/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1PortStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="LoadBalancerIngress represents the status of a load-balancer ingress point: traffic intended for the service should be sent to an ingress point.")
public class V1LoadBalancerIngress {
    public static final String SERIALIZED_NAME_HOSTNAME = "hostname";
    @SerializedName(value="hostname")
    private String hostname;
    public static final String SERIALIZED_NAME_IP = "ip";
    @SerializedName(value="ip")
    private String ip;
    public static final String SERIALIZED_NAME_PORTS = "ports";
    @SerializedName(value="ports")
    private List<V1PortStatus> ports = null;

    public V1LoadBalancerIngress hostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Hostname is set for load-balancer ingress points that are DNS based (typically AWS load-balancers)")
    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public V1LoadBalancerIngress ip(String ip) {
        this.ip = ip;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="IP is set for load-balancer ingress points that are IP based (typically GCE or OpenStack load-balancers)")
    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public V1LoadBalancerIngress ports(List<V1PortStatus> ports) {
        this.ports = ports;
        return this;
    }

    public V1LoadBalancerIngress addPortsItem(V1PortStatus portsItem) {
        if (this.ports == null) {
            this.ports = new ArrayList<V1PortStatus>();
        }
        this.ports.add(portsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Ports is a list of records of service ports If used, every port defined in the service should have an entry in it")
    public List<V1PortStatus> getPorts() {
        return this.ports;
    }

    public void setPorts(List<V1PortStatus> ports) {
        this.ports = ports;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1LoadBalancerIngress v1LoadBalancerIngress = (V1LoadBalancerIngress)o;
        return Objects.equals(this.hostname, v1LoadBalancerIngress.hostname) && Objects.equals(this.ip, v1LoadBalancerIngress.ip) && Objects.equals(this.ports, v1LoadBalancerIngress.ports);
    }

    public int hashCode() {
        return Objects.hash(this.hostname, this.ip, this.ports);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1LoadBalancerIngress {\n");
        sb.append("    hostname: ").append(this.toIndentedString(this.hostname)).append("\n");
        sb.append("    ip: ").append(this.toIndentedString(this.ip)).append("\n");
        sb.append("    ports: ").append(this.toIndentedString(this.ports)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

