/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.naming;

import java.util.Map;

public class Metadata {
    private Metadata() {
    }

    public static void validateMetadata(Map<String, String> metadata, int maxConsumerMetadataSize) throws IllegalArgumentException {
        if (metadata == null) {
            return;
        }
        int size = 0;
        for (Map.Entry<String, String> e : metadata.entrySet()) {
            if ((size += e.getKey().length() + e.getValue().length()) <= maxConsumerMetadataSize) continue;
            throw new IllegalArgumentException(Metadata.getErrorMessage(maxConsumerMetadataSize));
        }
    }

    private static String getErrorMessage(int maxConsumerMetadataSize) {
        return "metadata has a max size of " + maxConsumerMetadataSize + " bytes";
    }
}

