/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.injector;

import java.util.Random;
import org.apache.distributedlog.injector.AsyncFailureInjector;
import org.apache.distributedlog.util.Utils;

public class AsyncRandomFailureInjector
implements AsyncFailureInjector {
    private static final Random random = new Random(System.currentTimeMillis());
    private boolean simulateDelays;
    private boolean simulateErrors;
    private boolean simulateStops;
    private boolean simulateCorruption;
    private final int injectedDelayPercent;
    private final int injectedErrorPercent;
    private final int injectedStopPercent;
    private final int maxInjectedDelayMs;

    public static Builder newBuilder() {
        return new Builder();
    }

    private AsyncRandomFailureInjector(boolean simulateDelays, int injectedDelayPercent, int maxInjectedDelayMs, boolean simulateErrors, int injectedErrorPercent, boolean simulateStops, int injectedStopPercent, boolean simulateCorruption) {
        this.simulateDelays = simulateDelays;
        this.injectedDelayPercent = injectedDelayPercent;
        this.maxInjectedDelayMs = maxInjectedDelayMs;
        this.simulateErrors = simulateErrors;
        this.injectedErrorPercent = injectedErrorPercent;
        this.simulateStops = simulateStops;
        this.injectedStopPercent = injectedStopPercent;
        this.simulateCorruption = simulateCorruption;
    }

    @Override
    public void injectErrors(boolean enabled) {
        this.simulateErrors = enabled;
    }

    @Override
    public boolean shouldInjectErrors() {
        return this.simulateErrors && Utils.randomPercent(this.injectedErrorPercent);
    }

    @Override
    public void injectDelays(boolean enabled) {
        this.simulateDelays = enabled;
    }

    @Override
    public boolean shouldInjectDelays() {
        return this.simulateDelays && Utils.randomPercent(this.injectedDelayPercent);
    }

    @Override
    public int getInjectedDelayMs() {
        if (this.maxInjectedDelayMs > 0) {
            return random.nextInt(this.maxInjectedDelayMs);
        }
        return 0;
    }

    @Override
    public void injectStops(boolean enabled) {
        this.simulateStops = enabled;
    }

    @Override
    public boolean shouldInjectStops() {
        return this.simulateStops && Utils.randomPercent(this.injectedStopPercent);
    }

    @Override
    public boolean shouldInjectCorruption(long startEntryId, long endEntryId) {
        if (!this.simulateCorruption) {
            return false;
        }
        if (startEntryId == endEntryId) {
            return startEntryId % 10L == 0L;
        }
        for (long i = startEntryId; i <= endEntryId; ++i) {
            if (i % 10L != 0L) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FailureInjector[");
        sb.append("errors=(").append(this.simulateErrors).append(", pct=").append(this.injectedErrorPercent).append("), ");
        sb.append("delays=(").append(this.simulateDelays).append(", pct=").append(this.injectedDelayPercent).append(", max=").append(this.maxInjectedDelayMs).append("), ");
        sb.append("stops=(").append(this.simulateStops).append(", pct=").append(this.injectedStopPercent).append(")");
        sb.append("corruption=(").append(this.simulateCorruption).append(")");
        sb.append("]");
        return sb.toString();
    }

    public static class Builder {
        private boolean _simulateDelays = false;
        private boolean _simulateErrors = false;
        private boolean _simulateStops = false;
        private boolean _simulateCorruption = false;
        private int _injectedDelayPercent = 0;
        private int _injectedErrorPercent = 0;
        private int _injectedStopPercent = 0;
        private int _maxInjectedDelayMs = Integer.MAX_VALUE;

        private Builder() {
        }

        public Builder injectDelays(boolean simulateDelays, int injectedDelayPercent, int maxInjectedDelayMs) {
            this._simulateDelays = simulateDelays;
            this._injectedDelayPercent = injectedDelayPercent;
            this._maxInjectedDelayMs = maxInjectedDelayMs;
            return this;
        }

        public Builder injectErrors(boolean simulateErrors, int injectedErrorPercent) {
            this._simulateErrors = simulateErrors;
            this._injectedErrorPercent = injectedErrorPercent;
            return this;
        }

        public Builder injectCorruption(boolean simulateCorruption) {
            this._simulateCorruption = simulateCorruption;
            return this;
        }

        public Builder injectStops(boolean simulateStops, int injectedStopPercent) {
            this._simulateStops = simulateStops;
            this._injectedStopPercent = injectedStopPercent;
            return this;
        }

        public AsyncFailureInjector build() {
            return new AsyncRandomFailureInjector(this._simulateDelays, this._injectedDelayPercent, this._maxInjectedDelayMs, this._simulateErrors, this._injectedErrorPercent, this._simulateStops, this._injectedStopPercent, this._simulateCorruption);
        }
    }
}

