/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stream.server.service;

import com.google.common.base.Stopwatch;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.common.component.AbstractLifecycleComponent;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.common.conf.ComponentConfiguration;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.discover.RegistrationClient;
import org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.bookkeeper.meta.exceptions.MetadataException;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stream.server.conf.BookieConfiguration;
import org.apache.bookkeeper.versioning.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookieWatchService
extends AbstractLifecycleComponent<BookieConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(BookieWatchService.class);
    private final int minNumBookies;

    public BookieWatchService(int minNumBookies, BookieConfiguration conf, StatsLogger statsLogger) {
        super("bookie-watcher", (ComponentConfiguration)conf, statsLogger);
        this.minNumBookies = minNumBookies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() {
        ClientConfiguration clientConf = new ClientConfiguration();
        clientConf.loadConf(((BookieConfiguration)this.conf).getUnderlyingConf());
        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
        try {
            try {
                MetadataDrivers.runFunctionWithMetadataClientDriver((ClientConfiguration)clientConf, clientDriver -> {
                    try {
                        BookieWatchService.waitingForNumBookies(clientDriver.getRegistrationClient(), this.minNumBookies);
                    }
                    catch (Exception e) {
                        log.error("Encountered exceptions on waiting {} bookies to be alive", (Object)this.minNumBookies);
                        throw new RuntimeException("Encountered exceptions on waiting " + this.minNumBookies + " bookies to be alive", e);
                    }
                    return null;
                }, (ScheduledExecutorService)executorService);
            }
            catch (ExecutionException | MetadataException e) {
                throw new RuntimeException("Failed to start bookie watch service", e);
            }
        }
        finally {
            if (Collections.singletonList(executorService).get(0) != null) {
                executorService.shutdown();
            }
        }
    }

    private static void waitingForNumBookies(RegistrationClient client, int minNumBookies) throws Exception {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Set bookies = (Set)((Versioned)FutureUtils.result((CompletableFuture)client.getWritableBookies())).getValue();
        while (bookies.size() < minNumBookies) {
            TimeUnit.SECONDS.sleep(1L);
            bookies = (Set)((Versioned)FutureUtils.result((CompletableFuture)client.getWritableBookies())).getValue();
            log.info("Only {} bookies are live since {} seconds elapsed, wait for another {} bookies for another 1 second", new Object[]{bookies.size(), stopwatch.elapsed(TimeUnit.SECONDS), minNumBookies - bookies.size()});
        }
    }

    protected void doStop() {
    }

    protected void doClose() {
    }
}

