/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl;

import java.lang.ref.WeakReference;
import java.net.URI;
import java.util.Base64;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.AsyncResult;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Closeable;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Future;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Handler;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.MultiMap;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Promise;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.HttpClient;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.HttpClientOptions;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.HttpClientRequest;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.HttpClientResponse;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.HttpConnection;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.HttpHeaders;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.HttpMethod;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.HttpVersion;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.PoolOptions;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.RequestOptions;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl.ClientHttpEndpointBase;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl.EndpointKey;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl.HttpChannelConnector;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl.HttpClientBase;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl.HttpClientConnection;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl.HttpClientInternal;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl.HttpClientRequestImpl;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl.HttpClientStream;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl.HttpUtils;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl.SharedClientHttpStreamEndpoint;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.CloseFuture;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.ContextInternal;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.VertxInternal;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.future.PromiseInternal;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.net.HostAndPort;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.net.NetClient;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.net.ProxyOptions;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.net.ProxyType;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.net.SocketAddress;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.net.impl.pool.ConnectionManager;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.net.impl.pool.Endpoint;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.net.impl.pool.EndpointProvider;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.net.impl.pool.Lease;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.spi.metrics.ClientMetrics;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.spi.metrics.MetricsProvider;

public class HttpClientImpl
extends HttpClientBase
implements HttpClientInternal,
MetricsProvider,
Closeable {
    private static final Pattern ABS_URI_START_PATTERN = Pattern.compile("^\\p{Alpha}[\\p{Alpha}\\p{Digit}+.\\-]*:");
    private static final Function<HttpClientResponse, Future<RequestOptions>> DEFAULT_HANDLER = resp -> {
        try {
            int statusCode = resp.statusCode();
            String location = resp.getHeader(HttpHeaders.LOCATION);
            if (location != null && (statusCode == 301 || statusCode == 302 || statusCode == 303 || statusCode == 307 || statusCode == 308)) {
                String query;
                String requestURI;
                boolean ssl;
                HttpMethod m = resp.request().getMethod();
                if (statusCode == 303) {
                    m = HttpMethod.GET;
                } else if (m != HttpMethod.GET && m != HttpMethod.HEAD) {
                    return null;
                }
                URI uri = HttpUtils.resolveURIReference(resp.request().absoluteURI(), location);
                int port = uri.getPort();
                String protocol = uri.getScheme();
                char chend = protocol.charAt(protocol.length() - 1);
                if (chend == 'p') {
                    ssl = false;
                    if (port == -1) {
                        port = 80;
                    }
                } else if (chend == 's') {
                    ssl = true;
                    if (port == -1) {
                        port = 443;
                    }
                } else {
                    return null;
                }
                if ((requestURI = uri.getPath()) == null || requestURI.isEmpty()) {
                    requestURI = "/";
                }
                if ((query = uri.getQuery()) != null) {
                    requestURI = requestURI + "?" + query;
                }
                RequestOptions options = new RequestOptions();
                options.setMethod(m);
                options.setHost(uri.getHost());
                options.setPort(port);
                options.setSsl(ssl);
                options.setURI(requestURI);
                options.setHeaders(resp.request().headers());
                options.removeHeader(HttpHeaders.CONTENT_LENGTH);
                return Future.succeededFuture(options);
            }
            return null;
        }
        catch (Exception e) {
            return Future.failedFuture(e);
        }
    };
    private static final Consumer<Endpoint<Lease<HttpClientConnection>>> EXPIRED_CHECKER = endpoint -> ((ClientHttpEndpointBase)endpoint).checkExpired();
    private final ConnectionManager<EndpointKey, Lease<HttpClientConnection>> httpCM;
    private final PoolOptions poolOptions;
    private volatile Handler<HttpConnection> connectionHandler;
    private volatile Function<HttpClientResponse, Future<RequestOptions>> redirectHandler = DEFAULT_HANDLER;
    private long timerID;

    public HttpClientImpl(VertxInternal vertx, HttpClientOptions options, PoolOptions poolOptions, CloseFuture closeFuture) {
        super(vertx, options, closeFuture);
        this.poolOptions = new PoolOptions(poolOptions);
        this.httpCM = this.httpConnectionManager();
        if (poolOptions.getCleanerPeriod() > 0 && ((long)options.getKeepAliveTimeout() > 0L || (long)options.getHttp2KeepAliveTimeout() > 0L)) {
            PoolChecker checker = new PoolChecker(this);
            ContextInternal timerContext = vertx.createEventLoopContext();
            this.timerID = timerContext.setTimer(options.getPoolCleanerPeriod(), checker);
        }
    }

    @Override
    public NetClient netClient() {
        return this.netClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkExpired(Handler<Long> checker) {
        this.httpCM.forEach(EXPIRED_CHECKER);
        HttpClientImpl httpClientImpl = this;
        synchronized (httpClientImpl) {
            if (!this.closeFuture.isClosed()) {
                this.timerID = this.vertx.setTimer(this.poolOptions.getCleanerPeriod(), checker);
            }
        }
    }

    private ConnectionManager<EndpointKey, Lease<HttpClientConnection>> httpConnectionManager() {
        return new ConnectionManager<EndpointKey, Lease<HttpClientConnection>>();
    }

    @Override
    public Future<HttpClientConnection> connect(SocketAddress server) {
        return this.connect(server, null);
    }

    @Override
    public Future<HttpClientConnection> connect(SocketAddress server, SocketAddress peer) {
        ContextInternal context = this.vertx.getOrCreateContext();
        PromiseInternal<HttpClientConnection> promise = context.promise();
        HttpChannelConnector connector = new HttpChannelConnector(this, this.netClient, null, null, this.options.getProtocolVersion(), this.options.isSsl(), this.options.isUseAlpn(), peer, server);
        connector.httpConnect(context, promise);
        return promise.future();
    }

    @Override
    public void request(RequestOptions options, Handler<AsyncResult<HttpClientRequest>> handler) {
        ContextInternal ctx = this.vertx.getOrCreateContext();
        PromiseInternal<HttpClientRequest> promise = ctx.promise(handler);
        this.doRequest(options, promise);
    }

    @Override
    public Future<HttpClientRequest> request(RequestOptions options) {
        ContextInternal ctx = this.vertx.getOrCreateContext();
        PromiseInternal<HttpClientRequest> promise = ctx.promise();
        this.doRequest(options, promise);
        return promise.future();
    }

    @Override
    public void request(HttpMethod method, int port, String host, String requestURI, Handler<AsyncResult<HttpClientRequest>> handler) {
        this.request(new RequestOptions().setMethod(method).setPort(port).setHost(host).setURI(requestURI), handler);
    }

    @Override
    public Future<HttpClientRequest> request(HttpMethod method, int port, String host, String requestURI) {
        return this.request(new RequestOptions().setMethod(method).setPort(port).setHost(host).setURI(requestURI));
    }

    @Override
    public void request(HttpMethod method, String host, String requestURI, Handler<AsyncResult<HttpClientRequest>> handler) {
        this.request(method, this.options.getDefaultPort(), host, requestURI, handler);
    }

    @Override
    public Future<HttpClientRequest> request(HttpMethod method, String host, String requestURI) {
        return this.request(method, this.options.getDefaultPort(), host, requestURI);
    }

    @Override
    public void request(HttpMethod method, String requestURI, Handler<AsyncResult<HttpClientRequest>> handler) {
        this.request(method, this.options.getDefaultPort(), this.options.getDefaultHost(), requestURI, handler);
    }

    @Override
    public Future<HttpClientRequest> request(HttpMethod method, String requestURI) {
        return this.request(method, this.options.getDefaultPort(), this.options.getDefaultHost(), requestURI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(Promise<Void> completion) {
        HttpClientImpl httpClientImpl = this;
        synchronized (httpClientImpl) {
            if (this.timerID >= 0L) {
                this.vertx.cancelTimer(this.timerID);
                this.timerID = -1L;
            }
        }
        this.httpCM.close();
        super.close(completion);
    }

    @Override
    public HttpClient connectionHandler(Handler<HttpConnection> handler) {
        this.connectionHandler = handler;
        return this;
    }

    public Handler<HttpConnection> connectionHandler() {
        return this.connectionHandler;
    }

    @Override
    public HttpClient redirectHandler(Function<HttpClientResponse, Future<RequestOptions>> handler) {
        if (handler == null) {
            handler = DEFAULT_HANDLER;
        }
        this.redirectHandler = handler;
        return this;
    }

    @Override
    public Function<HttpClientResponse, Future<RequestOptions>> redirectHandler() {
        return this.redirectHandler;
    }

    private void doRequest(RequestOptions request, PromiseInternal<HttpClientRequest> promise) {
        EndpointKey key;
        boolean useSSL;
        String host = this.getHost(request);
        int port = this.getPort(request);
        SocketAddress server = request.getServer();
        if (server == null) {
            server = SocketAddress.inetSocketAddress(port, host);
        }
        HttpMethod method = request.getMethod();
        String requestURI = request.getURI();
        Boolean ssl = request.isSsl();
        MultiMap headers = request.getHeaders();
        Boolean followRedirects = request.getFollowRedirects();
        Objects.requireNonNull(method, "no null method accepted");
        Objects.requireNonNull(host, "no null host accepted");
        Objects.requireNonNull(requestURI, "no null requestURI accepted");
        boolean useAlpn = this.options.isUseAlpn();
        boolean bl = useSSL = ssl != null ? ssl.booleanValue() : this.options.isSsl();
        if (!useAlpn && useSSL && this.options.getProtocolVersion() == HttpVersion.HTTP_2) {
            throw new IllegalArgumentException("Must enable ALPN when using H2");
        }
        this.checkClosed();
        ProxyOptions proxyOptions = this.resolveProxyOptions(request.getProxyOptions(), server);
        String peerHost = host.charAt(host.length() - 1) == '.' ? host.substring(0, host.length() - 1) : host;
        SocketAddress peerAddress = HttpClientImpl.peerAddress(server, peerHost, port);
        if (proxyOptions != null && !useSSL && proxyOptions.getType() == ProxyType.HTTP) {
            if (!ABS_URI_START_PATTERN.matcher(requestURI).find()) {
                int defaultPort = 80;
                String addPort = port != -1 && port != defaultPort ? ":" + port : "";
                requestURI = (ssl == Boolean.TRUE ? "https://" : "http://") + host + addPort + requestURI;
            }
            if (proxyOptions.getUsername() != null && proxyOptions.getPassword() != null) {
                if (headers == null) {
                    headers = HttpHeaders.headers();
                }
                headers.add("Proxy-Authorization", "Basic " + Base64.getEncoder().encodeToString((proxyOptions.getUsername() + ":" + proxyOptions.getPassword()).getBytes()));
            }
            server = SocketAddress.inetSocketAddress(proxyOptions.getPort(), proxyOptions.getHost());
            key = new EndpointKey(useSSL, proxyOptions, server, peerAddress);
            proxyOptions = null;
        } else {
            key = new EndpointKey(useSSL, proxyOptions, server, peerAddress);
        }
        long connectTimeout = 0L;
        long idleTimeout = 0L;
        if (request.getTimeout() >= 0L) {
            connectTimeout = request.getTimeout();
            idleTimeout = request.getTimeout();
        }
        if (request.getConnectTimeout() >= 0L) {
            connectTimeout = request.getConnectTimeout();
        }
        if (request.getIdleTimeout() >= 0L) {
            idleTimeout = request.getIdleTimeout();
        }
        this.doRequest(method, server, host, port, useSSL, requestURI, headers, request.getTraceOperation(), connectTimeout, idleTimeout, followRedirects, proxyOptions, key, promise);
    }

    private static SocketAddress peerAddress(SocketAddress remoteAddress, String peerHost, int peerPort) {
        if (remoteAddress.isInetSocket() && peerHost.equals(remoteAddress.host()) && peerPort == remoteAddress.port()) {
            return remoteAddress;
        }
        return SocketAddress.inetSocketAddress(peerPort, peerHost);
    }

    private void doRequest(HttpMethod method, SocketAddress server, String host, int port, Boolean useSSL, String requestURI, MultiMap headers, String traceOperation, long connectTimeout, long idleTimeout, Boolean followRedirects, final ProxyOptions proxyOptions, final EndpointKey key, PromiseInternal<HttpClientRequest> requestPromise) {
        ContextInternal ctx = requestPromise.context();
        EndpointProvider<Lease<HttpClientConnection>> provider = new EndpointProvider<Lease<HttpClientConnection>>(){

            @Override
            public Endpoint<Lease<HttpClientConnection>> create(ContextInternal ctx, Runnable dispose) {
                int maxPoolSize = Math.max(HttpClientImpl.this.poolOptions.getHttp1MaxSize(), HttpClientImpl.this.poolOptions.getHttp2MaxSize());
                ClientMetrics metrics = HttpClientImpl.this.metrics != null ? HttpClientImpl.this.metrics.createEndpointMetrics(key.serverAddr, maxPoolSize) : null;
                HttpChannelConnector connector = new HttpChannelConnector(HttpClientImpl.this, HttpClientImpl.this.netClient, proxyOptions, metrics, HttpClientImpl.this.options.getProtocolVersion(), key.ssl, HttpClientImpl.this.options.isUseAlpn(), key.peerAddr, key.serverAddr);
                return new SharedClientHttpStreamEndpoint(HttpClientImpl.this, metrics, HttpClientImpl.this.poolOptions.getMaxWaitQueueSize(), HttpClientImpl.this.poolOptions.getHttp1MaxSize(), HttpClientImpl.this.poolOptions.getHttp2MaxSize(), connector, dispose);
            }
        };
        long now = System.currentTimeMillis();
        this.httpCM.getConnection(ctx, key, provider, connectTimeout, ar1 -> {
            if (ar1.succeeded()) {
                Lease lease = (Lease)ar1.result();
                HttpClientConnection conn = (HttpClientConnection)lease.get();
                conn.createStream(ctx, ar2 -> {
                    if (ar2.succeeded()) {
                        HttpClientStream stream = (HttpClientStream)ar2.result();
                        stream.closeHandler(v -> lease.recycle());
                        HttpClientRequest req = this.createRequest(stream);
                        req.setMethod(method);
                        req.authority(HostAndPort.create(host, port));
                        req.setURI(requestURI);
                        req.traceOperation(traceOperation);
                        if (headers != null) {
                            req.headers().setAll(headers);
                        }
                        if (followRedirects != null) {
                            req.setFollowRedirects(followRedirects);
                        }
                        if (idleTimeout > 0L) {
                            req.idleTimeout(idleTimeout);
                        }
                        requestPromise.tryComplete(req);
                    } else {
                        requestPromise.tryFail(ar2.cause());
                    }
                });
            } else {
                requestPromise.tryFail(ar1.cause());
            }
        });
    }

    private void checkClosed() {
        if (this.closeFuture.isClosed()) {
            throw new IllegalStateException("Client is closed");
        }
    }

    Future<HttpClientRequest> createRequest(HttpClientConnection conn, ContextInternal context) {
        PromiseInternal<HttpClientStream> promise = context.promise();
        conn.createStream(context, promise);
        return promise.map(this::createRequest);
    }

    private HttpClientRequest createRequest(HttpClientStream stream) {
        HttpClientRequestImpl request = new HttpClientRequestImpl(stream, stream.getContext().promise());
        Function<HttpClientResponse, Future<RequestOptions>> rHandler = this.redirectHandler;
        if (rHandler != null) {
            request.setMaxRedirects(this.options.getMaxRedirects());
            request.redirectHandler((HttpClientResponse resp) -> {
                Future fut_ = (Future)rHandler.apply((HttpClientResponse)resp);
                if (fut_ != null) {
                    return fut_.compose(this::request);
                }
                return null;
            });
        }
        return request;
    }

    private static class PoolChecker
    implements Handler<Long> {
        final WeakReference<HttpClientImpl> ref;

        private PoolChecker(HttpClientImpl client) {
            this.ref = new WeakReference<HttpClientImpl>(client);
        }

        @Override
        public void handle(Long event) {
            HttpClientImpl client = (HttpClientImpl)this.ref.get();
            if (client != null) {
                client.checkExpired(this);
            }
        }
    }
}

