/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats.prometheus;

import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Gauge;
import io.prometheus.client.hotspot.DefaultExports;
import org.apache.pulsar.PulsarVersion;
import org.apache.pulsar.common.stats.JvmMetrics;
import org.apache.pulsar.common.util.DirectMemoryUtils;

public class MetricsExports {
    private static boolean initialized = false;

    private MetricsExports() {
    }

    public static synchronized void initialize() {
        if (!initialized) {
            DefaultExports.initialize();
            MetricsExports.register(CollectorRegistry.defaultRegistry);
            initialized = true;
        }
    }

    public static void register(CollectorRegistry registry) {
        Gauge.build((String)"jvm_memory_direct_bytes_used", (String)"-").create().setChild((Object)new Gauge.Child(){

            public double get() {
                return JvmMetrics.getJvmDirectMemoryUsed();
            }
        }, new String[0]).register(registry);
        Gauge.build((String)"jvm_memory_direct_bytes_max", (String)"-").create().setChild((Object)new Gauge.Child(){

            public double get() {
                return DirectMemoryUtils.jvmMaxDirectMemory();
            }
        }, new String[0]).register(registry);
        ((Gauge.Builder)Gauge.build((String)"pulsar_version_info", (String)"-").labelNames(new String[]{"version", "commit"})).create().setChild((Object)new Gauge.Child(){

            public double get() {
                return 1.0;
            }
        }, new String[]{PulsarVersion.getVersion(), PulsarVersion.getGitSha()}).register(registry);
    }
}

