/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats.metrics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.ManagedCursorMXBean;
import org.apache.bookkeeper.mledger.ManagedLedger;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.stats.metrics.AbstractMetrics;
import org.apache.pulsar.common.stats.Metrics;

public class ManagedCursorMetrics
extends AbstractMetrics {
    private Map<String, String> dimensionMap;
    private List<Metrics> metricsCollection = new ArrayList<Metrics>();

    public ManagedCursorMetrics(PulsarService pulsar) {
        super(pulsar);
        this.dimensionMap = new HashMap<String, String>();
    }

    @Override
    public synchronized List<Metrics> generate() {
        return this.aggregate();
    }

    private List<Metrics> aggregate() {
        this.metricsCollection.clear();
        for (Map.Entry<String, ManagedLedger> e : this.getManagedLedgers().entrySet()) {
            String ledgerName = e.getKey();
            ManagedLedger ledger = e.getValue();
            String namespace = this.parseNamespaceFromLedgerName(ledgerName);
            for (ManagedCursor cursor : ledger.getCursors()) {
                ManagedCursorMXBean cStats = cursor.getStats();
                this.dimensionMap.clear();
                this.dimensionMap.put("namespace", namespace);
                this.dimensionMap.put("ledger_name", ledgerName);
                this.dimensionMap.put("cursor_name", cursor.getName());
                Metrics metrics = this.createMetrics(this.dimensionMap);
                metrics.put("brk_ml_cursor_nonContiguousDeletedMessagesRange", (Object)cursor.getTotalNonContiguousDeletedMessagesRange());
                metrics.put("brk_ml_cursor_persistLedgerSucceed", (Object)cStats.getPersistLedgerSucceed());
                metrics.put("brk_ml_cursor_persistLedgerErrors", (Object)cStats.getPersistLedgerErrors());
                metrics.put("brk_ml_cursor_persistZookeeperSucceed", (Object)cStats.getPersistZookeeperSucceed());
                metrics.put("brk_ml_cursor_persistZookeeperErrors", (Object)cStats.getPersistZookeeperErrors());
                metrics.put("brk_ml_cursor_writeLedgerSize", (Object)cStats.getWriteCursorLedgerSize());
                metrics.put("brk_ml_cursor_writeLedgerLogicalSize", (Object)cStats.getWriteCursorLedgerLogicalSize());
                metrics.put("brk_ml_cursor_readLedgerSize", (Object)cStats.getReadCursorLedgerSize());
                this.metricsCollection.add(metrics);
            }
        }
        return this.metricsCollection;
    }
}

