/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.conf;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.client.api.BatcherBuilder;
import org.apache.pulsar.client.api.CompressionType;
import org.apache.pulsar.client.api.CryptoKeyReader;
import org.apache.pulsar.client.api.HashingScheme;
import org.apache.pulsar.client.api.MessageCrypto;
import org.apache.pulsar.client.api.MessageRouter;
import org.apache.pulsar.client.api.MessageRoutingMode;
import org.apache.pulsar.client.api.ProducerAccessMode;
import org.apache.pulsar.client.api.ProducerCryptoFailureAction;

public class ProducerConfigurationData
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_BATCHING_MAX_MESSAGES = 1000;
    public static final int DEFAULT_MAX_PENDING_MESSAGES = 0;
    public static final int DEFAULT_MAX_PENDING_MESSAGES_ACROSS_PARTITIONS = 0;
    @ApiModelProperty(name="topicName", required=true, value="Topic name")
    private String topicName = null;
    @ApiModelProperty(name="producerName", value="Producer name")
    private String producerName = null;
    @ApiModelProperty(name="sendTimeoutMs", value="Message send timeout in ms.\nIf a message is not acknowledged by a server before the `sendTimeout` expires, an error occurs.")
    private long sendTimeoutMs = 30000L;
    @ApiModelProperty(name="blockIfQueueFull", value="If it is set to `true`, when the outgoing message queue is full, the `Send` and `SendAsync` methods of producer block, rather than failing and throwing errors.\nIf it is set to `false`, when the outgoing message queue is full, the `Send` and `SendAsync` methods of producer fail and `ProducerQueueIsFullError` exceptions occur.\n\nThe `MaxPendingMessages` parameter determines the size of the outgoing message queue.")
    private boolean blockIfQueueFull = false;
    @ApiModelProperty(name="maxPendingMessages", value="The maximum size of a queue holding pending messages.\n\nFor example, a message waiting to receive an acknowledgment from a [broker](https://pulsar.apache.org/docs/reference-terminology#broker).\n\nBy default, when the queue is full, all calls to the `Send` and `SendAsync` methods fail **unless** you set `BlockIfQueueFull` to `true`.")
    @VisibleForTesting
    private int maxPendingMessages = 0;
    @ApiModelProperty(name="maxPendingMessagesAcrossPartitions", value="The maximum number of pending messages across partitions.\n\nUse the setting to lower the max pending messages for each partition ({@link #setMaxPendingMessages(int)}) if the total number exceeds the configured value.")
    private int maxPendingMessagesAcrossPartitions = 0;
    @ApiModelProperty(name="messageRoutingMode", value="Message routing logic for producers on [partitioned topics](https://pulsar.apache.org/docs/concepts-architecture-overview#partitioned-topics).\nApply the logic only when setting no key on messages.\nAvailable options are as follows:\n* `pulsar.RoundRobinDistribution`: round robin\n* `pulsar.UseSinglePartition`: publish all messages to a single partition\n* `pulsar.CustomPartition`: a custom partitioning scheme")
    private MessageRoutingMode messageRoutingMode = null;
    @ApiModelProperty(name="hashingScheme", value="Hashing function determining the partition where you publish a particular message (partitioned topics only).\nAvailable options are as follows:\n* `pulsar.JavastringHash`: the equivalent of `string.hashCode()` in Java\n* `pulsar.Murmur3_32Hash`: applies the [Murmur3](https://en.wikipedia.org/wiki/MurmurHash) hashing function\n* `pulsar.BoostHash`: applies the hashing function from C++'s[Boost](https://www.boost.org/doc/libs/1_62_0/doc/html/hash.html) library")
    private HashingScheme hashingScheme = HashingScheme.JavaStringHash;
    @ApiModelProperty(name="cryptoFailureAction", value="Producer should take action when encryption fails.\n* **FAIL**: if encryption fails, unencrypted messages fail to send.\n* **SEND**: if encryption fails, unencrypted messages are sent.")
    private ProducerCryptoFailureAction cryptoFailureAction = ProducerCryptoFailureAction.FAIL;
    @JsonIgnore
    private MessageRouter customMessageRouter = null;
    @ApiModelProperty(name="batchingMaxPublishDelayMicros", value="Batching time period of sending messages.")
    private long batchingMaxPublishDelayMicros = TimeUnit.MILLISECONDS.toMicros(1L);
    private int batchingPartitionSwitchFrequencyByPublishDelay = 10;
    @ApiModelProperty(name="batchingMaxMessages", value="The maximum number of messages permitted in a batch.")
    private int batchingMaxMessages = 1000;
    private int batchingMaxBytes = 131072;
    @ApiModelProperty(name="batchingEnabled", value="Enable batching of messages.")
    private boolean batchingEnabled = true;
    @JsonIgnore
    private BatcherBuilder batcherBuilder = BatcherBuilder.DEFAULT;
    @ApiModelProperty(name="chunkingEnabled", value="Enable chunking of messages.")
    private boolean chunkingEnabled = false;
    private int chunkMaxMessageSize = -1;
    @JsonIgnore
    private CryptoKeyReader cryptoKeyReader;
    @JsonIgnore
    private transient MessageCrypto messageCrypto = null;
    private Set<String> encryptionKeys = new TreeSet<String>();
    @ApiModelProperty(name="compressionType", value="Message data compression type used by a producer.\nAvailable options:\n* [LZ4](https://github.com/lz4/lz4)\n* [ZLIB](https://zlib.net/)\n* [ZSTD](https://facebook.github.io/zstd/)\n* [SNAPPY](https://google.github.io/snappy/)")
    private CompressionType compressionType = CompressionType.NONE;
    private Long initialSequenceId = null;
    private boolean autoUpdatePartitions = true;
    private long autoUpdatePartitionsIntervalSeconds = 60L;
    private boolean multiSchema = true;
    private ProducerAccessMode accessMode = ProducerAccessMode.Shared;
    private boolean lazyStartPartitionedProducers = false;
    private SortedMap<String, String> properties = new TreeMap<String, String>();
    private boolean isNonPartitionedTopicExpected;
    private boolean isReplProducer;
    @ApiModelProperty(name="initialSubscriptionName", value="Use this configuration to automatically create an initial subscription when creating a topic. If this field is not set, the initial subscription is not created.")
    private String initialSubscriptionName = null;

    @JsonIgnore
    public boolean isEncryptionEnabled() {
        return this.encryptionKeys != null && !this.encryptionKeys.isEmpty() && this.cryptoKeyReader != null;
    }

    public ProducerConfigurationData clone() {
        try {
            ProducerConfigurationData c = (ProducerConfigurationData)super.clone();
            c.encryptionKeys = Sets.newTreeSet(this.encryptionKeys);
            c.properties = new TreeMap<String, String>(this.properties);
            return c;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Failed to clone ProducerConfigurationData", e);
        }
    }

    public void setProducerName(String producerName) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)producerName), (Object)"producerName cannot be blank");
        this.producerName = producerName;
    }

    public void setMaxPendingMessages(int maxPendingMessages) {
        Preconditions.checkArgument((maxPendingMessages >= 0 ? 1 : 0) != 0, (Object)"maxPendingMessages needs to be >= 0");
        this.maxPendingMessages = maxPendingMessages;
    }

    public void setMaxPendingMessagesAcrossPartitions(int maxPendingMessagesAcrossPartitions) {
        Preconditions.checkArgument((maxPendingMessagesAcrossPartitions >= this.maxPendingMessages ? 1 : 0) != 0, (Object)"maxPendingMessagesAcrossPartitions needs to be >= maxPendingMessages");
        this.maxPendingMessagesAcrossPartitions = maxPendingMessagesAcrossPartitions;
    }

    public void setBatchingMaxMessages(int batchingMaxMessages) {
        this.batchingMaxMessages = batchingMaxMessages;
    }

    public void setBatchingMaxBytes(int batchingMaxBytes) {
        this.batchingMaxBytes = batchingMaxBytes;
    }

    public void setSendTimeoutMs(int sendTimeout, TimeUnit timeUnit) {
        Preconditions.checkArgument((sendTimeout >= 0 ? 1 : 0) != 0, (Object)"sendTimeout needs to be >= 0");
        this.sendTimeoutMs = timeUnit.toMillis(sendTimeout);
    }

    public void setBatchingMaxPublishDelayMicros(long batchDelay, TimeUnit timeUnit) {
        long delayInMs = timeUnit.toMillis(batchDelay);
        Preconditions.checkArgument((delayInMs >= 1L ? 1 : 0) != 0, (Object)"configured value for batch delay must be at least 1ms");
        this.batchingMaxPublishDelayMicros = timeUnit.toMicros(batchDelay);
    }

    public void setBatchingPartitionSwitchFrequencyByPublishDelay(int frequencyByPublishDelay) {
        Preconditions.checkArgument((frequencyByPublishDelay >= 1 ? 1 : 0) != 0, (Object)"configured value for partition switch frequency must be >= 1");
        this.batchingPartitionSwitchFrequencyByPublishDelay = frequencyByPublishDelay;
    }

    public long batchingPartitionSwitchFrequencyIntervalMicros() {
        return (long)this.batchingPartitionSwitchFrequencyByPublishDelay * this.batchingMaxPublishDelayMicros;
    }

    public void setAutoUpdatePartitionsIntervalSeconds(int interval, TimeUnit timeUnit) {
        Preconditions.checkArgument((interval > 0 ? 1 : 0) != 0, (Object)"interval needs to be > 0");
        this.autoUpdatePartitionsIntervalSeconds = timeUnit.toSeconds(interval);
    }

    @Generated
    public String getTopicName() {
        return this.topicName;
    }

    @Generated
    public String getProducerName() {
        return this.producerName;
    }

    @Generated
    public long getSendTimeoutMs() {
        return this.sendTimeoutMs;
    }

    @Generated
    public boolean isBlockIfQueueFull() {
        return this.blockIfQueueFull;
    }

    @Generated
    public int getMaxPendingMessagesAcrossPartitions() {
        return this.maxPendingMessagesAcrossPartitions;
    }

    @Generated
    public MessageRoutingMode getMessageRoutingMode() {
        return this.messageRoutingMode;
    }

    @Generated
    public HashingScheme getHashingScheme() {
        return this.hashingScheme;
    }

    @Generated
    public ProducerCryptoFailureAction getCryptoFailureAction() {
        return this.cryptoFailureAction;
    }

    @Generated
    public MessageRouter getCustomMessageRouter() {
        return this.customMessageRouter;
    }

    @Generated
    public long getBatchingMaxPublishDelayMicros() {
        return this.batchingMaxPublishDelayMicros;
    }

    @Generated
    public int getBatchingPartitionSwitchFrequencyByPublishDelay() {
        return this.batchingPartitionSwitchFrequencyByPublishDelay;
    }

    @Generated
    public int getBatchingMaxMessages() {
        return this.batchingMaxMessages;
    }

    @Generated
    public int getBatchingMaxBytes() {
        return this.batchingMaxBytes;
    }

    @Generated
    public boolean isBatchingEnabled() {
        return this.batchingEnabled;
    }

    @Generated
    public BatcherBuilder getBatcherBuilder() {
        return this.batcherBuilder;
    }

    @Generated
    public boolean isChunkingEnabled() {
        return this.chunkingEnabled;
    }

    @Generated
    public int getChunkMaxMessageSize() {
        return this.chunkMaxMessageSize;
    }

    @Generated
    public CryptoKeyReader getCryptoKeyReader() {
        return this.cryptoKeyReader;
    }

    @Generated
    public MessageCrypto getMessageCrypto() {
        return this.messageCrypto;
    }

    @Generated
    public Set<String> getEncryptionKeys() {
        return this.encryptionKeys;
    }

    @Generated
    public CompressionType getCompressionType() {
        return this.compressionType;
    }

    @Generated
    public Long getInitialSequenceId() {
        return this.initialSequenceId;
    }

    @Generated
    public boolean isAutoUpdatePartitions() {
        return this.autoUpdatePartitions;
    }

    @Generated
    public long getAutoUpdatePartitionsIntervalSeconds() {
        return this.autoUpdatePartitionsIntervalSeconds;
    }

    @Generated
    public boolean isMultiSchema() {
        return this.multiSchema;
    }

    @Generated
    public ProducerAccessMode getAccessMode() {
        return this.accessMode;
    }

    @Generated
    public boolean isLazyStartPartitionedProducers() {
        return this.lazyStartPartitionedProducers;
    }

    @Generated
    public SortedMap<String, String> getProperties() {
        return this.properties;
    }

    @Generated
    public boolean isNonPartitionedTopicExpected() {
        return this.isNonPartitionedTopicExpected;
    }

    @Generated
    public boolean isReplProducer() {
        return this.isReplProducer;
    }

    @Generated
    public String getInitialSubscriptionName() {
        return this.initialSubscriptionName;
    }

    @Generated
    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    @Generated
    public void setSendTimeoutMs(long sendTimeoutMs) {
        this.sendTimeoutMs = sendTimeoutMs;
    }

    @Generated
    public void setBlockIfQueueFull(boolean blockIfQueueFull) {
        this.blockIfQueueFull = blockIfQueueFull;
    }

    @Generated
    public void setMessageRoutingMode(MessageRoutingMode messageRoutingMode) {
        this.messageRoutingMode = messageRoutingMode;
    }

    @Generated
    public void setHashingScheme(HashingScheme hashingScheme) {
        this.hashingScheme = hashingScheme;
    }

    @Generated
    public void setCryptoFailureAction(ProducerCryptoFailureAction cryptoFailureAction) {
        this.cryptoFailureAction = cryptoFailureAction;
    }

    @Generated
    public void setCustomMessageRouter(MessageRouter customMessageRouter) {
        this.customMessageRouter = customMessageRouter;
    }

    @Generated
    public void setBatchingMaxPublishDelayMicros(long batchingMaxPublishDelayMicros) {
        this.batchingMaxPublishDelayMicros = batchingMaxPublishDelayMicros;
    }

    @Generated
    public void setBatchingEnabled(boolean batchingEnabled) {
        this.batchingEnabled = batchingEnabled;
    }

    @Generated
    public void setBatcherBuilder(BatcherBuilder batcherBuilder) {
        this.batcherBuilder = batcherBuilder;
    }

    @Generated
    public void setChunkingEnabled(boolean chunkingEnabled) {
        this.chunkingEnabled = chunkingEnabled;
    }

    @Generated
    public void setChunkMaxMessageSize(int chunkMaxMessageSize) {
        this.chunkMaxMessageSize = chunkMaxMessageSize;
    }

    @Generated
    public void setCryptoKeyReader(CryptoKeyReader cryptoKeyReader) {
        this.cryptoKeyReader = cryptoKeyReader;
    }

    @Generated
    public void setMessageCrypto(MessageCrypto messageCrypto) {
        this.messageCrypto = messageCrypto;
    }

    @Generated
    public void setEncryptionKeys(Set<String> encryptionKeys) {
        this.encryptionKeys = encryptionKeys;
    }

    @Generated
    public void setCompressionType(CompressionType compressionType) {
        this.compressionType = compressionType;
    }

    @Generated
    public void setInitialSequenceId(Long initialSequenceId) {
        this.initialSequenceId = initialSequenceId;
    }

    @Generated
    public void setAutoUpdatePartitions(boolean autoUpdatePartitions) {
        this.autoUpdatePartitions = autoUpdatePartitions;
    }

    @Generated
    public void setAutoUpdatePartitionsIntervalSeconds(long autoUpdatePartitionsIntervalSeconds) {
        this.autoUpdatePartitionsIntervalSeconds = autoUpdatePartitionsIntervalSeconds;
    }

    @Generated
    public void setMultiSchema(boolean multiSchema) {
        this.multiSchema = multiSchema;
    }

    @Generated
    public void setAccessMode(ProducerAccessMode accessMode) {
        this.accessMode = accessMode;
    }

    @Generated
    public void setLazyStartPartitionedProducers(boolean lazyStartPartitionedProducers) {
        this.lazyStartPartitionedProducers = lazyStartPartitionedProducers;
    }

    @Generated
    public void setProperties(SortedMap<String, String> properties) {
        this.properties = properties;
    }

    @Generated
    public void setNonPartitionedTopicExpected(boolean isNonPartitionedTopicExpected) {
        this.isNonPartitionedTopicExpected = isNonPartitionedTopicExpected;
    }

    @Generated
    public void setReplProducer(boolean isReplProducer) {
        this.isReplProducer = isReplProducer;
    }

    @Generated
    public void setInitialSubscriptionName(String initialSubscriptionName) {
        this.initialSubscriptionName = initialSubscriptionName;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProducerConfigurationData)) {
            return false;
        }
        ProducerConfigurationData other = (ProducerConfigurationData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSendTimeoutMs() != other.getSendTimeoutMs()) {
            return false;
        }
        if (this.isBlockIfQueueFull() != other.isBlockIfQueueFull()) {
            return false;
        }
        if (this.getMaxPendingMessages() != other.getMaxPendingMessages()) {
            return false;
        }
        if (this.getMaxPendingMessagesAcrossPartitions() != other.getMaxPendingMessagesAcrossPartitions()) {
            return false;
        }
        if (this.getBatchingMaxPublishDelayMicros() != other.getBatchingMaxPublishDelayMicros()) {
            return false;
        }
        if (this.getBatchingPartitionSwitchFrequencyByPublishDelay() != other.getBatchingPartitionSwitchFrequencyByPublishDelay()) {
            return false;
        }
        if (this.getBatchingMaxMessages() != other.getBatchingMaxMessages()) {
            return false;
        }
        if (this.getBatchingMaxBytes() != other.getBatchingMaxBytes()) {
            return false;
        }
        if (this.isBatchingEnabled() != other.isBatchingEnabled()) {
            return false;
        }
        if (this.isChunkingEnabled() != other.isChunkingEnabled()) {
            return false;
        }
        if (this.getChunkMaxMessageSize() != other.getChunkMaxMessageSize()) {
            return false;
        }
        if (this.isAutoUpdatePartitions() != other.isAutoUpdatePartitions()) {
            return false;
        }
        if (this.getAutoUpdatePartitionsIntervalSeconds() != other.getAutoUpdatePartitionsIntervalSeconds()) {
            return false;
        }
        if (this.isMultiSchema() != other.isMultiSchema()) {
            return false;
        }
        if (this.isLazyStartPartitionedProducers() != other.isLazyStartPartitionedProducers()) {
            return false;
        }
        if (this.isNonPartitionedTopicExpected() != other.isNonPartitionedTopicExpected()) {
            return false;
        }
        if (this.isReplProducer() != other.isReplProducer()) {
            return false;
        }
        Long this$initialSequenceId = this.getInitialSequenceId();
        Long other$initialSequenceId = other.getInitialSequenceId();
        if (this$initialSequenceId == null ? other$initialSequenceId != null : !((Object)this$initialSequenceId).equals(other$initialSequenceId)) {
            return false;
        }
        String this$topicName = this.getTopicName();
        String other$topicName = other.getTopicName();
        if (this$topicName == null ? other$topicName != null : !this$topicName.equals(other$topicName)) {
            return false;
        }
        String this$producerName = this.getProducerName();
        String other$producerName = other.getProducerName();
        if (this$producerName == null ? other$producerName != null : !this$producerName.equals(other$producerName)) {
            return false;
        }
        MessageRoutingMode this$messageRoutingMode = this.getMessageRoutingMode();
        MessageRoutingMode other$messageRoutingMode = other.getMessageRoutingMode();
        if (this$messageRoutingMode == null ? other$messageRoutingMode != null : !this$messageRoutingMode.equals(other$messageRoutingMode)) {
            return false;
        }
        HashingScheme this$hashingScheme = this.getHashingScheme();
        HashingScheme other$hashingScheme = other.getHashingScheme();
        if (this$hashingScheme == null ? other$hashingScheme != null : !this$hashingScheme.equals(other$hashingScheme)) {
            return false;
        }
        ProducerCryptoFailureAction this$cryptoFailureAction = this.getCryptoFailureAction();
        ProducerCryptoFailureAction other$cryptoFailureAction = other.getCryptoFailureAction();
        if (this$cryptoFailureAction == null ? other$cryptoFailureAction != null : !this$cryptoFailureAction.equals(other$cryptoFailureAction)) {
            return false;
        }
        MessageRouter this$customMessageRouter = this.getCustomMessageRouter();
        MessageRouter other$customMessageRouter = other.getCustomMessageRouter();
        if (this$customMessageRouter == null ? other$customMessageRouter != null : !this$customMessageRouter.equals(other$customMessageRouter)) {
            return false;
        }
        BatcherBuilder this$batcherBuilder = this.getBatcherBuilder();
        BatcherBuilder other$batcherBuilder = other.getBatcherBuilder();
        if (this$batcherBuilder == null ? other$batcherBuilder != null : !this$batcherBuilder.equals(other$batcherBuilder)) {
            return false;
        }
        CryptoKeyReader this$cryptoKeyReader = this.getCryptoKeyReader();
        CryptoKeyReader other$cryptoKeyReader = other.getCryptoKeyReader();
        if (this$cryptoKeyReader == null ? other$cryptoKeyReader != null : !this$cryptoKeyReader.equals(other$cryptoKeyReader)) {
            return false;
        }
        Set<String> this$encryptionKeys = this.getEncryptionKeys();
        Set<String> other$encryptionKeys = other.getEncryptionKeys();
        if (this$encryptionKeys == null ? other$encryptionKeys != null : !((Object)this$encryptionKeys).equals(other$encryptionKeys)) {
            return false;
        }
        CompressionType this$compressionType = this.getCompressionType();
        CompressionType other$compressionType = other.getCompressionType();
        if (this$compressionType == null ? other$compressionType != null : !this$compressionType.equals(other$compressionType)) {
            return false;
        }
        ProducerAccessMode this$accessMode = this.getAccessMode();
        ProducerAccessMode other$accessMode = other.getAccessMode();
        if (this$accessMode == null ? other$accessMode != null : !this$accessMode.equals(other$accessMode)) {
            return false;
        }
        SortedMap<String, String> this$properties = this.getProperties();
        SortedMap<String, String> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !this$properties.equals(other$properties)) {
            return false;
        }
        String this$initialSubscriptionName = this.getInitialSubscriptionName();
        String other$initialSubscriptionName = other.getInitialSubscriptionName();
        return !(this$initialSubscriptionName == null ? other$initialSubscriptionName != null : !this$initialSubscriptionName.equals(other$initialSubscriptionName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProducerConfigurationData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $sendTimeoutMs = this.getSendTimeoutMs();
        result = result * 59 + (int)($sendTimeoutMs >>> 32 ^ $sendTimeoutMs);
        result = result * 59 + (this.isBlockIfQueueFull() ? 79 : 97);
        result = result * 59 + this.getMaxPendingMessages();
        result = result * 59 + this.getMaxPendingMessagesAcrossPartitions();
        long $batchingMaxPublishDelayMicros = this.getBatchingMaxPublishDelayMicros();
        result = result * 59 + (int)($batchingMaxPublishDelayMicros >>> 32 ^ $batchingMaxPublishDelayMicros);
        result = result * 59 + this.getBatchingPartitionSwitchFrequencyByPublishDelay();
        result = result * 59 + this.getBatchingMaxMessages();
        result = result * 59 + this.getBatchingMaxBytes();
        result = result * 59 + (this.isBatchingEnabled() ? 79 : 97);
        result = result * 59 + (this.isChunkingEnabled() ? 79 : 97);
        result = result * 59 + this.getChunkMaxMessageSize();
        result = result * 59 + (this.isAutoUpdatePartitions() ? 79 : 97);
        long $autoUpdatePartitionsIntervalSeconds = this.getAutoUpdatePartitionsIntervalSeconds();
        result = result * 59 + (int)($autoUpdatePartitionsIntervalSeconds >>> 32 ^ $autoUpdatePartitionsIntervalSeconds);
        result = result * 59 + (this.isMultiSchema() ? 79 : 97);
        result = result * 59 + (this.isLazyStartPartitionedProducers() ? 79 : 97);
        result = result * 59 + (this.isNonPartitionedTopicExpected() ? 79 : 97);
        result = result * 59 + (this.isReplProducer() ? 79 : 97);
        Long $initialSequenceId = this.getInitialSequenceId();
        result = result * 59 + ($initialSequenceId == null ? 43 : ((Object)$initialSequenceId).hashCode());
        String $topicName = this.getTopicName();
        result = result * 59 + ($topicName == null ? 43 : $topicName.hashCode());
        String $producerName = this.getProducerName();
        result = result * 59 + ($producerName == null ? 43 : $producerName.hashCode());
        MessageRoutingMode $messageRoutingMode = this.getMessageRoutingMode();
        result = result * 59 + ($messageRoutingMode == null ? 43 : $messageRoutingMode.hashCode());
        HashingScheme $hashingScheme = this.getHashingScheme();
        result = result * 59 + ($hashingScheme == null ? 43 : $hashingScheme.hashCode());
        ProducerCryptoFailureAction $cryptoFailureAction = this.getCryptoFailureAction();
        result = result * 59 + ($cryptoFailureAction == null ? 43 : $cryptoFailureAction.hashCode());
        MessageRouter $customMessageRouter = this.getCustomMessageRouter();
        result = result * 59 + ($customMessageRouter == null ? 43 : $customMessageRouter.hashCode());
        BatcherBuilder $batcherBuilder = this.getBatcherBuilder();
        result = result * 59 + ($batcherBuilder == null ? 43 : $batcherBuilder.hashCode());
        CryptoKeyReader $cryptoKeyReader = this.getCryptoKeyReader();
        result = result * 59 + ($cryptoKeyReader == null ? 43 : $cryptoKeyReader.hashCode());
        Set<String> $encryptionKeys = this.getEncryptionKeys();
        result = result * 59 + ($encryptionKeys == null ? 43 : ((Object)$encryptionKeys).hashCode());
        CompressionType $compressionType = this.getCompressionType();
        result = result * 59 + ($compressionType == null ? 43 : $compressionType.hashCode());
        ProducerAccessMode $accessMode = this.getAccessMode();
        result = result * 59 + ($accessMode == null ? 43 : $accessMode.hashCode());
        SortedMap<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : $properties.hashCode());
        String $initialSubscriptionName = this.getInitialSubscriptionName();
        result = result * 59 + ($initialSubscriptionName == null ? 43 : $initialSubscriptionName.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ProducerConfigurationData(topicName=" + this.getTopicName() + ", producerName=" + this.getProducerName() + ", sendTimeoutMs=" + this.getSendTimeoutMs() + ", blockIfQueueFull=" + this.isBlockIfQueueFull() + ", maxPendingMessages=" + this.getMaxPendingMessages() + ", maxPendingMessagesAcrossPartitions=" + this.getMaxPendingMessagesAcrossPartitions() + ", messageRoutingMode=" + this.getMessageRoutingMode() + ", hashingScheme=" + this.getHashingScheme() + ", cryptoFailureAction=" + this.getCryptoFailureAction() + ", customMessageRouter=" + this.getCustomMessageRouter() + ", batchingMaxPublishDelayMicros=" + this.getBatchingMaxPublishDelayMicros() + ", batchingPartitionSwitchFrequencyByPublishDelay=" + this.getBatchingPartitionSwitchFrequencyByPublishDelay() + ", batchingMaxMessages=" + this.getBatchingMaxMessages() + ", batchingMaxBytes=" + this.getBatchingMaxBytes() + ", batchingEnabled=" + this.isBatchingEnabled() + ", batcherBuilder=" + this.getBatcherBuilder() + ", chunkingEnabled=" + this.isChunkingEnabled() + ", chunkMaxMessageSize=" + this.getChunkMaxMessageSize() + ", cryptoKeyReader=" + this.getCryptoKeyReader() + ", messageCrypto=" + this.getMessageCrypto() + ", encryptionKeys=" + this.getEncryptionKeys() + ", compressionType=" + this.getCompressionType() + ", initialSequenceId=" + this.getInitialSequenceId() + ", autoUpdatePartitions=" + this.isAutoUpdatePartitions() + ", autoUpdatePartitionsIntervalSeconds=" + this.getAutoUpdatePartitionsIntervalSeconds() + ", multiSchema=" + this.isMultiSchema() + ", accessMode=" + this.getAccessMode() + ", lazyStartPartitionedProducers=" + this.isLazyStartPartitionedProducers() + ", properties=" + this.getProperties() + ", isNonPartitionedTopicExpected=" + this.isNonPartitionedTopicExpected() + ", isReplProducer=" + this.isReplProducer() + ", initialSubscriptionName=" + this.getInitialSubscriptionName() + ")";
    }

    @Generated
    public ProducerConfigurationData() {
    }

    @Generated
    public ProducerConfigurationData(String topicName, String producerName, long sendTimeoutMs, boolean blockIfQueueFull, int maxPendingMessages, int maxPendingMessagesAcrossPartitions, MessageRoutingMode messageRoutingMode, HashingScheme hashingScheme, ProducerCryptoFailureAction cryptoFailureAction, MessageRouter customMessageRouter, long batchingMaxPublishDelayMicros, int batchingPartitionSwitchFrequencyByPublishDelay, int batchingMaxMessages, int batchingMaxBytes, boolean batchingEnabled, BatcherBuilder batcherBuilder, boolean chunkingEnabled, int chunkMaxMessageSize, CryptoKeyReader cryptoKeyReader, MessageCrypto messageCrypto, Set<String> encryptionKeys, CompressionType compressionType, Long initialSequenceId, boolean autoUpdatePartitions, long autoUpdatePartitionsIntervalSeconds, boolean multiSchema, ProducerAccessMode accessMode, boolean lazyStartPartitionedProducers, SortedMap<String, String> properties, boolean isNonPartitionedTopicExpected, boolean isReplProducer, String initialSubscriptionName) {
        this.topicName = topicName;
        this.producerName = producerName;
        this.sendTimeoutMs = sendTimeoutMs;
        this.blockIfQueueFull = blockIfQueueFull;
        this.maxPendingMessages = maxPendingMessages;
        this.maxPendingMessagesAcrossPartitions = maxPendingMessagesAcrossPartitions;
        this.messageRoutingMode = messageRoutingMode;
        this.hashingScheme = hashingScheme;
        this.cryptoFailureAction = cryptoFailureAction;
        this.customMessageRouter = customMessageRouter;
        this.batchingMaxPublishDelayMicros = batchingMaxPublishDelayMicros;
        this.batchingPartitionSwitchFrequencyByPublishDelay = batchingPartitionSwitchFrequencyByPublishDelay;
        this.batchingMaxMessages = batchingMaxMessages;
        this.batchingMaxBytes = batchingMaxBytes;
        this.batchingEnabled = batchingEnabled;
        this.batcherBuilder = batcherBuilder;
        this.chunkingEnabled = chunkingEnabled;
        this.chunkMaxMessageSize = chunkMaxMessageSize;
        this.cryptoKeyReader = cryptoKeyReader;
        this.messageCrypto = messageCrypto;
        this.encryptionKeys = encryptionKeys;
        this.compressionType = compressionType;
        this.initialSequenceId = initialSequenceId;
        this.autoUpdatePartitions = autoUpdatePartitions;
        this.autoUpdatePartitionsIntervalSeconds = autoUpdatePartitionsIntervalSeconds;
        this.multiSchema = multiSchema;
        this.accessMode = accessMode;
        this.lazyStartPartitionedProducers = lazyStartPartitionedProducers;
        this.properties = properties;
        this.isNonPartitionedTopicExpected = isNonPartitionedTopicExpected;
        this.isReplProducer = isReplProducer;
        this.initialSubscriptionName = initialSubscriptionName;
    }

    @Generated
    public int getMaxPendingMessages() {
        return this.maxPendingMessages;
    }
}

